/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.layer.imagery;

import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import org.openstreetmap.gui.jmapviewer.interfaces.IProjected;

public class TileAnchor {
    protected final Point2D tileOrigin;
    protected final Point2D nextTileOrigin;

    public TileAnchor(Point2D point2D, Point2D point2D2) {
        this.tileOrigin = point2D;
        this.nextTileOrigin = point2D2;
    }

    public TileAnchor(IProjected iProjected, IProjected iProjected2) {
        this.tileOrigin = new Point2D.Double(iProjected.getEast(), iProjected.getNorth());
        this.nextTileOrigin = new Point2D.Double(iProjected2.getEast(), iProjected2.getNorth());
    }

    public Point2D getTileOrigin() {
        return this.tileOrigin;
    }

    public Point2D getNextTileOrigin() {
        return this.nextTileOrigin;
    }

    public String toString() {
        return "TileAnchor{" + this.tileOrigin + "; " + this.nextTileOrigin + '}';
    }

    public AffineTransform convert(TileAnchor tileAnchor) {
        Point2D point2D = this.getTileOrigin();
        Point2D point2D2 = this.getNextTileOrigin();
        Point2D point2D3 = tileAnchor.getTileOrigin();
        Point2D point2D4 = tileAnchor.getNextTileOrigin();
        double d = (point2D4.getX() - point2D3.getX()) / (point2D2.getX() - point2D.getX());
        double d2 = (point2D4.getY() - point2D3.getY()) / (point2D2.getY() - point2D.getY());
        double d3 = point2D3.getX() - d * point2D.getX();
        double d4 = point2D3.getY() - d2 * point2D.getY();
        return new AffineTransform(d, 0.0, 0.0, d2, d3, d4);
    }
}

