/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.layer.markerlayer;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Optional;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.data.gpx.Extensions;
import org.openstreetmap.josm.data.gpx.GpxLink;
import org.openstreetmap.josm.data.gpx.WayPoint;
import org.openstreetmap.josm.gui.layer.markerlayer.AudioMarker;
import org.openstreetmap.josm.gui.layer.markerlayer.ImageMarker;
import org.openstreetmap.josm.gui.layer.markerlayer.Marker;
import org.openstreetmap.josm.gui.layer.markerlayer.MarkerLayer;
import org.openstreetmap.josm.gui.layer.markerlayer.MarkerProducers;
import org.openstreetmap.josm.gui.layer.markerlayer.WebMarker;
import org.openstreetmap.josm.tools.Utils;
import org.openstreetmap.josm.tools.template_engine.TemplateEngineDataProvider;

public final class DefaultMarkerProducers
implements MarkerProducers {
    @Override
    public Collection<Marker> createMarkers(WayPoint wayPoint, File file, MarkerLayer markerLayer, double d, double d2) {
        Object object;
        Object object2;
        String string = null;
        Collection collection = wayPoint.getCollection("meta.links");
        if (collection != null && (object2 = collection.iterator()).hasNext()) {
            object = (GpxLink)object2.next();
            string = ((GpxLink)object).uri;
        }
        object = (object2 = DefaultMarkerProducers.uriToUrl(string, file)) == null ? "" : ((URL)object2).toString();
        String string2 = Optional.ofNullable(wayPoint.getString("symbol")).orElseGet(() -> wayPoint.getString("sym"));
        Marker marker = new Marker(wayPoint.getCoor(), wayPoint, string2, markerLayer, d, d2);
        if (object2 == null) {
            return Collections.singleton(marker);
        }
        if (((String)object).endsWith(".wav")) {
            AudioMarker audioMarker = new AudioMarker(wayPoint.getCoor(), (TemplateEngineDataProvider)wayPoint, (URL)object2, markerLayer, d, d2);
            Extensions extensions = (Extensions)wayPoint.get("meta.extensions");
            if (extensions != null && extensions.containsKey("offset")) {
                try {
                    audioMarker.syncOffset = Double.parseDouble((String)extensions.get("sync-offset"));
                }
                catch (NumberFormatException numberFormatException) {
                    Main.warn(numberFormatException);
                }
            }
            return Arrays.asList(marker, audioMarker);
        }
        if (((String)object).endsWith(".png") || ((String)object).endsWith(".jpg") || ((String)object).endsWith(".jpeg") || ((String)object).endsWith(".gif")) {
            return Arrays.asList(marker, new ImageMarker(wayPoint.getCoor(), (URL)object2, markerLayer, d, d2));
        }
        return Arrays.asList(marker, new WebMarker(wayPoint.getCoor(), (URL)object2, markerLayer, d, d2));
    }

    private static URL uriToUrl(String string, File file) {
        URL uRL;
        block3: {
            uRL = null;
            if (string != null) {
                try {
                    uRL = new URL(string);
                }
                catch (MalformedURLException malformedURLException) {
                    if (file == null) break block3;
                    uRL = Utils.fileToURL(new File(file.getParentFile(), string));
                }
            }
        }
        return uRL;
    }
}

