/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.preferences.advanced;

import java.awt.Component;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.table.AbstractTableModel;
import org.openstreetmap.josm.data.preferences.MapListSetting;
import org.openstreetmap.josm.gui.preferences.advanced.AbstractTableListEditor;
import org.openstreetmap.josm.gui.preferences.advanced.PrefEntry;
import org.openstreetmap.josm.tools.I18n;

public class MapListEditor
extends AbstractTableListEditor<Map<String, String>> {
    private final transient List<List<String>> dataKeys;
    private final transient List<List<String>> dataValues;

    public MapListEditor(JComponent jComponent, PrefEntry prefEntry, MapListSetting mapListSetting) {
        super((Component)jComponent, I18n.tr("Change list of maps setting", new Object[0]), prefEntry);
        List list = (List)mapListSetting.getValue();
        this.dataKeys = new ArrayList<List<String>>();
        this.dataValues = new ArrayList<List<String>>();
        if (list != null) {
            for (Map map : list) {
                ArrayList arrayList = new ArrayList();
                ArrayList arrayList2 = new ArrayList();
                for (Map.Entry entry : map.entrySet()) {
                    arrayList.add(entry.getKey());
                    arrayList2.add(entry.getValue());
                }
                this.dataKeys.add(arrayList);
                this.dataValues.add(arrayList2);
            }
        }
    }

    @Override
    public List<Map<String, String>> getData() {
        ArrayList<Map<String, String>> arrayList = new ArrayList<Map<String, String>>();
        for (int i = 0; i < this.dataKeys.size(); ++i) {
            LinkedHashMap<String, String> linkedHashMap = new LinkedHashMap<String, String>();
            for (int j = 0; j < this.dataKeys.get(i).size(); ++j) {
                linkedHashMap.put(this.dataKeys.get(i).get(j), this.dataValues.get(i).get(j));
            }
            arrayList.add(linkedHashMap);
        }
        return arrayList;
    }

    @Override
    protected final JPanel build() {
        this.table.getTableHeader().getColumnModel().getColumn(0).setHeaderValue(I18n.tr("Key", new Object[0]));
        this.table.getTableHeader().getColumnModel().getColumn(1).setHeaderValue(I18n.tr("Value", new Object[0]));
        return super.build();
    }

    @Override
    protected final AbstractTableListEditor.AbstractEntryListModel newEntryListModel() {
        return new EntryListModel();
    }

    @Override
    protected final AbstractTableModel newTableModel() {
        return new MapTableModel();
    }

    private class MapTableModel
    extends AbstractTableModel {
        private MapTableModel() {
        }

        private List<List<String>> data() {
            return MapListEditor.this.entryIdx == null ? Collections.emptyList() : Arrays.asList((List)MapListEditor.this.dataKeys.get(MapListEditor.this.entryIdx), (List)MapListEditor.this.dataValues.get(MapListEditor.this.entryIdx));
        }

        private int size() {
            return MapListEditor.this.entryIdx == null ? 0 : ((List)MapListEditor.this.dataKeys.get(MapListEditor.this.entryIdx)).size();
        }

        @Override
        public int getRowCount() {
            return MapListEditor.this.entryIdx == null ? 0 : this.size() + 1;
        }

        @Override
        public int getColumnCount() {
            return 2;
        }

        @Override
        public String getColumnName(int n) {
            return n == 0 ? I18n.tr("Key", new Object[0]) : I18n.tr("Value", new Object[0]);
        }

        @Override
        public Object getValueAt(int n, int n2) {
            return this.size() == n ? "" : this.data().get(n2).get(n);
        }

        @Override
        public void setValueAt(Object object, int n, int n2) {
            String string = (String)object;
            if (n == this.size()) {
                this.data().get(0).add("");
                this.data().get(1).add("");
                this.data().get(n2).set(n, string);
                this.fireTableRowsInserted(n + 1, n + 1);
            } else {
                this.data().get(n2).set(n, string);
                this.fireTableCellUpdated(n, n2);
            }
        }

        @Override
        public boolean isCellEditable(int n, int n2) {
            return true;
        }
    }

    private class EntryListModel
    extends AbstractTableListEditor.AbstractEntryListModel {
        private EntryListModel() {
        }

        @Override
        public String getElementAt(int n) {
            return I18n.tr("Entry {0}", n + 1);
        }

        @Override
        public int getSize() {
            return MapListEditor.this.dataKeys.size();
        }

        @Override
        public void add() {
            MapListEditor.this.dataKeys.add(new ArrayList());
            MapListEditor.this.dataValues.add(new ArrayList());
            this.fireIntervalAdded(this, this.getSize() - 1, this.getSize() - 1);
        }

        @Override
        public void remove(int n) {
            MapListEditor.this.dataKeys.remove(n);
            MapListEditor.this.dataValues.remove(n);
            this.fireIntervalRemoved(this, n, n);
        }
    }
}

