/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.util;

import java.awt.Component;
import java.awt.Cursor;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Objects;
import java.util.concurrent.CopyOnWriteArrayList;

public class CursorManager {
    private final LinkedHashMap<Object, Cursor> cursors = new LinkedHashMap();
    private final CopyOnWriteArrayList<Component> components = new CopyOnWriteArrayList();

    public CursorManager(Component component) {
        this.addComponent(component);
    }

    public synchronized void addComponent(Component component) {
        this.components.addIfAbsent(component);
        component.setCursor(this.getCurrentCursor());
    }

    public synchronized void removeComponent(Component component) {
        this.components.remove(component);
    }

    public synchronized void setNewCursor(Cursor cursor, Object object) {
        Objects.requireNonNull(object, "Cannot register a cursor that can never be removed.");
        this.cursors.remove(object);
        this.cursors.put(object, cursor);
        this.updateCursor();
    }

    public synchronized void resetCursor(Object object) {
        if (object == null) {
            return;
        }
        this.cursors.remove(object);
        this.updateCursor();
    }

    private void updateCursor() {
        Cursor cursor = this.getCurrentCursor();
        for (Component component : this.components) {
            component.setCursor(cursor);
        }
    }

    private Cursor getCurrentCursor() {
        Iterator<Cursor> iterator = this.cursors.values().iterator();
        Cursor cursor = null;
        while (iterator.hasNext()) {
            cursor = iterator.next();
        }
        return cursor;
    }
}

