/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.io;

import java.lang.reflect.InvocationTargetException;
import java.net.Authenticator;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.Objects;
import java.util.concurrent.FutureTask;
import javax.swing.SwingUtilities;
import oauth.signpost.OAuthConsumer;
import oauth.signpost.exception.OAuthException;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.data.oauth.OAuthParameters;
import org.openstreetmap.josm.gui.oauth.OAuthAuthorizationWizard;
import org.openstreetmap.josm.gui.preferences.server.OAuthAccessTokenHolder;
import org.openstreetmap.josm.io.MissingOAuthAccessTokenException;
import org.openstreetmap.josm.io.OsmApi;
import org.openstreetmap.josm.io.OsmTransferException;
import org.openstreetmap.josm.io.auth.CredentialsAgentException;
import org.openstreetmap.josm.io.auth.CredentialsAgentResponse;
import org.openstreetmap.josm.io.auth.CredentialsManager;
import org.openstreetmap.josm.tools.HttpClient;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Utils;

public class OsmConnection {
    protected boolean cancel;
    protected HttpClient activeConnection;
    protected OAuthParameters oauthParameters;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cancel() {
        this.cancel = true;
        OsmConnection osmConnection = this;
        synchronized (osmConnection) {
            if (this.activeConnection != null) {
                this.activeConnection.disconnect();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addBasicAuthorizationHeader(HttpClient httpClient) throws OsmTransferException {
        CredentialsAgentResponse credentialsAgentResponse;
        Object object;
        try {
            object = CredentialsManager.getInstance();
            synchronized (object) {
                credentialsAgentResponse = CredentialsManager.getInstance().getCredentials(Authenticator.RequestorType.SERVER, httpClient.getURL().getHost(), false);
            }
        }
        catch (CredentialsAgentException credentialsAgentException) {
            throw new OsmTransferException(credentialsAgentException);
        }
        if (credentialsAgentResponse != null) {
            if (credentialsAgentResponse.isCanceled()) {
                this.cancel = true;
                return;
            }
            object = credentialsAgentResponse.getUsername() == null ? "" : credentialsAgentResponse.getUsername();
            String string = credentialsAgentResponse.getPassword() == null ? "" : String.valueOf(credentialsAgentResponse.getPassword());
            String string2 = (String)object + ':' + string;
            httpClient.setHeader("Authorization", "Basic " + Base64.getEncoder().encodeToString(string2.getBytes(StandardCharsets.UTF_8)));
        }
    }

    protected void addOAuthAuthorizationHeader(HttpClient httpClient) throws OsmTransferException {
        if (this.oauthParameters == null) {
            this.oauthParameters = OAuthParameters.createFromPreferences(Main.pref);
        }
        OAuthConsumer oAuthConsumer = this.oauthParameters.buildConsumer();
        OAuthAccessTokenHolder oAuthAccessTokenHolder = OAuthAccessTokenHolder.getInstance();
        if (!oAuthAccessTokenHolder.containsAccessToken()) {
            this.obtainAccessToken(httpClient);
        }
        if (!oAuthAccessTokenHolder.containsAccessToken()) {
            throw new MissingOAuthAccessTokenException();
        }
        oAuthConsumer.setTokenWithSecret(oAuthAccessTokenHolder.getAccessTokenKey(), oAuthAccessTokenHolder.getAccessTokenSecret());
        try {
            oAuthConsumer.sign(httpClient);
        }
        catch (OAuthException oAuthException) {
            throw new OsmTransferException(I18n.tr("Failed to sign a HTTP connection with an OAuth Authentication header", new Object[0]), oAuthException);
        }
    }

    protected void obtainAccessToken(HttpClient httpClient) throws MissingOAuthAccessTokenException {
        try {
            URL uRL = new URL(OsmApi.getOsmApi().getServerUrl());
            if (!Objects.equals(uRL.getHost(), httpClient.getURL().getHost())) {
                throw new MissingOAuthAccessTokenException();
            }
            FutureTask<OAuthAuthorizationWizard> futureTask = new FutureTask<OAuthAuthorizationWizard>(() -> {
                OAuthAuthorizationWizard oAuthAuthorizationWizard = new OAuthAuthorizationWizard(Main.parent, uRL.toExternalForm(), Utils.newDirectExecutor());
                oAuthAuthorizationWizard.showDialog();
                OAuthAccessTokenHolder.getInstance().setSaveToPreferences(true);
                OAuthAccessTokenHolder.getInstance().save(Main.pref, CredentialsManager.getInstance());
                return oAuthAuthorizationWizard;
            });
            if (SwingUtilities.isEventDispatchThread()) {
                futureTask.run();
            } else {
                SwingUtilities.invokeAndWait(futureTask);
            }
        }
        catch (InterruptedException | InvocationTargetException | MalformedURLException exception) {
            throw new MissingOAuthAccessTokenException(exception);
        }
    }

    protected void addAuth(HttpClient httpClient) throws OsmTransferException {
        String string = OsmApi.getAuthMethod();
        if ("basic".equals(string)) {
            this.addBasicAuthorizationHeader(httpClient);
        } else if ("oauth".equals(string)) {
            this.addOAuthAuthorizationHeader(httpClient);
        } else {
            String string2 = I18n.tr("Unexpected value for preference ''{0}''. Got ''{1}''.", "osm-server.auth-method", string);
            Main.warn(string2);
            throw new OsmTransferException(string2);
        }
    }

    public boolean isCanceled() {
        return this.cancel;
    }
}

