/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.tools.bugreport;

import java.awt.Component;
import java.awt.GridBagLayout;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.gui.widgets.JMultilineLabel;
import org.openstreetmap.josm.gui.widgets.UrlLabel;
import org.openstreetmap.josm.tools.GBC;
import org.openstreetmap.josm.tools.HttpClient;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.OpenBrowser;
import org.openstreetmap.josm.tools.Utils;
import org.openstreetmap.josm.tools.bugreport.DebugTextDisplay;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;

public class BugReportSender
extends Thread {
    private final String statusText;
    private String errorMessage;

    protected BugReportSender(String string) {
        super("Bug report sender");
        this.statusText = string;
    }

    @Override
    public void run() {
        try {
            String string = this.pasteDebugText();
            String string2 = OpenBrowser.displayUrl(BugReportSender.getJOSMTicketURL() + "?pdata_stored=" + string);
            if (string2 != null) {
                Main.warn(string2);
                this.failed(string2);
            }
        }
        catch (BugReportSenderException bugReportSenderException) {
            Main.warn(bugReportSenderException);
            this.failed(bugReportSenderException.getMessage());
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String pasteDebugText() throws BugReportSenderException {
        try {
            String string = Utils.strip(this.statusText);
            String string2 = Base64.getEncoder().encodeToString(string.getBytes(StandardCharsets.UTF_8));
            String string3 = "pdata=" + URLEncoder.encode(string2, "UTF-8");
            HttpClient httpClient = HttpClient.create(new URL(BugReportSender.getJOSMTicketURL()), "POST").setHeader("Content-Type", "application/x-www-form-urlencoded").setRequestBody(string3.getBytes(StandardCharsets.UTF_8));
            HttpClient.Response response = httpClient.connect();
            if (response.getResponseCode() >= 500) {
                throw new BugReportSenderException("Internal server error.");
            }
            try (InputStream inputStream = response.getContent();){
                String string4 = BugReportSender.retrieveDebugToken(Utils.parseSafeDOM(inputStream));
                return string4;
            }
        }
        catch (IOException | ParserConfigurationException | XPathExpressionException | SAXException exception) {
            throw new BugReportSenderException(exception);
        }
    }

    private static String getJOSMTicketURL() {
        return Main.getJOSMWebsite() + "/josmticket";
    }

    private static String retrieveDebugToken(Document document) throws XPathExpressionException, BugReportSenderException {
        XPathFactory xPathFactory = XPathFactory.newInstance();
        XPath xPath = xPathFactory.newXPath();
        String string = (String)xPath.compile("/josmticket/@status").evaluate(document, XPathConstants.STRING);
        if (!"ok".equals(string)) {
            String string2 = (String)xPath.compile("/josmticket/error/text()").evaluate(document, XPathConstants.STRING);
            if (string2.isEmpty()) {
                string2 = "Error in server response but server did not tell us what happened.";
            }
            throw new BugReportSenderException(string2);
        }
        String string3 = (String)xPath.compile("/josmticket/preparedid/text()").evaluate(document, XPathConstants.STRING);
        if (string3.isEmpty()) {
            throw new BugReportSenderException("Server did not respond with a prepared id.");
        }
        return string3;
    }

    private void failed(String string) {
        this.errorMessage = string;
        SwingUtilities.invokeLater(() -> {
            JPanel jPanel = new JPanel(new GridBagLayout());
            jPanel.add((Component)new JMultilineLabel(I18n.tr("Opening the bug report failed. Please report manually using this website:", new Object[0])), GBC.eol().fill(2));
            jPanel.add((Component)new UrlLabel(Main.getJOSMWebsite() + "/newticket", 2), GBC.eop().insets(8, 0, 0, 0));
            jPanel.add(new DebugTextDisplay(this.statusText));
            JOptionPane.showMessageDialog(Main.parent, jPanel, I18n.tr("You have encountered a bug in JOSM", new Object[0]), 0);
        });
    }

    public final String getErrorMessage() {
        return this.errorMessage;
    }

    public static BugReportSender reportBug(String string) {
        BugReportSender bugReportSender = new BugReportSender(string);
        bugReportSender.start();
        return bugReportSender;
    }

    private static class BugReportSenderException
    extends Exception {
        BugReportSenderException(String string) {
            super(string);
        }

        BugReportSenderException(Throwable throwable) {
            super(throwable);
        }
    }
}

