package Lire::Config::DlfStreamsSpec;

use strict;

use base qw/Lire::Config::ListSpec/;

use Lire::DlfSchema;
use Lire::Config::DlfStreamSpec;
use Lire::Utils qw/check_param/;


=pod

=head1 NAME

Lire::Config::DlfStreamsSpec - Holds DlfStream configuration.

=head1 DESCRIPTION

This Lire::Config::TypeSpec is a ListSpec which defines virtually one
Lire::Config::DlfStreamSpec for each available schemas.

This ListSpec subclass overrides the has_component() and get() methods
to make a Lire::Config::DlfStreamSpec available for each defined schemas.

=cut

sub has_component {
    my ( $self, $name ) = @_;

    return ( $self->SUPER::has_component( $name )
             || Lire::DlfSchema->has_schema( $name ) );
}


sub get {
    my ( $self, $name ) = @_;

    check_param( $name, 'name' );

    $self->add( new Lire::Config::DlfStreamSpec( 'name' => $name ) )
      if ( $self->has_component( $name )
           && ! $self->SUPER::has_component( $name ) );

    return $self->SUPER::get( $name );
}

1;

__END__

=pod

=head2 SEE ALSO

  Lire::Config::DlfStreamsSpec(3pm), Lire::Config::DlfAnalyserSpec(3pm)

=head1 VERSION

$Id: DlfStreamsSpec.pm,v 1.2 2006/07/23 13:16:30 vanbaal Exp $

=head1 AUTHORS

  Francis J. Lacoste <flacoste@logreport.org>

=head1 COPYRIGHT

Copyright (C) 2004  Stichting LogReport Foundation LogReport@LogReport.org

This file is part of Lire.

Lire is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program (see COPYING); if not, check with
http://www.gnu.org/copyleft/gpl.html.

=cut
