/*
 * Decompiled with CFR 0.152.
 */
package proguard.classfile.editor;

import proguard.classfile.Clazz;
import proguard.classfile.Member;
import proguard.classfile.ProgramClass;
import proguard.classfile.constant.ClassConstant;
import proguard.classfile.constant.Constant;
import proguard.classfile.constant.DoubleConstant;
import proguard.classfile.constant.FieldrefConstant;
import proguard.classfile.constant.FloatConstant;
import proguard.classfile.constant.IntegerConstant;
import proguard.classfile.constant.InterfaceMethodrefConstant;
import proguard.classfile.constant.InvokeDynamicConstant;
import proguard.classfile.constant.LongConstant;
import proguard.classfile.constant.MethodHandleConstant;
import proguard.classfile.constant.MethodTypeConstant;
import proguard.classfile.constant.MethodrefConstant;
import proguard.classfile.constant.NameAndTypeConstant;
import proguard.classfile.constant.StringConstant;
import proguard.classfile.constant.Utf8Constant;

public class ConstantPoolEditor {
    private static final boolean DEBUG = false;
    private ProgramClass targetClass;

    public ConstantPoolEditor(ProgramClass programClass) {
        this.targetClass = programClass;
    }

    public int addIntegerConstant(int n) {
        int n2 = this.targetClass.u2constantPoolCount;
        Constant[] constantArray = this.targetClass.constantPool;
        for (int i = 1; i < n2; ++i) {
            IntegerConstant integerConstant;
            Constant constant = constantArray[i];
            if (constant == null || constant.getTag() != 3 || (integerConstant = (IntegerConstant)constant).getValue() != n) continue;
            return i;
        }
        return this.addConstant(new IntegerConstant(n));
    }

    public int addLongConstant(long l) {
        int n = this.targetClass.u2constantPoolCount;
        Constant[] constantArray = this.targetClass.constantPool;
        for (int i = 1; i < n; ++i) {
            LongConstant longConstant;
            Constant constant = constantArray[i];
            if (constant == null || constant.getTag() != 5 || (longConstant = (LongConstant)constant).getValue() != l) continue;
            return i;
        }
        return this.addConstant(new LongConstant(l));
    }

    public int addFloatConstant(float f) {
        int n = this.targetClass.u2constantPoolCount;
        Constant[] constantArray = this.targetClass.constantPool;
        for (int i = 1; i < n; ++i) {
            FloatConstant floatConstant;
            Constant constant = constantArray[i];
            if (constant == null || constant.getTag() != 4 || (floatConstant = (FloatConstant)constant).getValue() != f) continue;
            return i;
        }
        return this.addConstant(new FloatConstant(f));
    }

    public int addDoubleConstant(double d) {
        int n = this.targetClass.u2constantPoolCount;
        Constant[] constantArray = this.targetClass.constantPool;
        for (int i = 1; i < n; ++i) {
            DoubleConstant doubleConstant;
            Constant constant = constantArray[i];
            if (constant == null || constant.getTag() != 6 || (doubleConstant = (DoubleConstant)constant).getValue() != d) continue;
            return i;
        }
        return this.addConstant(new DoubleConstant(d));
    }

    public int addStringConstant(String string, Clazz clazz, Member member) {
        int n = this.targetClass.u2constantPoolCount;
        Constant[] constantArray = this.targetClass.constantPool;
        for (int i = 1; i < n; ++i) {
            StringConstant stringConstant;
            Constant constant = constantArray[i];
            if (constant == null || constant.getTag() != 8 || !(stringConstant = (StringConstant)constant).getString(this.targetClass).equals(string)) continue;
            return i;
        }
        return this.addConstant(new StringConstant(this.addUtf8Constant(string), clazz, member));
    }

    public int addInvokeDynamicConstant(int n, String string, String string2, Clazz[] clazzArray) {
        return this.addInvokeDynamicConstant(n, this.addNameAndTypeConstant(string, string2), clazzArray);
    }

    public int addInvokeDynamicConstant(int n, int n2, Clazz[] clazzArray) {
        int n3 = this.targetClass.u2constantPoolCount;
        Constant[] constantArray = this.targetClass.constantPool;
        for (int i = 1; i < n3; ++i) {
            Constant constant = constantArray[i];
            if (constant == null || constant.getTag() != 18) continue;
            InvokeDynamicConstant invokeDynamicConstant = (InvokeDynamicConstant)constant;
            if (invokeDynamicConstant.u2bootstrapMethodAttributeIndex != n || invokeDynamicConstant.u2nameAndTypeIndex != n2) continue;
            return i;
        }
        return this.addConstant(new InvokeDynamicConstant(n, n2, clazzArray));
    }

    public int addMethodHandleConstant(int n, int n2) {
        int n3 = this.targetClass.u2constantPoolCount;
        Constant[] constantArray = this.targetClass.constantPool;
        for (int i = 1; i < n3; ++i) {
            Constant constant = constantArray[i];
            if (constant == null || constant.getTag() != 15) continue;
            MethodHandleConstant methodHandleConstant = (MethodHandleConstant)constant;
            if (methodHandleConstant.u1referenceKind != n || methodHandleConstant.u2referenceIndex != n2) continue;
            return i;
        }
        return this.addConstant(new MethodHandleConstant(n, n2));
    }

    public int addFieldrefConstant(Clazz clazz, Member member) {
        return this.addFieldrefConstant(clazz.getName(), member.getName(clazz), member.getDescriptor(clazz), clazz, member);
    }

    public int addFieldrefConstant(String string, String string2, String string3, Clazz clazz, Member member) {
        return this.addFieldrefConstant(string, this.addNameAndTypeConstant(string2, string3), clazz, member);
    }

    public int addFieldrefConstant(String string, int n, Clazz clazz, Member member) {
        return this.addFieldrefConstant(this.addClassConstant(string, clazz), n, clazz, member);
    }

    public int addFieldrefConstant(int n, String string, String string2, Clazz clazz, Member member) {
        return this.addFieldrefConstant(n, this.addNameAndTypeConstant(string, string2), clazz, member);
    }

    public int addFieldrefConstant(int n, int n2, Clazz clazz, Member member) {
        int n3 = this.targetClass.u2constantPoolCount;
        Constant[] constantArray = this.targetClass.constantPool;
        for (int i = 1; i < n3; ++i) {
            Constant constant = constantArray[i];
            if (constant == null || constant.getTag() != 9) continue;
            FieldrefConstant fieldrefConstant = (FieldrefConstant)constant;
            if (fieldrefConstant.u2classIndex != n || fieldrefConstant.u2nameAndTypeIndex != n2) continue;
            return i;
        }
        return this.addConstant(new FieldrefConstant(n, n2, clazz, member));
    }

    public int addInterfaceMethodrefConstant(String string, String string2, String string3, Clazz clazz, Member member) {
        return this.addInterfaceMethodrefConstant(string, this.addNameAndTypeConstant(string2, string3), clazz, member);
    }

    public int addInterfaceMethodrefConstant(String string, int n, Clazz clazz, Member member) {
        return this.addInterfaceMethodrefConstant(this.addClassConstant(string, clazz), n, clazz, member);
    }

    public int addInterfaceMethodrefConstant(Clazz clazz, Member member) {
        return this.addInterfaceMethodrefConstant(clazz.getName(), member.getName(clazz), member.getDescriptor(clazz), clazz, member);
    }

    public int addInterfaceMethodrefConstant(int n, String string, String string2, Clazz clazz, Member member) {
        return this.addInterfaceMethodrefConstant(n, this.addNameAndTypeConstant(string, string2), clazz, member);
    }

    public int addInterfaceMethodrefConstant(int n, int n2, Clazz clazz, Member member) {
        int n3 = this.targetClass.u2constantPoolCount;
        Constant[] constantArray = this.targetClass.constantPool;
        for (int i = 1; i < n3; ++i) {
            Constant constant = constantArray[i];
            if (constant == null || constant.getTag() != 11) continue;
            InterfaceMethodrefConstant interfaceMethodrefConstant = (InterfaceMethodrefConstant)constant;
            if (interfaceMethodrefConstant.u2classIndex != n || interfaceMethodrefConstant.u2nameAndTypeIndex != n2) continue;
            return i;
        }
        return this.addConstant(new InterfaceMethodrefConstant(n, n2, clazz, member));
    }

    public int addMethodrefConstant(Clazz clazz, Member member) {
        return this.addMethodrefConstant(clazz.getName(), member.getName(clazz), member.getDescriptor(clazz), clazz, member);
    }

    public int addMethodrefConstant(String string, String string2, String string3, Clazz clazz, Member member) {
        return this.addMethodrefConstant(string, this.addNameAndTypeConstant(string2, string3), clazz, member);
    }

    public int addMethodrefConstant(String string, int n, Clazz clazz, Member member) {
        return this.addMethodrefConstant(this.addClassConstant(string, clazz), n, clazz, member);
    }

    public int addMethodrefConstant(int n, String string, String string2, Clazz clazz, Member member) {
        return this.addMethodrefConstant(n, this.addNameAndTypeConstant(string, string2), clazz, member);
    }

    public int addMethodrefConstant(int n, int n2, Clazz clazz, Member member) {
        int n3 = this.targetClass.u2constantPoolCount;
        Constant[] constantArray = this.targetClass.constantPool;
        for (int i = 1; i < n3; ++i) {
            Constant constant = constantArray[i];
            if (constant == null || constant.getTag() != 10) continue;
            MethodrefConstant methodrefConstant = (MethodrefConstant)constant;
            if (methodrefConstant.u2classIndex != n || methodrefConstant.u2nameAndTypeIndex != n2) continue;
            return i;
        }
        return this.addConstant(new MethodrefConstant(n, n2, clazz, member));
    }

    public int addClassConstant(Clazz clazz) {
        return this.addClassConstant(clazz.getName(), clazz);
    }

    public int addClassConstant(String string, Clazz clazz) {
        int n;
        int n2 = this.targetClass.u2constantPoolCount;
        Constant[] constantArray = this.targetClass.constantPool;
        for (n = 1; n < n2; ++n) {
            ClassConstant classConstant;
            Constant constant = constantArray[n];
            if (constant == null || constant.getTag() != 7 || !(classConstant = (ClassConstant)constant).getName(this.targetClass).equals(string)) continue;
            return n;
        }
        n = this.addUtf8Constant(string);
        return this.addConstant(new ClassConstant(n, clazz));
    }

    public int addMethodTypeConstant(String string, Clazz[] clazzArray) {
        int n = this.targetClass.u2constantPoolCount;
        Constant[] constantArray = this.targetClass.constantPool;
        for (int i = 1; i < n; ++i) {
            MethodTypeConstant methodTypeConstant;
            Constant constant = constantArray[i];
            if (constant == null || constant.getTag() != 16 || !(methodTypeConstant = (MethodTypeConstant)constant).getType(this.targetClass).equals(string)) continue;
            return i;
        }
        return this.addConstant(new MethodTypeConstant(this.addUtf8Constant(string), clazzArray));
    }

    public int addNameAndTypeConstant(String string, String string2) {
        int n = this.targetClass.u2constantPoolCount;
        Constant[] constantArray = this.targetClass.constantPool;
        for (int i = 1; i < n; ++i) {
            NameAndTypeConstant nameAndTypeConstant;
            Constant constant = constantArray[i];
            if (constant == null || constant.getTag() != 12 || !(nameAndTypeConstant = (NameAndTypeConstant)constant).getName(this.targetClass).equals(string) || !nameAndTypeConstant.getType(this.targetClass).equals(string2)) continue;
            return i;
        }
        return this.addConstant(new NameAndTypeConstant(this.addUtf8Constant(string), this.addUtf8Constant(string2)));
    }

    public int addUtf8Constant(String string) {
        int n = this.targetClass.u2constantPoolCount;
        Constant[] constantArray = this.targetClass.constantPool;
        for (int i = 1; i < n; ++i) {
            Utf8Constant utf8Constant;
            Constant constant = constantArray[i];
            if (constant == null || constant.getTag() != 1 || !(utf8Constant = (Utf8Constant)constant).getString().equals(string)) continue;
            return i;
        }
        return this.addConstant(new Utf8Constant(string));
    }

    public int addConstant(Constant constant) {
        Constant[] constantArray = this.targetClass.constantPool;
        int n = this.targetClass.u2constantPoolCount;
        if (constantArray.length < n + 2) {
            this.targetClass.constantPool = new Constant[n + 2];
            System.arraycopy(constantArray, 0, this.targetClass.constantPool, 0, n);
            constantArray = this.targetClass.constantPool;
        }
        constantArray[this.targetClass.u2constantPoolCount++] = constant;
        int n2 = constant.getTag();
        if (n2 == 5 || n2 == 6) {
            constantArray[this.targetClass.u2constantPoolCount++] = null;
        }
        return n;
    }
}

