/*
 * Decompiled with CFR 0.152.
 */
package ch.ehi.umleditor.umldrawingtools;

import CH.ifa.draw.contrib.zoom.ZoomDrawingView;
import CH.ifa.draw.framework.ConnectionFigure;
import CH.ifa.draw.framework.Connector;
import CH.ifa.draw.framework.DrawingEditor;
import CH.ifa.draw.framework.Figure;
import CH.ifa.draw.framework.FigureEnumeration;
import CH.ifa.draw.standard.StandardDrawing;
import ch.ehi.basics.tools.TopoSort;
import ch.ehi.interlis.associations.AssociationDef;
import ch.ehi.interlis.associations.Participant;
import ch.ehi.interlis.associations.RoleDef;
import ch.ehi.interlis.domainsandconstants.DomainDef;
import ch.ehi.interlis.modeltopicclass.AbstractClassDef;
import ch.ehi.interlis.modeltopicclass.ClassDef;
import ch.ehi.interlis.modeltopicclass.INTERLIS2Def;
import ch.ehi.interlis.modeltopicclass.ModelDef;
import ch.ehi.interlis.modeltopicclass.TopicDef;
import ch.ehi.uml1_4.changepropagation.MetaModelChange;
import ch.ehi.uml1_4.foundation.core.AssociationEnd;
import ch.ehi.uml1_4.foundation.core.Classifier;
import ch.ehi.uml1_4.foundation.core.Dependency;
import ch.ehi.uml1_4.foundation.core.Element;
import ch.ehi.uml1_4.foundation.core.Feature;
import ch.ehi.uml1_4.foundation.core.GeneralizableElement;
import ch.ehi.uml1_4.foundation.core.ModelElement;
import ch.ehi.uml1_4.foundation.core.Namespace;
import ch.ehi.uml1_4.foundation.core.PresentationElement;
import ch.ehi.uml1_4.implementation.AbstractModelElement;
import ch.ehi.uml1_4.implementation.UmlModel;
import ch.ehi.uml1_4.implementation.UmlPackage;
import ch.ehi.umleditor.application.ElementFactory;
import ch.ehi.umleditor.application.ElementUtils;
import ch.ehi.umleditor.application.LauncherView;
import ch.ehi.umleditor.umldrawingtools.AssociationAttributeFigure;
import ch.ehi.umleditor.umldrawingtools.AssociationLineConnection;
import ch.ehi.umleditor.umldrawingtools.ClassFigure;
import ch.ehi.umleditor.umldrawingtools.ColorConverter;
import ch.ehi.umleditor.umldrawingtools.DependencyLineConnection;
import ch.ehi.umleditor.umldrawingtools.DrawingFrame;
import ch.ehi.umleditor.umldrawingtools.EdgeFigure;
import ch.ehi.umleditor.umldrawingtools.GeneralizationLineConnection;
import ch.ehi.umleditor.umldrawingtools.LinkFigure;
import ch.ehi.umleditor.umldrawingtools.ModelElementUI;
import ch.ehi.umleditor.umldrawingtools.NodeFigure;
import ch.ehi.umleditor.umldrawingtools.NoteAnchorLineConnection;
import ch.ehi.umleditor.umldrawingtools.NoteFigure;
import ch.ehi.umleditor.umldrawingtools.PackageFigure;
import ch.ehi.umleditor.umldrawingtools.PresentationRoleFigure;
import ch.ehi.umleditor.umldrawingtools.RoleDefFigure;
import ch.ehi.umleditor.umlpresentation.Association;
import ch.ehi.umleditor.umlpresentation.Diagram;
import ch.ehi.umleditor.umlpresentation.Generalization;
import ch.ehi.umleditor.umlpresentation.Note;
import ch.ehi.umleditor.umlpresentation.NoteEdge;
import ch.ehi.umleditor.umlpresentation.Package;
import ch.ehi.umleditor.umlpresentation.PresentationAbstractClass;
import ch.ehi.umleditor.umlpresentation.PresentationAssocClass;
import ch.ehi.umleditor.umlpresentation.PresentationEdge;
import ch.ehi.umleditor.umlpresentation.PresentationNode;
import ch.ehi.umleditor.umlpresentation.PresentationRole;
import ch.ehi.umleditor.umlpresentation.WayPoint;
import ch.softenvironment.util.DeveloperException;
import ch.softenvironment.util.NlsUtils;
import ch.softenvironment.util.Tracer;
import ch.softenvironment.view.BaseDialog;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.event.KeyEvent;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class ClassDiagramView
extends ZoomDrawingView {
    private Diagram diagram = null;
    private Element parentElement = null;
    private boolean showAssociationNames = false;
    private boolean showAttributes = true;
    private boolean showLinkFigure = false;
    private boolean showRoles = true;
    private boolean showMultiplicity = false;
    private boolean loading = false;
    private Map xorNotes = new HashMap();
    private boolean tryAssociations = true;

    protected void addXorNote(RoleDef roleDef, Dimension position) {
        if (!this.xorNotes.containsKey(roleDef)) {
            this.xorNotes.put(roleDef, position);
        }
    }

    protected void removeXorNote(Object roleDefOrParticipant) {
        RoleDef roleDef = null;
        if (roleDefOrParticipant instanceof RoleDef) {
            roleDef = (RoleDef)roleDefOrParticipant;
        } else if (roleDefOrParticipant instanceof Participant) {
            roleDef = ((Participant)roleDefOrParticipant).getAssociation();
        }
        if (roleDef != null && this.xorNotes.containsKey(roleDef)) {
            this.xorNotes.remove(roleDef);
        }
    }

    protected Dimension getXorNote(RoleDef roleDef) {
        if (this.xorNotes.containsKey(roleDef)) {
            return (Dimension)this.xorNotes.get(roleDef);
        }
        return null;
    }

    public ClassDiagramView(DrawingEditor editor, Diagram diagram) {
        super(editor);
        this.setDrawing(new StandardDrawing());
        this.setBackground(LauncherView.getSettings().getBackgroundColor());
        this.diagram = diagram;
    }

    public Figure add(Element element) {
        Iterator iterator = this.getDiagram().iteratorPresentationElement();
        while (iterator.hasNext()) {
            PresentationElement presentationElement = (PresentationElement)iterator.next();
            Iterator subjects = presentationElement.iteratorSubject();
            while (subjects.hasNext()) {
                ModelElement modelElement = (ModelElement)subjects.next();
                if (!modelElement.equals(element)) continue;
                BaseDialog.showWarning(LauncherView.getInstance(), NodeFigure.getResourceString(ClassDiagramView.class, "CTAddElement"), NlsUtils.formatMessage(NodeFigure.getResourceString(ClassDiagramView.class, "CWElementAdded"), modelElement.getDefLangName()));
                return null;
            }
        }
        if (element instanceof AssociationDef) {
            Figure edge = this.saveAssociation((AssociationDef)element);
            Iterator it = ((AssociationDef)element).iteratorConnection();
            while (it.hasNext()) {
                RoleDef role = (RoleDef)it.next();
                Iterator xorIt = role.iteratorXorParticipant();
                while (xorIt.hasNext()) {
                    Participant p = (Participant)xorIt.next();
                    this.checkXorRole(p.getParticipant());
                }
            }
            return edge;
        }
        if (ClassDiagramView.isDrawablePackage(element.getClass())) {
            return this.savePackageFigure((ModelElement)element, new PackageFigure());
        }
        if (element instanceof Classifier || ClassFigure.isPseudoClassifier(element)) {
            return this.saveClassFigure((AbstractModelElement)element, new ClassFigure());
        }
        if (element instanceof Association) {
            return this.saveAssociationComposite((Association)element);
        }
        if (element instanceof RoleDef) {
            return this.loadPresentationRole((RoleDef)element, null);
        }
        throw new DeveloperException(NlsUtils.formatMessage(NodeFigure.getResourceString(ClassDiagramView.class, "CEInvalidType"), element.toString()));
    }

    @Override
    public Figure add(Figure figure) {
        try {
            if (figure instanceof AssociationAttributeFigure) {
                super.add(figure);
            } else if (figure instanceof ClassFigure) {
                this.saveClassFigure(ElementFactory.createClassDef(this.getParentElement()), figure);
            } else if (figure instanceof PackageFigure) {
                ModelElement packageDef = ElementFactory.createOwnedElement(this.determinePackageModelElementClass(), this.getParentElement());
                this.savePackageFigure(packageDef, figure);
            } else if (figure instanceof NoteFigure) {
                Note note = ElementFactory.createNote();
                ((NoteFigure)figure).setClassDiagram(this);
                ((NoteFigure)figure).setNode(note);
                this.saveNodeInDiagram(note, figure);
            } else if (figure instanceof EdgeFigure || figure instanceof LinkFigure || figure instanceof RoleDefFigure) {
                super.add(figure);
            }
        }
        catch (Throwable e) {
            BaseDialog.showError(LauncherView.getInstance(), ModelElementUI.CREATION_ERROR, NodeFigure.getResourceString(ClassDiagramView.class, "CEFigureNotCreated"), e);
        }
        return figure;
    }

    private Figure addClassifier(RoleDef roleDef) {
        Figure figure = this.findFigure(roleDef.getParticipant());
        if (figure == null) {
            this.tryAssociations = false;
            figure = this.add(roleDef.getParticipant());
            this.tryAssociations = true;
        }
        return figure;
    }

    public boolean allowsClasses() {
        return ClassDiagramView.allowsClasses(this.getParentElement());
    }

    public static boolean allowsClasses(Element element) {
        String[] validOwnedElements;
        if (element instanceof Namespace && (validOwnedElements = ((Namespace)element).getValidOwnedElements()) != null) {
            for (int i = 0; i < validOwnedElements.length; ++i) {
                try {
                    if (Class.forName(validOwnedElements[i]).equals(ClassDef.class)) {
                        return true;
                    }
                    continue;
                }
                catch (ClassNotFoundException e) {
                    Tracer.getInstance().developerError("Class <" + validOwnedElements[i] + "> does not exist!");
                }
            }
        }
        return false;
    }

    public boolean allowsPackages() {
        return ClassDiagramView.allowsPackages(this.getParentElement());
    }

    public static boolean allowsPackages(Element element) {
        String[] validOwnedElements;
        if (element instanceof Namespace && (validOwnedElements = ((Namespace)element).getValidOwnedElements()) != null) {
            for (int i = 0; i < validOwnedElements.length; ++i) {
                try {
                    Class<?> possibleClass = Class.forName(validOwnedElements[i]);
                    if (ClassDiagramView.isDrawablePackage(possibleClass)) {
                        return true;
                    }
                    continue;
                }
                catch (ClassNotFoundException e) {
                    Tracer.getInstance().developerError("Class <" + validOwnedElements[i] + "> does not exist!");
                }
            }
        }
        return false;
    }

    private Class determinePackageModelElementClass() {
        if (this.getParentElement() instanceof UmlModel) {
            return INTERLIS2Def.class;
        }
        if (this.parentElement instanceof INTERLIS2Def) {
            return ModelDef.class;
        }
        if (this.parentElement instanceof ModelDef) {
            return TopicDef.class;
        }
        return UmlPackage.class;
    }

    protected Connector findAssociationAttributeConnector(Element startEndElement, int x, int y, Element modelElement) {
        LinkFigure linkFigure = (LinkFigure)this.findFigure(startEndElement);
        if (linkFigure == null) {
            return null;
        }
        AssociationAttributeFigure attrFigure = linkFigure.showAttributeFigure(startEndElement, modelElement);
        if (attrFigure == null) {
            return null;
        }
        return attrFigure.connectorAt(x, y);
    }

    protected ClassFigure findClassFigure(int x, int y) {
        FigureEnumeration enumeration = this.drawing().figures();
        while (enumeration.hasMoreElements()) {
            Figure figure = enumeration.nextFigure();
            if (!(figure instanceof ClassFigure) || figure instanceof AssociationAttributeFigure || !figure.containsPoint(x, y)) continue;
            return (ClassFigure)figure;
        }
        return null;
    }

    protected Figure findConnectableFigure(int x, int y, ConnectionFigure connection) {
        FigureEnumeration k = this.drawing().figuresReverse();
        while (k.hasMoreElements()) {
            Figure figure = k.nextFigure();
            if (figure.includes(connection) || !figure.canConnect() || !figure.containsPoint(x, y)) continue;
            return figure;
        }
        return null;
    }

    protected ConnectionFigure findConnection(int x, int y) {
        FigureEnumeration k = this.drawing().figuresReverse();
        while (k.hasMoreElements()) {
            Figure figure = (Figure)k.nextElement();
            if ((figure = figure.findFigureInside(x, y)) == null || !(figure instanceof ConnectionFigure)) continue;
            return (ConnectionFigure)figure;
        }
        return null;
    }

    protected Figure findFigure(Element element) {
        if (element != null) {
            FigureEnumeration enumeration = this.drawing().figures();
            while (enumeration.hasMoreElements()) {
                Figure figure = enumeration.nextFigure();
                if (figure instanceof RoleDefFigure || figure instanceof AssociationAttributeFigure || !(element instanceof PresentationElement ? (figure instanceof NodeFigure ? element.equals(((NodeFigure)figure).getNode()) : figure instanceof EdgeFigure && element.equals(((EdgeFigure)figure).getEdge())) : (figure instanceof ClassFigure || figure instanceof PackageFigure || figure instanceof LinkFigure ? element.equals(((NodeFigure)figure).getModelElement()) : figure instanceof EdgeFigure && element.equals(((EdgeFigure)figure).getModelElement())))) continue;
                return figure;
            }
        }
        return null;
    }

    protected Connector findNodeConnector(Element element, int x, int y) {
        Figure figure = this.findFigure(element);
        if (figure == null) {
            return null;
        }
        return figure.connectorAt(x, y);
    }

    private void findParentElement(Element root) {
        if (root instanceof Namespace) {
            Iterator iterator = ((Namespace)root).iteratorDiagram();
            while (this.parentElement == null && iterator.hasNext()) {
                if (!this.diagram.equals((Diagram)iterator.next())) continue;
                this.parentElement = root;
            }
            if (this.parentElement == null) {
                iterator = ((Namespace)root).iteratorOwnedElement();
                while (this.parentElement == null && iterator.hasNext()) {
                    this.findParentElement((Element)iterator.next());
                }
            }
        }
    }

    public Dimension getDefaultDimension() {
        int defaultWidth = LauncherView.getSettings().getDiagramWidth();
        int defaultHeight = LauncherView.getSettings().getDiagramHeight();
        Dimension minDim = this.getMinimumDimension();
        double newWidth = 0.0;
        double newHeight = 0.0;
        newWidth = (int)minDim.getWidth() > defaultWidth ? minDim.getWidth() + minDim.getWidth() / 5.0 : (double)defaultWidth;
        newHeight = (int)minDim.getHeight() > defaultHeight ? minDim.getHeight() + minDim.getHeight() / 5.0 : (double)defaultHeight;
        return new Dimension((int)newWidth, (int)newHeight);
    }

    public Diagram getDiagram() {
        return this.diagram;
    }

    public Dimension getMinimumDimension() {
        Dimension max = new Dimension(0, 0);
        if (this.getDiagram() != null) {
            Iterator iterator = this.getDiagram().iteratorPresentationElement();
            while (iterator.hasNext()) {
                Object obj = iterator.next();
                if (obj instanceof Association) {
                    Association assoc = (Association)obj;
                    PresentationAssocClass node = assoc.getLinkPresentation();
                    this.getMinDimHelper_processNode(node, max);
                    Iterator ri = assoc.iteratorRolePresentation();
                    while (ri.hasNext()) {
                        PresentationEdge role = (PresentationEdge)ri.next();
                        this.getMinDimHelper_processEdge(role, max);
                    }
                    continue;
                }
                if (obj instanceof PresentationEdge) {
                    PresentationEdge edge = (PresentationEdge)obj;
                    this.getMinDimHelper_processEdge(edge, max);
                    continue;
                }
                if (!(obj instanceof PresentationNode)) continue;
                PresentationNode node = (PresentationNode)obj;
                this.getMinDimHelper_processNode(node, max);
            }
        }
        ++max.width;
        ++max.height;
        return max;
    }

    private void getMinDimHelper_processEdge(PresentationEdge edge, Dimension max) {
        Iterator wpi = edge.iteratorWayPoint();
        while (wpi.hasNext()) {
            WayPoint wp = (WayPoint)wpi.next();
            if (wp.getEast() > max.width) {
                max.width = wp.getEast();
            }
            if (wp.getSouth() <= max.height) continue;
            max.height = wp.getSouth();
        }
    }

    private void getMinDimHelper_processNode(PresentationNode node, Dimension max) {
        int height;
        int width;
        int south;
        int east;
        if (node instanceof PresentationAssocClass) {
            PresentationAssocClass assocClass = (PresentationAssocClass)node;
            if (!assocClass.isLinkWithoutClass()) {
                east = (int)assocClass.getClassAngle();
                south = (int)assocClass.getClassRadius();
                width = node.getWidth();
                height = node.getHeight();
                if (east + width > max.width) {
                    max.width = east + width;
                }
                if (south + height > max.height) {
                    max.height = south + height;
                }
            }
            east = node.getEast();
            south = node.getSouth();
            width = 0;
            height = 0;
        } else {
            east = node.getEast();
            south = node.getSouth();
            width = node.getWidth();
            height = node.getHeight();
        }
        if (east + width > max.width) {
            max.width = east + width;
        }
        if (south + height > max.height) {
            max.height = south + height;
        }
    }

    protected Element getParentElement() {
        if (this.parentElement == null) {
            this.findParentElement(LauncherView.getInstance().getModel());
        }
        return this.parentElement;
    }

    public String getTitle() {
        Object[] tokens = new Object[]{((ModelElement)this.getParentElement()).getDefLangName(), ElementUtils.mapNlsString(this.getDiagram().getName())};
        return NlsUtils.formatMessage(NodeFigure.getResourceString(ClassDiagramView.class, "CTClassDiagram"), tokens);
    }

    public void ignoreMetaModelChanges(boolean ignore) {
        Container container = this;
        while (!((container = container.getParent()) instanceof DrawingFrame)) {
        }
        DrawingFrame frame = (DrawingFrame)container;
        if (ignore) {
            frame.unregisterListener();
        } else {
            frame.registerListener();
        }
    }

    public boolean isAddable(Element element) {
        return element != null && (element instanceof AbstractClassDef || ClassDiagramView.isDrawablePackage(element.getClass()) || ClassFigure.isPseudoClassifier(element) || element instanceof DomainDef);
    }

    private static boolean isDrawablePackage(Class aClass) {
        return aClass.equals(INTERLIS2Def.class) || aClass.equals(ModelDef.class) || aClass.equals(TopicDef.class) || aClass.equals(UmlPackage.class);
    }

    protected boolean isLoading() {
        return this.loading;
    }

    public boolean isShowAllRoles() {
        return this.showRoles;
    }

    protected boolean isShowAssociationNames() {
        return this.showAssociationNames;
    }

    protected boolean isShowAttributeMultiplicity() {
        return this.getDiagram().isShowAttributeMultiplicity();
    }

    protected boolean isShowAttributes() {
        return this.showAttributes;
    }

    protected boolean isShowAttributeTypes() {
        return this.getDiagram().isShowAttributeType();
    }

    protected boolean isShowLinkFigure() {
        return this.showLinkFigure;
    }

    public boolean isShowMultiplicities() {
        return this.showMultiplicity;
    }

    @Override
    public void keyPressed(KeyEvent e) {
        int code = e.getKeyCode();
        if (code == 8 || code == 127) {
            Figure figure;
            Enumeration figures = this.selection().elements();
            while (figures.hasMoreElements()) {
                figure = (Figure)figures.nextElement();
                if (!(figure instanceof EdgeFigure)) continue;
                ((EdgeFigure)figure).removeVisually();
            }
            figures = this.selection().elements();
            while (figures.hasMoreElements()) {
                figure = (Figure)figures.nextElement();
                if (!(figure instanceof NodeFigure)) continue;
                ((NodeFigure)figure).removeVisually();
            }
        } else {
            super.keyPressed(e);
        }
        this.checkDamage();
    }

    private void loadAssociation(Association composite) {
        LinkFigure linkFigure = new LinkFigure();
        this.loadNode(composite.getLinkPresentation(), linkFigure);
        Iterator iteratorRole = composite.iteratorRolePresentation();
        while (iteratorRole.hasNext()) {
            this.loadPresentationRole(null, (PresentationRole)iteratorRole.next());
        }
        linkFigure.setCreating(false);
    }

    private NodeFigure loadNode(PresentationNode node, Figure figure) {
        ((NodeFigure)figure).setClassDiagram(this);
        ((NodeFigure)figure).setNode(node);
        super.add(figure);
        Point origin = new Point(node.getEast(), node.getSouth());
        Point corner = new Point(node.getEast() + node.getWidth(), node.getSouth() + node.getHeight());
        figure.displayBox(origin, corner);
        return (NodeFigure)figure;
    }

    private boolean correctNode(EdgeFigure edgeFigure, PresentationEdge edge, Element targetNode, int index, PresentationNode endpoint) {
        Iterator presentationSubject;
        if (targetNode != null && (presentationSubject = endpoint.iteratorSubject()).hasNext()) {
            ModelElement presentationNode = (ModelElement)presentationSubject.next();
            if (targetNode.equals(presentationNode)) {
                return true;
            }
            Figure targetFigure = this.findFigure(targetNode);
            if (targetFigure != null) {
                Tracer.getInstance().developerWarning("AUTO-CORRECTION: endpoint[" + index + "]=child->relocation:");
                edge.setEndpoint(index, ((NodeFigure)targetFigure).getNode());
                Connector connector = this.findNodeConnector(targetNode, 0, 0);
                edgeFigure.willChange();
                if (index == 0) {
                    edgeFigure.setStartConnector(connector);
                } else {
                    edgeFigure.setEndConnector(connector);
                }
                edgeFigure.changed();
                this.checkDamage();
                return true;
            }
        }
        return false;
    }

    private boolean correctDependencyRelocation(DependencyLineConnection dependencyFigure) {
        ch.ehi.umleditor.umlpresentation.Dependency dependency = (ch.ehi.umleditor.umlpresentation.Dependency)dependencyFigure.getEdge();
        if (dependency.sizeEndpoint() == 2) {
            Iterator endpoints = dependency.iteratorEndpoint();
            if (this.correctNode(dependencyFigure, dependency, dependencyFigure.getStartElement(), 0, (PresentationNode)endpoints.next()) && this.correctNode(dependencyFigure, dependency, dependencyFigure.getEndElement(), 1, (PresentationNode)endpoints.next())) {
                return true;
            }
        }
        Tracer.getInstance().developerWarning("AUTO-CORRECTION: Removing Dependency-Presentation from Diagram");
        this.getDiagram().deletePresentationElement(dependency);
        return false;
    }

    private boolean correctGeneralizationRelocation(GeneralizationLineConnection generalizationFigure) {
        Generalization generalization = (Generalization)generalizationFigure.getEdge();
        if (generalization.sizeEndpoint() == 2) {
            Iterator endpoints = generalization.iteratorEndpoint();
            if (this.correctNode(generalizationFigure, generalization, generalizationFigure.getStartElement(), 0, (PresentationNode)endpoints.next()) && this.correctNode(generalizationFigure, generalization, generalizationFigure.getEndElement(), 1, (PresentationNode)endpoints.next())) {
                return true;
            }
        }
        Tracer.getInstance().developerWarning("AUTO-CORRECTION: Removing Generalization-Presentation from Diagram");
        this.getDiagram().deletePresentationElement(generalization);
        return false;
    }

    private boolean correctRoleRelocation(PresentationRole role) {
        Iterator subjects = role.iteratorSubject();
        while (subjects.hasNext()) {
            AssociationEnd subjectRoleDef;
            Object object = subjects.next();
            if (!(object instanceof AssociationEnd) || !(subjectRoleDef = (AssociationEnd)object).containsParticipant()) continue;
            Classifier targetClass = subjectRoleDef.getParticipant();
            Iterator endpoints = role.iteratorEndpoint();
            if (!endpoints.hasNext()) continue;
            endpoints.next();
            if (!endpoints.hasNext() || !((object = endpoints.next()) instanceof PresentationAbstractClass)) continue;
            PresentationAbstractClass presentationClass = (PresentationAbstractClass)object;
            if (!presentationClass.containsSubject(targetClass)) {
                Tracer.getInstance().developerWarning("AUTO-CORRECTION: endpoint[1]->relocation: <current Classifier>=>" + targetClass.getName().getValue());
                ClassFigure newClass = (ClassFigure)this.findFigure(targetClass);
                if (newClass != null) {
                    role.setEndpoint(1, newClass.getNode());
                }
            }
            return true;
        }
        this.getDiagram().removePresentationElement(role);
        Tracer.getInstance().developerWarning("AUTO-CORRECTION: removing PresentationRole because no AssociationEnd is set!");
        return false;
    }

    protected Figure loadPresentationRole(RoleDef roleDef, PresentationRole role) {
        if (role == null) {
            Figure linkFigure = this.findFigure(roleDef.getAssociation());
            if (linkFigure == null) {
                this.saveAssociation((AssociationDef)roleDef.getAssociation());
            } else {
                Figure nodeFigure = null;
                nodeFigure = role.iteratorEndpoint().hasNext() ? this.findFigure((Classifier)role.iteratorEndpoint().next()) : this.findFigure(roleDef.getParticipant());
                if (nodeFigure == null) {
                    nodeFigure = this.add(roleDef.getParticipant());
                } else {
                    LauncherView.getInstance().nyi("RoleDef zu Diagramm einf\u00fcgen");
                    return null;
                }
            }
            return null;
        }
        if (role.iteratorSubject().hasNext() && role.iteratorSubject().next() instanceof Participant) {
            return this.loadRole(role);
        }
        if (this.correctRoleRelocation(role)) {
            return this.loadRole(role);
        }
        return null;
    }

    private EdgeFigure loadRole(PresentationRole role) {
        PresentationRoleFigure figure = new PresentationRoleFigure(this, role);
        this.loadSimpleEdge(figure);
        return figure;
    }

    protected void loadSimpleEdge(EdgeFigure figure) {
        figure.connectNodes();
        super.add(figure);
        figure.updateView();
    }

    public void refresh() {
        FigureEnumeration enumerator = this.drawing().figures();
        while (enumerator.hasMoreElements()) {
            this.remove(enumerator.nextFigure());
        }
        if (this.diagram != null) {
            this.setDiagramElement(this.diagram);
        }
    }

    public void updateFigures() {
        FigureEnumeration enumeration = this.drawing().figures();
        while (enumeration.hasMoreElements()) {
            Figure figure = enumeration.nextFigure();
            if (figure instanceof NodeFigure) {
                ((NodeFigure)figure).updateView();
                continue;
            }
            if (!(figure instanceof EdgeFigure)) continue;
            ((EdgeFigure)figure).updateView();
        }
    }

    @Override
    public Figure remove(Figure figure) {
        super.remove(figure);
        this.clearSelection();
        this.repaint();
        this.repairDamage();
        return figure;
    }

    private Figure saveAssociation(ch.ehi.uml1_4.foundation.core.Association associationDef) {
        ArrayList roles = AssociationLineConnection.getRoleClassifiers(associationDef);
        if (roles.size() < 2 && AssociationLineConnection.getParent(associationDef) == null) {
            BaseDialog.showWarning(LauncherView.getInstance(), NodeFigure.getResourceString(ClassDiagramView.class, "CTAssociationNotDisplayable"), NodeFigure.getResourceString(ClassDiagramView.class, "CWRoleMissing"));
            return null;
        }
        Association associationComposite = ElementFactory.createAssociationComposite(associationDef, this.isShowAssociationNames());
        for (int i = 0; i < roles.size(); ++i) {
            Figure figure = this.addClassifier((RoleDef)roles.get(i));
            ElementFactory.createPresentationRole(this, associationComposite, ((NodeFigure)figure).getNode(), (RoleDef)roles.get(i));
        }
        return this.add(associationComposite);
    }

    private Figure saveAssociationComposite(Association associationComposite) {
        this.getDiagram().addPresentationElement(associationComposite);
        this.loadAssociation(associationComposite);
        return null;
    }

    private Figure saveClassFigure(AbstractModelElement classifier, Figure figure) {
        ch.ehi.umleditor.umlpresentation.Class classDefView = (ch.ehi.umleditor.umlpresentation.Class)ElementFactory.createObject(ch.ehi.umleditor.umlpresentation.Class.class);
        this.saveNode(classDefView, classifier, figure);
        return figure;
    }

    protected void saveNode(PresentationNode node, ModelElement modelElement, Figure figure) {
        ((NodeFigure)figure).setClassDiagram(this);
        node.addSubject(modelElement);
        ((NodeFigure)figure).setNode(node);
        this.saveNodeInDiagram(node, figure);
    }

    protected void saveNodeInDiagram(PresentationNode node, Figure figure) {
        super.add(figure);
        ((NodeFigure)figure).update();
        node.setForeground(ColorConverter.createColor(((NodeFigure)figure).getLineColor()));
        node.setBackground(ColorConverter.createColor(((NodeFigure)figure).getFillColor()));
        this.getDiagram().addPresentationElement(node);
        Iterator iterator = node.iteratorSubject();
        if (iterator.hasNext()) {
            Dependency dependency;
            AbstractModelElement modelElement = (AbstractModelElement)iterator.next();
            Iterator dependencies = modelElement.iteratorClientDependency();
            while (dependencies.hasNext()) {
                Figure end;
                Object supplier;
                dependency = (Dependency)dependencies.next();
                Iterator suppliers = dependency.iteratorSupplier();
                if (!suppliers.hasNext() || !((supplier = suppliers.next()) instanceof GeneralizableElement) || (end = this.findFigure((GeneralizableElement)supplier)) == null) continue;
                this.loadSimpleEdge(new DependencyLineConnection(this, figure, end, dependency));
            }
            dependencies = modelElement.iteratorSupplierDependency();
            while (dependencies.hasNext()) {
                Figure start;
                Object client;
                dependency = (Dependency)dependencies.next();
                Iterator clients = dependency.iteratorClient();
                if (!clients.hasNext() || !((client = clients.next()) instanceof GeneralizableElement) || (start = this.findFigure((GeneralizableElement)client)) == null) continue;
                this.loadSimpleEdge(new DependencyLineConnection(this, start, figure, dependency));
            }
            if (modelElement instanceof GeneralizableElement) {
                ch.ehi.uml1_4.foundation.core.Generalization generalization;
                Iterator generalizations = ((GeneralizableElement)((Object)modelElement)).iteratorSpecialization();
                while (generalizations.hasNext()) {
                    generalization = (ch.ehi.uml1_4.foundation.core.Generalization)generalizations.next();
                    Figure parent = this.findFigure(generalization.getParent());
                    Figure child = this.findFigure(generalization.getChild());
                    if (parent == null || child == null) continue;
                    this.loadSimpleEdge(new GeneralizationLineConnection(this, figure, parent, generalization));
                }
                generalizations = ((GeneralizableElement)((Object)modelElement)).iteratorGeneralization();
                while (generalizations.hasNext()) {
                    generalization = (ch.ehi.uml1_4.foundation.core.Generalization)generalizations.next();
                    Figure start = this.findFigure(generalization.getParent());
                    if (start == null) continue;
                    this.loadSimpleEdge(new GeneralizationLineConnection(this, start, figure, generalization));
                }
            }
            if (modelElement instanceof Classifier && this.tryAssociations) {
                Iterator elements = modelElement.getNamespace().iteratorOwnedElement();
                while (elements.hasNext()) {
                    Object ownedModelElement = elements.next();
                    if (!(ownedModelElement instanceof ch.ehi.uml1_4.foundation.core.Association)) continue;
                    this.checkAssociation(modelElement, node, (ch.ehi.uml1_4.foundation.core.Association)ownedModelElement);
                }
                elements = ((Classifier)((Object)modelElement)).iteratorAssociation();
                while (elements.hasNext()) {
                    Object associationEnd = elements.next();
                    if (!(associationEnd instanceof AssociationEnd)) continue;
                    this.checkAssociation(modelElement, node, ((AssociationEnd)associationEnd).getAssociation());
                }
            }
        }
    }

    private void checkAssociation(AbstractModelElement modelElement, PresentationNode node, ch.ehi.uml1_4.foundation.core.Association associationDef) {
        Iterator it = associationDef.iteratorConnection();
        while (it.hasNext()) {
            AssociationEnd roleDef = (AssociationEnd)it.next();
            if (!roleDef.containsParticipant() || !roleDef.getParticipant().equals(modelElement)) continue;
            this.trySaveAssociation(associationDef, node, roleDef);
        }
        this.checkXorRole(modelElement);
    }

    private void checkXorRole(AbstractModelElement modelElement) {
        if (modelElement instanceof ClassDef) {
            Iterator it = ((ClassDef)modelElement).iteratorXorAssociation();
            while (it.hasNext()) {
                LinkFigure edge;
                Participant participant = (Participant)it.next();
                if (this.findFigure(participant) != null || (edge = (LinkFigure)this.findFigure(participant.getAssociation().getAssociation())) == null) continue;
                PresentationAssocClass linkView = (PresentationAssocClass)edge.getNode();
                NodeFigure nodeFigure = (NodeFigure)this.findFigure(modelElement);
                if (nodeFigure == null) continue;
                PresentationRole xorRole = ElementFactory.createPresentationRole(this, linkView.getAssociation(), nodeFigure.getNode(), participant);
                this.loadPresentationRole(null, xorRole);
            }
        }
    }

    private Figure savePackageFigure(ModelElement modelElement, Figure figure) {
        Package packageView = (Package)ElementFactory.createObject(Package.class);
        this.saveNode(packageView, modelElement, figure);
        return figure;
    }

    public void setDiagramElement(Element diagram) {
        this.diagram = (Diagram)diagram;
        this.loading = true;
        Iterator iterator = this.getDiagram().iteratorPresentationElement();
        ArrayList<PresentationElement> dependencies = new ArrayList<PresentationElement>();
        TopoSort associations = new TopoSort();
        ArrayList<PresentationElement> generalizations = new ArrayList<PresentationElement>();
        ArrayList<PresentationElement> noteAnchors = new ArrayList<PresentationElement>();
        while (iterator.hasNext()) {
            NodeFigure figure;
            PresentationElement presentationElement = (PresentationElement)iterator.next();
            if (presentationElement instanceof ch.ehi.umleditor.umlpresentation.Class) {
                figure = this.loadNode((PresentationNode)presentationElement, new ClassFigure());
                figure.setCreating(false);
                continue;
            }
            if (presentationElement instanceof Package) {
                figure = this.loadNode((PresentationNode)presentationElement, new PackageFigure());
                figure.setCreating(false);
                continue;
            }
            if (presentationElement instanceof Note) {
                figure = this.loadNode((PresentationNode)presentationElement, new NoteFigure());
                figure.setCreating(false);
                continue;
            }
            if (presentationElement instanceof Generalization) {
                generalizations.add(presentationElement);
                continue;
            }
            if (presentationElement instanceof NoteEdge) {
                noteAnchors.add(presentationElement);
                continue;
            }
            if (presentationElement instanceof ch.ehi.umleditor.umlpresentation.Dependency) {
                dependencies.add(presentationElement);
                continue;
            }
            if (presentationElement instanceof Association) {
                Object second;
                associations.add(presentationElement);
                Iterator presRoles = ((Association)presentationElement).iteratorRolePresentation();
                if (!presRoles.hasNext()) continue;
                PresentationRole role = (PresentationRole)presRoles.next();
                Iterator endPoints = role.iteratorEndpoint();
                if (endPoints.hasNext()) {
                    endPoints.next();
                }
                if (!endPoints.hasNext() || !((second = endPoints.next()) instanceof PresentationAssocClass)) continue;
                associations.addcond(((PresentationAssocClass)second).getAssociation(), presentationElement);
                continue;
            }
            Tracer.getInstance().developerWarning("unknown Edge-Type");
        }
        for (PresentationEdge presentationEdge : dependencies) {
            this.loadSimpleEdge(new DependencyLineConnection(this, presentationEdge));
        }
        if (!associations.sort()) {
            throw new DeveloperException("TopoSort could not sort!");
        }
        for (Association association : associations.getResult()) {
            this.loadAssociation(association);
        }
        for (PresentationEdge presentationEdge : generalizations) {
            this.loadSimpleEdge(new GeneralizationLineConnection(this, presentationEdge));
        }
        iterator = noteAnchors.iterator();
        while (iterator.hasNext()) {
            this.loadSimpleEdge(new NoteAnchorLineConnection(this, (PresentationEdge)iterator.next()));
        }
        this.loading = false;
    }

    protected void showAllAssociationNames(boolean visible) {
        this.showAssociationNames = visible;
        FigureEnumeration enumeration = this.drawing().figures();
        while (enumeration.hasMoreElements()) {
            Figure figure = enumeration.nextFigure();
            if (!(figure instanceof LinkFigure)) continue;
            ((PresentationAssocClass)((LinkFigure)figure).getNode()).getAssociation().setShowName(visible);
            ((LinkFigure)figure).changed();
        }
        this.checkDamage();
    }

    protected void showAllAttributeMultiplicity(boolean visible) {
        this.getDiagram().setShowAttributeMultiplicity(visible);
        this.updateAttributes();
    }

    protected void showAllAttributes(boolean visible) {
        this.showAttributes = visible;
        FigureEnumeration enumeration = this.drawing().figures();
        while (enumeration.hasMoreElements()) {
            Figure figure = enumeration.nextFigure();
            if (!(figure instanceof ClassFigure)) continue;
            ((PresentationAbstractClass)((ClassFigure)figure).getNode()).setSuppressAttributes(!visible);
        }
    }

    protected void showAllAttributeTypes(boolean visible) {
        this.getDiagram().setShowAttributeType(visible);
        this.updateAttributes();
    }

    protected void showAllLinkFigures(boolean visible) {
        this.showLinkFigure = visible;
        FigureEnumeration enumeration = this.drawing().figures();
        while (enumeration.hasMoreElements()) {
            Figure figure = enumeration.nextFigure();
            if (!(figure instanceof LinkFigure)) continue;
            figure.changed();
        }
        this.checkDamage();
    }

    protected void showAllOperations(boolean visible) {
        this.showAttributes = visible;
        FigureEnumeration enumeration = this.drawing().figures();
        while (enumeration.hasMoreElements()) {
            Figure figure = enumeration.nextFigure();
            if (!(figure instanceof ClassFigure)) continue;
            ((PresentationAbstractClass)((ClassFigure)figure).getNode()).setSuppressOperations(!visible);
        }
    }

    protected void showAllMultiplicities(boolean visible) {
        this.showMultiplicity = visible;
        FigureEnumeration enumeration = this.drawing().figures();
        while (enumeration.hasMoreElements()) {
            Figure figure = enumeration.nextFigure();
            if (!(figure instanceof PresentationRoleFigure)) continue;
            ((PresentationRole)((PresentationRoleFigure)figure).getEdge()).setMultiplicityVisible(visible);
        }
    }

    protected void showAllRoles(boolean visible) {
        this.showRoles = visible;
        FigureEnumeration enumeration = this.drawing().figures();
        while (enumeration.hasMoreElements()) {
            Figure figure = enumeration.nextFigure();
            if (!(figure instanceof PresentationRoleFigure)) continue;
            ((PresentationRole)((PresentationRoleFigure)figure).getEdge()).setNameVisible(visible);
        }
    }

    protected void layoutAllVisibleRolenames() {
        FigureEnumeration enumeration = this.drawing().figures();
        while (enumeration.hasMoreElements()) {
            Figure figure = enumeration.nextFigure();
            if (!(figure instanceof PresentationRoleFigure)) continue;
            ((PresentationRoleFigure)figure).layoutRolename();
        }
    }

    protected void layoutAllVisibleMultiplicities() {
        FigureEnumeration enumeration = this.drawing().figures();
        while (enumeration.hasMoreElements()) {
            Figure figure = enumeration.nextFigure();
            if (!(figure instanceof PresentationRoleFigure)) continue;
            ((PresentationRoleFigure)figure).layoutMultiplicity();
        }
    }

    private void trySaveAssociation(ch.ehi.uml1_4.foundation.core.Association associationDef, PresentationNode node, AssociationEnd roleDef) {
        Figure linkFigure = this.findFigure(associationDef);
        if (linkFigure == null) {
            ArrayList roles = AssociationLineConnection.getRoleClassifiers(associationDef);
            HashMap<Integer, Figure> nodes = new HashMap<Integer, Figure>();
            for (int i = 0; i < roles.size(); ++i) {
                Figure figure = this.findFigure(((RoleDef)roles.get(i)).getParticipant());
                if (figure == null) continue;
                nodes.put(new Integer(i), figure);
            }
            if (nodes.size() > 1) {
                Association associationComposite = ElementFactory.createAssociationComposite(associationDef, this.isShowAssociationNames());
                for (Integer i : nodes.keySet()) {
                    NodeFigure classifierFigure = (NodeFigure)nodes.get(i);
                    ElementFactory.createPresentationRole(this, associationComposite, classifierFigure.getNode(), (RoleDef)roles.get(i));
                }
                this.add(associationComposite);
            }
        } else if (this.findFigure(roleDef) == null) {
            Association associationComposite = ((PresentationAssocClass)((LinkFigure)linkFigure).getNode()).getAssociation();
            PresentationRole edgeRole = ElementFactory.createPresentationRole(this, associationComposite, node, roleDef);
            this.loadPresentationRole(null, edgeRole);
        }
    }

    public void update(MetaModelChange event) {
        Figure figure = null;
        if (event.getSource() instanceof Feature) {
            if (((Feature)event.getSource()).containsOwner()) {
                figure = this.findFigure(((Feature)event.getSource()).getOwner());
            }
        } else if (event.getSource() instanceof RoleDef && ((RoleDef)event.getSource()).containsAssociation()) {
            figure = this.findFigure((RoleDef)event.getSource());
        } else if (event.getSource() instanceof Element) {
            figure = this.findFigure((Element)event.getSource());
        }
        if (figure != null) {
            if (figure instanceof NodeFigure) {
                ((NodeFigure)figure).updateView();
            } else if (event.getOperation().startsWith("set")) {
                if (figure instanceof PresentationRoleFigure) {
                    ((PresentationRoleFigure)figure).updateView();
                }
            } else if (event.getOperation().startsWith("change")) {
                if (figure instanceof PresentationRoleFigure && event.getOperation().equals("changeParticipant")) {
                    PresentationRoleFigure roleFigure = (PresentationRoleFigure)figure;
                    PresentationRole role = (PresentationRole)roleFigure.getEdge();
                    if (this.correctRoleRelocation(role)) {
                        Iterator endpoints = role.iteratorEndpoint();
                        endpoints.next();
                        ch.ehi.umleditor.umlpresentation.Class presentationClass = (ch.ehi.umleditor.umlpresentation.Class)endpoints.next();
                        Iterator subjects = presentationClass.iteratorSubject();
                        Connector end = this.findNodeConnector((Element)subjects.next(), 0, 0);
                        if (end == null) {
                            Tracer.getInstance().developerWarning("AUTO-CORRECTION: Removing PresentationRole from Diagram");
                            this.getDiagram().deletePresentationElement(role);
                        } else {
                            roleFigure.setEndConnector(end);
                        }
                    }
                } else if (figure instanceof DependencyLineConnection) {
                    if (this.correctDependencyRelocation((DependencyLineConnection)figure)) {
                        ((EdgeFigure)figure).updateView();
                    }
                } else if (figure instanceof GeneralizationLineConnection && this.correctGeneralizationRelocation((GeneralizationLineConnection)figure)) {
                    ((EdgeFigure)figure).updateView();
                }
            }
        }
    }

    private void updateAttributes() {
        FigureEnumeration enumeration = this.drawing().figures();
        while (enumeration.hasMoreElements()) {
            Figure figure = enumeration.nextFigure();
            if (!(figure instanceof ClassFigure)) continue;
            ((ClassFigure)figure).updateView();
        }
    }
}

