/*
 * Decompiled with CFR 0.152.
 */
package ch.softenvironment.view.swingext;

import ch.softenvironment.util.StringUtils;
import ch.softenvironment.view.BaseFrame;
import java.awt.Color;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import javax.swing.JTextField;

public class DateTextField
extends JTextField {
    IvjEventHandler ivjEventHandler = new IvjEventHandler();
    private Date fieldDate = null;
    private transient String datePattern = null;

    public DateTextField() {
        this("dd.MM.yyyy");
    }

    public DateTextField(String datePattern) {
        this.datePattern = datePattern;
        this.initialize();
    }

    private Date connEtoC1(KeyEvent arg1) {
        Date connEtoC1Result = null;
        try {
            connEtoC1Result = this.getDate();
        }
        catch (Throwable ivjExc) {
            this.handleException(ivjExc);
        }
        return connEtoC1Result;
    }

    public Date getDate() {
        Date oldValue = this.fieldDate;
        try {
            if (StringUtils.isNullOrEmpty(this.getText())) {
                this.fieldDate = null;
            } else {
                SimpleDateFormat sf = new SimpleDateFormat(this.datePattern);
                Date date = sf.parse(this.getText());
                this.fieldDate = new Date(date.getTime());
                this.setForeground(Color.black);
            }
        }
        catch (ParseException e) {
            this.fieldDate = null;
            this.setForeground(Color.red);
            this.setToolTipText(e.getLocalizedMessage());
        }
        this.firePropertyChange("date", oldValue, this.fieldDate);
        return this.fieldDate;
    }

    private void handleException(Throwable exception) {
        BaseFrame.showException(null, exception);
    }

    private void initConnections() throws Exception {
        this.addKeyListener(this.ivjEventHandler);
    }

    private void initialize() {
        try {
            this.setName("DateTextField");
            this.setSize(4, 20);
            this.initConnections();
        }
        catch (Throwable ivjExc) {
            this.handleException(ivjExc);
        }
        this.setToolTipText(this.datePattern);
    }

    public void setDate(Date date) {
        if (date == null) {
            this.setText(null);
        } else {
            SimpleDateFormat sf = new SimpleDateFormat(this.datePattern);
            this.setText(sf.format(date));
        }
    }

    class IvjEventHandler
    implements KeyListener {
        IvjEventHandler() {
        }

        @Override
        public void keyPressed(KeyEvent e) {
        }

        @Override
        public void keyReleased(KeyEvent e) {
            if (e.getSource() == DateTextField.this) {
                DateTextField.this.connEtoC1(e);
            }
        }

        @Override
        public void keyTyped(KeyEvent e) {
        }
    }
}

