/*
 * Decompiled with CFR 0.152.
 */
package ch.softenvironment.view.swingext;

import ch.softenvironment.client.ResourceManager;
import ch.softenvironment.util.StringUtils;
import ch.softenvironment.view.BaseDialog;
import java.awt.Container;
import java.awt.event.InputMethodEvent;
import java.awt.event.InputMethodListener;
import javax.swing.JTextField;

public class NumberTextField
extends JTextField
implements InputMethodListener {
    public NumberTextField() {
        this.addInputMethodListener(this);
        this.setHorizontalAlignment(4);
    }

    @Override
    public void caretPositionChanged(InputMethodEvent event) {
    }

    public Double getDoubleValue() throws NumberFormatException {
        if (StringUtils.isNullOrEmpty(this.getText())) {
            return null;
        }
        if (this.getText().equals("-") || this.getText().equals("+")) {
            return null;
        }
        return new Double(Double.parseDouble(this.getText()));
    }

    public Integer getIntegerValue() throws NumberFormatException {
        if (StringUtils.isNullOrEmpty(this.getText())) {
            return null;
        }
        return new Integer(Integer.parseInt(this.getText()));
    }

    public Long getLongValue() throws NumberFormatException {
        if (StringUtils.isNullOrEmpty(this.getText())) {
            return null;
        }
        return new Long(Long.parseLong(this.getText()));
    }

    @Override
    public String getText() {
        if (StringUtils.isNullOrEmpty(super.getText())) {
            return null;
        }
        return super.getText();
    }

    @Override
    public void inputMethodTextChanged(InputMethodEvent event) {
        char lastChar = event.getText().last();
        if ((lastChar < '0' || lastChar > '9') && lastChar != '-' && lastChar != '+' && lastChar != '.') {
            if (this.isEditable() && this.isEnabled()) {
                Container parent = this.getRootPane().getParent();
                String title = ResourceManager.getResource(NumberTextField.class, "CTInvalidInput");
                String message = ResourceManager.getResource(NumberTextField.class, "CICorrectInput");
                BaseDialog.showWarning(parent, title, message);
            }
            event.consume();
        }
    }

    @Override
    public void setText(String t) {
        if (t == null || t.indexOf("null") > -1) {
            super.setText("");
        } else {
            super.setText(t);
        }
    }
}

