/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xmi.framework;

import com.ibm.xmi.framework.AdapterFactoryRegister;
import com.ibm.xmi.framework.Data;
import com.ibm.xmi.framework.Datatype;
import com.ibm.xmi.framework.Enum;
import com.ibm.xmi.framework.Factory;
import com.ibm.xmi.framework.FactoryRegister;
import com.ibm.xmi.framework.Feature;
import com.ibm.xmi.framework.Namespace;
import com.ibm.xmi.framework.NamespaceHandler;
import com.ibm.xmi.framework.Namespaces;
import com.ibm.xmi.framework.ObjectWriterWrapper;
import com.ibm.xmi.framework.Package;
import com.ibm.xmi.framework.XMIClass;
import com.ibm.xmi.framework.XMIContainer;
import com.ibm.xmi.framework.XMIObject;
import java.io.File;
import java.io.FileInputStream;
import java.util.AbstractList;
import java.util.Collection;
import java.util.Collections;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Vector;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.InputSource;
import org.xml.sax.helpers.DefaultHandler;

public class DeclarationFactory {
    private static final String copyright = "Licensed Materials-Property of IBM\n(C) Copyright IBM Corp. 1999-2002. All Rights Reserved.\nUS Government Users Restricted Rights-Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.";
    protected static final String BASIC_PROPERTY_DEF = "BasicPropertyDef";
    protected static final String DEFINITION_NAME = "XMIDefinition.name";
    protected static final String CONTAIN_LINK_DEF = "ContainLinkDef";
    protected static final String CONTAINER_LINK_DEF = "ContainerLinkDef";
    protected static final String REF_LINK_DEF = "RefLinkDef";
    protected static final String ENUM_DEF = "EnumDef";
    protected static final String ENUM_DEF_LITERAL = "EnumDef.literal";
    protected static final String LITERAL_VALUE = "Literal.value";
    protected static final String ENUM_PROPERTY_DEF = "EnumPropertyDef";
    protected static final String ENUM_PROPERTY_DEF_ENUM_DEF = "EnumPropertyDef.enumDef";
    protected static final String LINK_DEF_OBJECT_DEF = "LinkDef.objectDef";
    protected static final String LINK_DEF_MULTIPLICITY = "LinkDef.multiplicity";
    protected static final String MOF_ATTRIBUTE = "Model.Attribute";
    protected static final String MOF_ATTRIB_TYPE = "Model.TypedElement.type";
    protected static final String MOF_CONTAINER = "Model.ModelElement.container";
    protected static final String MOF_CONTENTS = "Model.Namespace.contents";
    protected static final String MOF_CLASS = "Model.Class";
    protected static final String MOF_NAME = "Model.ModelElement.name";
    protected static final String MOF_PACKAGE = "Model.Package";
    protected static final String MOF_SUPERTYPES = "Model.GeneralizableElement.supertypes";
    protected static final String OBJECT_DEF = "ObjectDef";
    protected static final String OBJECT_DEF_LINKS = "ObjectDef.linkDef";
    protected static final String OBJECT_DEF_PROPERTIES = "ObjectDef.propertyDef";
    protected static final String OBJECT_DEF_SUB_DEF = "ObjectDef.subDef";
    protected static final String OBJECT_DEF_SUPER_DEF = "ObjectDef.superDef";
    protected static final String OBJECT_PROPERTY_DEF = "ObjectPropertyDef";
    protected static final String OBJECT_PROPERTY_DEF_OBJECT_DEF = "ObjectPropertyDef.objectDef";
    protected static final String UML_AGG_PROPERTY = "aggregation";
    protected static final String UML_ASSOCIATION = "Foundation.Core.Association";
    protected static final String UML_ASSOCIATION_END = "Foundation.Core.AssociationEnd";
    protected static final String UML_ASSOCIATIONS = "Foundation.Core.AssociationEnd.association";
    protected static final String UML_ASSOCIATION_ENDS = "Foundation.Core.Classifier.associationEnd";
    protected static final String UML_ATTRIBUTE = "Foundation.Core.Attribute";
    protected static final String UML_ATTRIB_TYPE = "Foundation.Core.StructuralFeature.type";
    protected static final String UML_CONNECTION = "Foundation.Core.Association.connection";
    protected static final String UML_CLASS = "Foundation.Core.Class";
    protected static final String UML_DATA_TYPE = "Foundation.Core.DataType";
    protected static final String UML_END_TYPE = "Foundation.Core.AssociationEnd.type";
    protected static final String UML_ENUMERATION = "Foundation.Data_Types.Enumeration";
    protected static final String UML_ENUM_LITERAL = "Foundation.Data_Types.Enumeration.literal";
    protected static final String UML_ENUM_LITERAL_NAME = "name";
    protected static final String UML_FEATURE = "Foundation.Core.Classifier.feature";
    protected static final String UML_GENERALIZATION = "Foundation.Core.Generalization";
    protected static final String UML_GENERALIZATIONS = "Foundation.Core.GeneralizableElement.generalization";
    protected static final String UML_IS_NAVIGABLE = "isNavigable";
    protected static final String UML_MODEL = "Model_Management.Model";
    protected static final String UML_MULTIPLICITY = "multiplicity";
    protected static final String UML_NAME = "Foundation.Core.ModelElement.name";
    protected static final String UML_NAMESPACE = "Foundation.Core.ModelElement.namespace";
    protected static final String UML_OWNER = "Foundation.Core.Feature.owner";
    protected static final String UML_PACKAGE = "Model_Management.Package";
    protected static final String UML_PRIMITIVE = "Foundation.Data_Types.Primitive";
    protected static final String UML_STEREOTYPE = "Foundation.Core.ModelElement.stereotype";
    protected static final String UML_SUBTYPE = "Foundation.Core.Generalization.subtype";
    protected static final String UML_SUPERTYPE = "Foundation.Core.Generalization.supertype";
    protected Hashtable objectToUserObject;
    protected Hashtable objectToEnum;
    protected Hashtable featureToName = new Hashtable();
    protected Hashtable objectsToNames = new Hashtable();
    protected Factory factory = FactoryRegister.getFactory();
    protected ObjectWriterWrapper wrapper = new ObjectWriterWrapper(AdapterFactoryRegister.getAdapterFactory().createObjectWriterAdapter());
    protected String namespaceFile;
    protected Vector packagesAndClasses;
    protected Vector namespaces = new Vector();

    public DeclarationFactory() {
    }

    public DeclarationFactory(String string) {
        this.namespaceFile = string;
    }

    public DeclarationFactory(String string, String string2) {
        Namespace namespace = new Namespace(string, string2);
        this.namespaces.addElement("");
        this.namespaces.addElement(namespace);
    }

    protected void adjustNames() {
        Vector vector;
        String string;
        Object object;
        Vector<Data> vector2 = new Vector<Data>();
        Hashtable<String, Vector<Object>> hashtable = new Hashtable<String, Vector<Object>>();
        int n = 0;
        while (n < this.packagesAndClasses.size()) {
            vector2.add(((XMIObject)this.packagesAndClasses.elementAt(n)).getXMIDerived());
            ++n;
        }
        Iterator iterator = ((AbstractList)vector2).iterator();
        while (iterator.hasNext()) {
            object = (Data)iterator.next();
            string = this.wrapper.getSimpleName(object.getXMIName()).toLowerCase();
            vector = (Vector)hashtable.get(string);
            if (vector != null) {
                vector.add(object);
                continue;
            }
            vector = new Vector(5);
            vector.add(object);
            hashtable.put(string, vector);
        }
        object = hashtable.keys();
        while (object.hasMoreElements()) {
            string = (String)object.nextElement();
            vector = (Vector)hashtable.get(string);
            if (vector.size() <= 1) continue;
            this.computeUniqueNames(vector);
        }
    }

    protected void computeFeatureNames(XMIContainer xMIContainer) {
        Vector vector = this.getClasses(xMIContainer);
        int n = 0;
        while (n < vector.size()) {
            this.computeFeatureNames(xMIContainer, (XMIObject)vector.elementAt(n));
            ++n;
        }
    }

    protected void computeFeatureNames(XMIContainer xMIContainer, XMIObject xMIObject) {
        Vector vector = this.getFeatures(xMIContainer, xMIObject);
        Vector<String> vector2 = new Vector<String>();
        Vector<String> vector3 = new Vector<String>();
        int n = 0;
        while (n < vector.size()) {
            String string = this.getName((XMIObject)vector.elementAt(n));
            if (!string.equals("") && this.containsIgnoreCase(vector3, string)) {
                vector2.addElement(string);
            } else {
                vector3.addElement(string);
            }
            ++n;
        }
        int n2 = 0;
        while (n2 < vector.size()) {
            String string = this.getName((XMIObject)vector.elementAt(n2));
            if (this.containsIgnoreCase(vector2, string)) {
                string = this.getFullName((XMIObject)vector.elementAt(n2), 1);
            }
            this.featureToName.put(vector.elementAt(n2), string);
            ++n2;
        }
    }

    protected void computeUniqueNames(Vector vector) {
        Vector vector2;
        Namespace namespace;
        Object object;
        Hashtable<Namespace, Vector<Object>> hashtable = new Hashtable<Namespace, Vector<Object>>();
        Iterator iterator = ((AbstractList)vector).iterator();
        Namespace namespace2 = new Namespace(null, null);
        while (iterator.hasNext()) {
            object = (Data)iterator.next();
            namespace = object.getXMINamespace();
            if (namespace == null) {
                namespace = namespace2;
            }
            if ((vector2 = (Vector)hashtable.get(namespace)) != null) {
                vector2.add(object);
                continue;
            }
            vector2 = new Vector(5);
            vector2.add(object);
            hashtable.put(namespace, vector2);
        }
        object = hashtable.keys();
        while (object.hasMoreElements()) {
            namespace = (Namespace)object.nextElement();
            vector2 = (Vector)hashtable.get(namespace);
            if (vector2.size() <= 1) continue;
            this.computeUniqueNamesWithinNamespace(vector2);
        }
    }

    protected void computeUniqueNamesWithinNamespace(Vector vector) {
        int n = 0;
        do {
            this.setNames(vector, ++n);
        } while (this.duplicateNames(vector) && n < 50);
    }

    protected boolean containsIgnoreCase(Vector vector, String string) {
        int n = 0;
        while (n < vector.size()) {
            if (((String)vector.elementAt(n)).equalsIgnoreCase(string)) {
                return true;
            }
            ++n;
        }
        return false;
    }

    protected boolean duplicateNames(Vector vector) {
        Hashtable<String, String> hashtable = new Hashtable<String, String>();
        Iterator iterator = ((AbstractList)vector).iterator();
        while (iterator.hasNext()) {
            Data data = (Data)iterator.next();
            String string = data.getXMIName();
            if (string.equals("")) continue;
            int n = string.indexOf(":");
            if (n != -1) {
                string = string.substring(n + 1);
            }
            if (hashtable.get(string = string.toLowerCase()) != null) {
                return true;
            }
            hashtable.put(string, "");
        }
        return false;
    }

    protected Vector getFeatures(XMIContainer xMIContainer, XMIObject xMIObject) {
        Vector vector = new Vector();
        this.getSuperclasses(xMIObject, vector);
        Vector vector2 = new Vector();
        int n = 0;
        while (n < vector.size()) {
            XMIObject xMIObject2 = (XMIObject)vector.elementAt(n);
            Vector vector3 = this.getClassifierAttributes(xMIObject2);
            Vector vector4 = this.getClassifierLinks(xMIObject2);
            int n2 = 0;
            while (n2 < vector3.size()) {
                vector2.addElement(vector3.elementAt(n2));
                ++n2;
            }
            int n3 = 0;
            while (n3 < vector4.size()) {
                vector2.addElement(vector4.elementAt(n3));
                ++n3;
            }
            ++n;
        }
        return vector2;
    }

    protected Collection getLiteralNames(XMIObject xMIObject) {
        Vector<String> vector = new Vector<String>();
        if (this.isBoolean(xMIObject)) {
            vector.addElement("true");
            vector.addElement("false");
            return vector;
        }
        Vector vector2 = this.getClassifierAttributes(xMIObject);
        if (vector2.size() == 0) {
            Vector vector3 = this.getObjectPropertyValues(xMIObject, UML_ENUM_LITERAL);
            if (vector3.size() > 0) {
                int n = 0;
                while (n < vector3.size()) {
                    vector.addElement(this.getXMIValue((XMIObject)vector3.elementAt(n), UML_ENUM_LITERAL_NAME));
                    ++n;
                }
                return vector;
            }
            return vector;
        }
        int n = 0;
        while (n < vector2.size()) {
            vector.addElement(this.getXMIValue((XMIObject)vector2.elementAt(n), UML_NAME));
            ++n;
        }
        return vector;
    }

    protected Vector getClassAttributes(XMIContainer xMIContainer) {
        Vector vector = this.getClasses(xMIContainer);
        Vector vector2 = new Vector();
        int n = 0;
        while (n < vector.size()) {
            XMIObject xMIObject = (XMIObject)vector.elementAt(n);
            Vector vector3 = this.getClassifierAttributes(xMIObject);
            int n2 = 0;
            while (n2 < vector3.size()) {
                vector2.addElement(vector3.elementAt(n2));
                ++n2;
            }
            ++n;
        }
        return vector2;
    }

    protected Vector getClasses(XMIContainer xMIContainer) {
        Iterator iterator = xMIContainer.getData(UML_CLASS).iterator();
        if (!iterator.hasNext()) {
            iterator = xMIContainer.getData(MOF_CLASS).iterator();
        }
        Vector<XMIObject> vector = new Vector<XMIObject>();
        while (iterator.hasNext()) {
            XMIObject xMIObject = (XMIObject)iterator.next();
            if (this.isDataType(xMIObject) || this.isBoolean(xMIObject)) continue;
            vector.addElement(xMIObject);
        }
        return vector;
    }

    protected Vector getClassifierAttributes(XMIObject xMIObject) {
        Vector vector = new Vector();
        Vector vector2 = this.getObjectPropertyValues(xMIObject, UML_FEATURE);
        if (vector2.size() == 0) {
            vector2 = this.getObjectPropertyValues(xMIObject, MOF_CONTENTS);
        }
        int n = 0;
        while (n < vector2.size()) {
            if (((XMIObject)vector2.elementAt(n)).getXMIName().equals(UML_ATTRIBUTE)) {
                vector.addElement(vector2.elementAt(n));
            } else if (((XMIObject)vector2.elementAt(n)).getXMIName().equals(MOF_ATTRIBUTE)) {
                vector.addElement(vector2.elementAt(n));
            }
            ++n;
        }
        return vector;
    }

    protected Vector getClassifierLinks(XMIObject xMIObject) {
        Vector<XMIObject> vector = new Vector<XMIObject>();
        Vector vector2 = this.getObjectPropertyValues(xMIObject, UML_ASSOCIATION_ENDS);
        int n = 0;
        while (n < vector2.size()) {
            String string;
            XMIObject xMIObject2 = (XMIObject)vector2.elementAt(n);
            XMIObject xMIObject3 = this.getOppositeEnd(xMIObject2);
            if (!(xMIObject3 == null || (string = this.getXMIValue(xMIObject3, UML_IS_NAVIGABLE)) != null && string.equals("false") || this.getName(xMIObject3).startsWith("/"))) {
                vector.addElement(xMIObject3);
            }
            ++n;
        }
        return vector;
    }

    protected Object getAssociationEndContainer(XMIObject xMIObject) {
        XMIObject xMIObject2 = this.getOppositeEnd(xMIObject);
        if (xMIObject2 == null) {
            return null;
        }
        return this.wrapper.getValue(xMIObject2, UML_END_TYPE);
    }

    protected Object getContainer(XMIObject xMIObject) {
        XMIObject xMIObject2;
        if (xMIObject.getXMIName().equals(UML_ASSOCIATION_END)) {
            return this.getAssociationEndContainer(xMIObject);
        }
        Vector vector = this.getObjectPropertyValues(xMIObject, UML_NAMESPACE);
        if (vector.size() == 0) {
            vector = this.getObjectPropertyValues(xMIObject, MOF_CONTAINER);
        }
        if (vector.size() == 0) {
            vector = this.getObjectPropertyValues(xMIObject, UML_OWNER);
        }
        if (vector.size() > 0 && !(xMIObject2 = (XMIObject)vector.firstElement()).getXMIName().equals(UML_MODEL)) {
            return xMIObject2;
        }
        return null;
    }

    public String getFullName(XMIObject xMIObject, int n) {
        String string = this.getName(xMIObject);
        int n2 = 0;
        XMIObject xMIObject2 = (XMIObject)this.getContainer(xMIObject);
        while (n2 < n && xMIObject2 != null) {
            string = this.getName(xMIObject2) + "." + string;
            ++n2;
            xMIObject2 = (XMIObject)this.getContainer(xMIObject2);
        }
        return string;
    }

    protected String getName(XMIObject xMIObject) {
        String string = this.getXMIValue(xMIObject, UML_NAME);
        if (string == null) {
            string = this.getXMIValue(xMIObject, MOF_NAME);
        }
        return string;
    }

    protected Vector getObjectPropertyValues(Data data, String string) {
        Collection collection = null;
        if (data instanceof XMIObject) {
            collection = this.wrapper.getProperties(((XMIObject)data).getXMIValues());
        } else if (data instanceof XMIClass) {
            collection = this.wrapper.getProperties(((XMIClass)data).getXMIFeatures());
        }
        Iterator iterator = collection.iterator();
        Vector<Object> vector = new Vector<Object>();
        while (iterator.hasNext()) {
            Object e = iterator.next();
            int n = this.wrapper.getType(e);
            if (n != 8 || !this.wrapper.getXMIName(e).equals(string) || this.wrapper.getValue(e) == null) continue;
            Object object = this.wrapper.getValue(e);
            if (object instanceof Collection) {
                Iterator iterator2 = ((Collection)object).iterator();
                while (iterator2.hasNext()) {
                    vector.addElement(iterator2.next());
                }
                continue;
            }
            vector.addElement(object);
        }
        return vector;
    }

    protected XMIObject getOppositeEnd(XMIObject xMIObject) {
        XMIObject xMIObject2 = (XMIObject)this.wrapper.getValue(xMIObject, UML_ASSOCIATIONS);
        Vector vector = this.getObjectPropertyValues(xMIObject2, UML_CONNECTION);
        int n = 0;
        while (n < vector.size()) {
            if (!vector.elementAt(n).equals(xMIObject)) {
                return (XMIObject)vector.elementAt(n);
            }
            ++n;
        }
        return null;
    }

    protected Vector getPackages(XMIContainer xMIContainer) {
        Iterator iterator = xMIContainer.getData(UML_PACKAGE).iterator();
        if (!iterator.hasNext()) {
            iterator = xMIContainer.getData(MOF_PACKAGE).iterator();
        }
        Vector vector = new Vector();
        while (iterator.hasNext()) {
            vector.addElement(iterator.next());
        }
        return vector;
    }

    protected void getSuperclasses(XMIObject xMIObject, Vector vector) {
        if (vector.contains(xMIObject)) {
            return;
        }
        vector.addElement(xMIObject);
        Vector vector2 = this.getObjectPropertyValues(xMIObject, UML_GENERALIZATIONS);
        int n = 0;
        while (n < vector2.size()) {
            XMIObject xMIObject2 = (XMIObject)this.wrapper.getValue((XMIObject)vector2.elementAt(n), UML_SUPERTYPE);
            if (xMIObject2 != null) {
                this.getSuperclasses(xMIObject2, vector);
            }
            ++n;
        }
    }

    protected String getXMIValue(XMIObject xMIObject, String string) {
        Object object;
        if (xMIObject == null) {
            return null;
        }
        Iterator iterator = this.wrapper.getProperties(this.wrapper.getValues(xMIObject)).iterator();
        Object object2 = null;
        while (iterator.hasNext()) {
            object = (Data)iterator.next();
            if (object.getXMIName() == null || !object.getXMIName().equals(string)) continue;
            object2 = object;
            break;
        }
        if (object2 == null || this.wrapper.getType(object2) == 8) {
            return null;
        }
        object = this.wrapper.getValue(object2);
        if (object instanceof String) {
            return (String)object;
        }
        if (object instanceof Collection) {
            return (String)((Collection)object).iterator().next();
        }
        return (String)this.wrapper.getValue(object2);
    }

    protected boolean isBoolean(XMIObject xMIObject) {
        if (xMIObject == null) {
            return false;
        }
        if (!(xMIObject.getXMIName().equals(UML_PRIMITIVE) || xMIObject.getXMIName().equals(UML_DATA_TYPE) || xMIObject.getXMIName().equals(UML_CLASS))) {
            return false;
        }
        String string = this.getXMIValue(xMIObject, UML_NAME);
        if (string == null) {
            return false;
        }
        return string.equalsIgnoreCase("boolean");
    }

    protected boolean isDataType(XMIObject xMIObject) {
        if (this.getName(xMIObject).equalsIgnoreCase("boolean")) {
            return false;
        }
        Vector vector = this.getObjectPropertyValues(xMIObject, UML_STEREOTYPE);
        int n = 0;
        while (n < vector.size()) {
            XMIObject xMIObject2 = (XMIObject)vector.elementAt(n);
            String string = this.getName(xMIObject2);
            if (string != null && string.equals("datatype")) {
                return true;
            }
            ++n;
        }
        return false;
    }

    public Collection makeDeclarations(Iterator iterator) {
        Vector vector = new Vector(10);
        while (iterator.hasNext()) {
            vector.addElement(iterator.next());
        }
        XMIContainer xMIContainer = new XMIContainer(((AbstractList)vector).iterator());
        return Collections.unmodifiableCollection(this.makeClassesAndPackages(xMIContainer));
    }

    public Collection makeDeclarations(XMIContainer xMIContainer) {
        return Collections.unmodifiableCollection(this.makeClassesAndPackages(xMIContainer));
    }

    protected Vector makeClassesAndPackages(XMIContainer xMIContainer) {
        Vector vector = new Vector();
        this.objectToUserObject = new Hashtable();
        this.processNamespaces();
        this.processPackages(xMIContainer, vector);
        this.processClasses(xMIContainer, vector);
        this.processGeneralizations(xMIContainer);
        this.computeFeatureNames(xMIContainer);
        this.processAttributes(xMIContainer);
        this.processAssociationEnds(xMIContainer);
        Namespaces namespaces = new Namespaces(this.namespaces, vector);
        namespaces.setNamespaces();
        this.adjustNames();
        return vector;
    }

    protected void makeLinkDef(XMIObject xMIObject, String string, String string2, XMIClass xMIClass, XMIClass xMIClass2) {
        String string3 = this.getXMIValue(xMIObject, UML_IS_NAVIGABLE);
        if (string3 != null && string3.equals("false") || string == null || string.indexOf("/") != -1) {
            return;
        }
        try {
            int n = 1;
            if (string2.equals("ref")) {
                n = 2;
            } else if (string2.equals("container")) {
                n = 3;
            } else if (string2.equals("contained")) {
                n = 4;
            }
            Feature feature = this.factory.makeFeature(xMIClass2, string, xMIClass, n, this.getXMIValue(xMIObject, UML_MULTIPLICITY));
            xMIObject.setXMIDerived(feature);
            feature.setXMISource(xMIObject);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    protected Vector orderPackages(Vector vector) {
        Vector<XMIObject> vector2 = new Vector<XMIObject>(vector.size());
        int n = 0;
        while (n < vector.size()) {
            XMIObject xMIObject = (XMIObject)vector.elementAt(n);
            Object object = this.getContainer(xMIObject);
            if (object == null) {
                vector2.insertElementAt(xMIObject, 0);
            } else {
                int n2 = vector2.indexOf(object);
                while (n2 == -1 && object != null) {
                    if ((object = this.getContainer((XMIObject)object)) == null) continue;
                    n2 = vector2.indexOf(object);
                }
                if (n2 == -1) {
                    vector2.insertElementAt(xMIObject, 0);
                } else if (n2 == vector2.size() - 1) {
                    vector2.addElement(xMIObject);
                } else {
                    vector2.insertElementAt(xMIObject, n2 + 1);
                }
            }
            ++n;
        }
        return vector2;
    }

    protected void processAssociationEnds(XMIContainer xMIContainer) {
        Iterator iterator = xMIContainer.getData(UML_ASSOCIATION).iterator();
        while (iterator.hasNext()) {
            XMIObject xMIObject = (XMIObject)iterator.next();
            Vector vector = this.getObjectPropertyValues(xMIObject, UML_CONNECTION);
            if (vector.size() != 2) continue;
            XMIObject xMIObject2 = (XMIObject)vector.elementAt(0);
            XMIObject xMIObject3 = (XMIObject)vector.elementAt(1);
            Data data = (Data)this.wrapper.getValue(xMIObject2, UML_END_TYPE);
            Data data2 = (Data)this.wrapper.getValue(xMIObject3, UML_END_TYPE);
            if (data == null || data2 == null) continue;
            String string = this.getName(xMIObject2);
            String string2 = this.getName(xMIObject3);
            data = (Data)this.objectToUserObject.get(data);
            data2 = (Data)this.objectToUserObject.get(data2);
            if (data == null || data2 == null) continue;
            String string3 = this.getXMIValue(xMIObject2, UML_AGG_PROPERTY);
            String string4 = this.getXMIValue(xMIObject3, UML_AGG_PROPERTY);
            boolean bl = false;
            boolean bl2 = false;
            if (string3 != null && string3.equals("composite")) {
                bl2 = true;
            }
            if (string4 != null && string4.equals("composite")) {
                bl = true;
            }
            if (bl) {
                this.makeLinkDef(xMIObject2, (String)this.featureToName.get(xMIObject2), "contained", (XMIClass)data, (XMIClass)data2);
                this.makeLinkDef(xMIObject3, (String)this.featureToName.get(xMIObject3), "container", (XMIClass)data2, (XMIClass)data);
                continue;
            }
            if (bl2) {
                this.makeLinkDef(xMIObject3, (String)this.featureToName.get(xMIObject3), "contained", (XMIClass)data2, (XMIClass)data);
                this.makeLinkDef(xMIObject2, (String)this.featureToName.get(xMIObject2), "container", (XMIClass)data, (XMIClass)data2);
                continue;
            }
            this.makeLinkDef(xMIObject2, (String)this.featureToName.get(xMIObject2), "ref", (XMIClass)data, (XMIClass)data2);
            this.makeLinkDef(xMIObject3, (String)this.featureToName.get(xMIObject3), "ref", (XMIClass)data2, (XMIClass)data);
        }
    }

    protected void processAttributes(XMIContainer xMIContainer) {
        Vector vector = this.getClasses(xMIContainer);
        int n = 0;
        while (n < vector.size()) {
            XMIObject xMIObject = (XMIObject)vector.elementAt(n);
            XMIClass xMIClass = (XMIClass)this.objectToUserObject.get(xMIObject);
            Vector vector2 = this.getClassifierAttributes(xMIObject);
            int n2 = 0;
            while (n2 < vector2.size()) {
                try {
                    Object object;
                    Object object2;
                    Object object3;
                    XMIObject xMIObject2 = (XMIObject)vector2.elementAt(n2);
                    String string = (String)this.featureToName.get(xMIObject2);
                    XMIObject xMIObject3 = (XMIObject)this.wrapper.getValue(xMIObject2, UML_ATTRIB_TYPE);
                    if (xMIObject3 == null) {
                        xMIObject3 = (XMIObject)this.wrapper.getValue(xMIObject2, MOF_ATTRIB_TYPE);
                    }
                    Feature feature = null;
                    if (xMIObject3 == null || (xMIObject3.getXMIName().equals(UML_PRIMITIVE) || xMIObject3.getXMIName().equals(UML_DATA_TYPE)) && !this.isBoolean(xMIObject3) || xMIObject3.getXMIName().equals(UML_CLASS) && this.isDataType(xMIObject3)) {
                        object3 = this.getXMIValue(xMIObject3, UML_NAME);
                        object2 = null;
                        if (xMIObject3 != null) {
                            if (this.objectToUserObject.get(xMIObject3) != null) {
                                object2 = (Datatype)this.objectToUserObject.get(xMIObject3);
                            } else {
                                object = this.getContainer(xMIObject3);
                                if (object != null) {
                                    object = this.objectToUserObject.get(object);
                                }
                                object2 = this.factory.makeDatatype(object, (String)object3);
                                this.objectToUserObject.put(xMIObject3, object2);
                                object2.setXMISource(xMIObject3);
                            }
                        }
                        feature = this.factory.makeFeature(xMIClass, string, object2, 7, null);
                    } else if (xMIObject3.getXMIName().equals(UML_ENUMERATION) || this.isBoolean(xMIObject3)) {
                        object3 = this.getXMIValue(xMIObject3, UML_NAME);
                        object2 = this.getLiteralNames(xMIObject3);
                        object = null;
                        if (this.objectToUserObject.get(xMIObject3) != null) {
                            object = (Enum)this.objectToUserObject.get(xMIObject3);
                        } else {
                            Object object4 = this.getContainer(xMIObject3);
                            if (object4 != null) {
                                object4 = this.objectToUserObject.get(object4);
                            }
                            object = this.factory.makeEnum(object4, (String)object3, object2.iterator());
                            this.objectToUserObject.put(xMIObject3, object);
                            object.setXMISource(xMIObject3);
                        }
                        feature = this.factory.makeFeature(xMIClass, string, object, 6, null);
                    } else if (xMIObject3.getXMIName().equals(UML_CLASS)) {
                        object3 = (XMIClass)this.objectToUserObject.get(xMIObject3);
                        feature = this.factory.makeFeature(xMIClass, string, object3, 8, null);
                    }
                    this.setMultiplicity(feature, xMIObject2);
                    xMIObject2.setXMIDerived(feature);
                    feature.setXMISource(xMIObject2);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
                ++n2;
            }
            ++n;
        }
    }

    private void setMultiplicity(Data data, XMIObject xMIObject) {
        if (!(data instanceof Feature)) {
            return;
        }
        Feature feature = (Feature)data;
        String string = this.getMultiplicity(xMIObject);
        if (string != null) {
            feature.setXMIMultiplicity(string);
        }
    }

    private String getMultiplicity(XMIObject xMIObject) {
        Vector vector = this.getObjectPropertyValues(xMIObject, UML_STEREOTYPE);
        int n = 0;
        while (n < vector.size()) {
            XMIObject xMIObject2 = (XMIObject)vector.elementAt(n);
            String string = this.getName(xMIObject2);
            if (string != null && !string.equals("datatype")) {
                return string;
            }
            ++n;
        }
        return null;
    }

    protected void processClasses(XMIContainer xMIContainer, Vector vector) {
        Vector vector2 = this.getClasses(xMIContainer);
        int n = 0;
        while (n < vector2.size()) {
            XMIObject xMIObject = (XMIObject)vector2.elementAt(n);
            Object object = this.getContainer(xMIObject);
            String string = this.wrapper.getSimpleName(this.getFullName(xMIObject, 0));
            try {
                if (object != null) {
                    object = this.objectToUserObject.get(object);
                }
                XMIClass xMIClass = this.factory.makeXMIClass(object, string);
                this.objectToUserObject.put(xMIObject, xMIClass);
                if (object == null) {
                    vector.addElement(xMIClass);
                }
                xMIObject.setXMIDerived(xMIClass);
                xMIClass.setXMISource(xMIObject);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            ++n;
        }
    }

    protected void processGeneralizations(XMIContainer xMIContainer) {
        Object object;
        Data data;
        Object object2;
        Iterator iterator = xMIContainer.getData(UML_GENERALIZATION).iterator();
        while (iterator.hasNext()) {
            try {
                object2 = (XMIObject)iterator.next();
                XMIObject xMIObject = (XMIObject)this.wrapper.getValue(object2, UML_SUBTYPE);
                data = (XMIObject)this.wrapper.getValue(object2, UML_SUPERTYPE);
                if (xMIObject == null || data == null) continue;
                object = null;
                XMIClass xMIClass = null;
                if (xMIObject != null) {
                    object = (XMIClass)this.objectToUserObject.get(xMIObject);
                }
                if (data != null) {
                    xMIClass = (XMIClass)this.objectToUserObject.get(data);
                }
                this.factory.makeInheritance(object, xMIClass);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        object2 = this.getClasses(xMIContainer);
        int n = 0;
        while (n < ((Vector)object2).size()) {
            data = (XMIClass)this.objectToUserObject.get(((Vector)object2).elementAt(n));
            object = this.getObjectPropertyValues((XMIObject)((Vector)object2).elementAt(n), MOF_SUPERTYPES);
            int n2 = 0;
            while (n2 < ((Vector)object).size()) {
                XMIClass xMIClass = (XMIClass)this.objectToUserObject.get(((Vector)object).elementAt(n2));
                this.factory.makeInheritance(data, xMIClass);
                ++n2;
            }
            ++n;
        }
    }

    protected void processNamespaces() {
        if (this.namespaceFile == null) {
            return;
        }
        try {
            SAXParserFactory sAXParserFactory = SAXParserFactory.newInstance();
            SAXParser sAXParser = sAXParserFactory.newSAXParser();
            NamespaceHandler namespaceHandler = new NamespaceHandler(this);
            sAXParser.parse(new InputSource(new FileInputStream(new File(this.namespaceFile))), (DefaultHandler)namespaceHandler);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    protected void processPackages(XMIContainer xMIContainer, Vector vector) {
        Vector vector2 = this.getPackages(xMIContainer);
        vector2 = this.orderPackages(vector2);
        this.removeIDLPackage(xMIContainer, vector2);
        this.packagesAndClasses = (Vector)this.getClasses(xMIContainer).clone();
        int n = 0;
        while (n < vector2.size()) {
            this.packagesAndClasses.addElement(vector2.elementAt(n));
            ++n;
        }
        int n2 = 0;
        while (n2 < vector2.size()) {
            XMIObject xMIObject = (XMIObject)vector2.elementAt(n2);
            Object object = this.getContainer(xMIObject);
            String string = this.wrapper.getSimpleName(this.getFullName(xMIObject, 0));
            if (object == null) {
                string = this.getName(xMIObject);
            }
            try {
                if (object != null) {
                    object = this.objectToUserObject.get(object);
                }
                Package package_ = this.factory.makePackage(object, string);
                this.objectToUserObject.put(xMIObject, package_);
                if (object == null) {
                    vector.addElement(package_);
                }
                xMIObject.setXMIDerived(package_);
                package_.setXMISource(xMIObject);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            ++n2;
        }
    }

    public void register(String string, String string2, String string3) {
        Namespace namespace = new Namespace(string, string2);
        this.namespaces.addElement(string3);
        this.namespaces.addElement(namespace);
    }

    protected void removeIDLPackage(XMIContainer xMIContainer, Vector vector) {
        int n = -1;
        int n2 = 0;
        while (n2 < vector.size()) {
            String string = this.getName((XMIObject)vector.elementAt(n2));
            if (string != null && string.equals("IDL_DATATYPE")) {
                n = n2;
            }
            ++n2;
        }
        if (n == -1) {
            return;
        }
        vector.removeElementAt(n);
        this.removeIDLPackage(xMIContainer, vector);
    }

    protected void setNames(Vector vector, int n) {
        Iterator iterator = ((AbstractList)vector).iterator();
        while (iterator.hasNext()) {
            Data data = (Data)iterator.next();
            String string = this.wrapper.getFullName(data, n);
            int n2 = string.indexOf(":");
            if (n2 != -1) {
                string = string.substring(n2 + 1);
            }
            try {
                data.setXMIName(string);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }
}

