/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xmi.framework;

import com.ibm.xmi.framework.BadDefinerException;
import com.ibm.xmi.framework.Data;
import com.ibm.xmi.framework.DataImpl;
import com.ibm.xmi.framework.Extension;
import com.ibm.xmi.framework.FactoryRegister;
import com.ibm.xmi.framework.NoExtensionException;
import com.ibm.xmi.framework.NoValueException;
import com.ibm.xmi.framework.Value;
import com.ibm.xmi.framework.XMIClass;
import com.ibm.xmi.framework.XMIException;
import com.ibm.xmi.framework.XMIObject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.Vector;

public class XMIObjectImpl
extends DataImpl
implements XMIObject {
    private static final String copyright = "Licensed Materials-Property of IBM\n(C) Copyright IBM Corp. 1999-2002. All Rights Reserved.\nUS Government Users Restricted Rights-Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.";
    private String id;
    private String uuid;
    private String label;
    private String href;
    private boolean isProxy = false;
    private Collection extensions;
    private Collection values;

    public XMIObjectImpl() {
    }

    public XMIObjectImpl(String string) {
        super(string);
    }

    public XMIObjectImpl(String string, Collection collection) {
        this(string);
        this.values = collection;
    }

    public XMIObjectImpl(Data data) {
        super(data);
    }

    public void add(Value value) {
        if (this.values == null) {
            this.values = new ArrayList(5);
        }
        this.values.add(value);
        value.setXMIOwner(this);
    }

    public void add(Extension extension) {
        if (this.extensions == null) {
            this.extensions = new Vector(5);
        }
        this.extensions.add(extension);
    }

    public Value addXMIValue(String string, Object object) {
        int n = 1;
        if (object instanceof String) {
            n = 7;
        } else if (object instanceof XMIObject) {
            n = 2;
        }
        return this.addXMIValue(string, object, n);
    }

    public Value addXMIValue(String string, Object object, int n) {
        Value value = this.getXMIValue(string);
        if (value == null) {
            value = FactoryRegister.getFactory().makeValue(string, object, n);
            this.add(value);
        } else if (object == null || value.getXMIValue() == null) {
            value.setXMIValue(object);
        } else if (value.getXMIValue() instanceof Collection) {
            if (object instanceof Collection) {
                ((Collection)value.getXMIValue()).addAll((Collection)object);
            } else {
                ((Collection)value.getXMIValue()).add(object);
            }
        } else {
            ArrayList<Object> arrayList = new ArrayList<Object>(5);
            arrayList.add(value.getXMIValue());
            arrayList.add(object);
            value.setXMIValue(arrayList);
        }
        return value;
    }

    public void delete(Value value) throws XMIException {
        if (this.values == null) {
            throw new NoValueException(value);
        }
        boolean bl = this.values.remove(value);
        if (!bl) {
            throw new NoValueException(value);
        }
    }

    public void delete(Extension extension) throws XMIException {
        if (this.extensions == null) {
            throw new NoExtensionException(extension);
        }
        boolean bl = this.extensions.remove(extension);
        if (!bl) {
            throw new NoExtensionException(extension);
        }
    }

    public void delete(String string) {
        if (this.values == null) {
            return;
        }
        Value value = null;
        Iterator iterator = this.values.iterator();
        while (iterator.hasNext()) {
            Value value2 = (Value)iterator.next();
            if (value2.getXMIName() == null || !value2.getXMIName().equals(string)) continue;
            value = value2;
        }
        if (value != null) {
            try {
                this.delete(value);
            }
            catch (XMIException xMIException) {
                // empty catch block
            }
        }
    }

    public void demandLoad() {
        String string = this.getXMIHref();
        if (string == null) {
            return;
        }
        int n = string.indexOf("|");
        if (n == -1) {
            n = string.indexOf("#");
        }
        if (n != -1) {
            string = string.substring(0, n);
        }
        if (string.startsWith("/")) {
            string = string.substring(1);
        }
        try {
            if (this.getXMIFile() != null && this.getXMIFile().getXMIFiles() != null && this.getXMIFile().getXMIFiles().isDemandLoad()) {
                this.getXMIFile().getXMIFiles().load(string, 1, false);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public Collection getContained() {
        if (this.isXMIProxy()) {
            this.demandLoad();
        }
        Vector<Object> vector = new Vector<Object>();
        if (this.values != null) {
            Iterator iterator = this.values.iterator();
            while (iterator.hasNext()) {
                Value value = (Value)iterator.next();
                if (value.getXMIType() != 4) continue;
                if (value.getXMIValue() instanceof XMIObject) {
                    vector.add(value.getXMIValue());
                    continue;
                }
                if (!(value.getXMIValue() instanceof Collection)) continue;
                Iterator iterator2 = ((Collection)value.getXMIValue()).iterator();
                while (iterator2.hasNext()) {
                    Object e = iterator2.next();
                    if (!(e instanceof XMIObject)) continue;
                    vector.add(e);
                }
            }
        }
        return vector;
    }

    public Collection getXMIExtensions() {
        if (this.isXMIProxy()) {
            this.demandLoad();
        }
        if (this.extensions == null) {
            return new Vector(1);
        }
        return Collections.unmodifiableCollection(this.extensions);
    }

    public String getXMIHref() {
        return this.href;
    }

    public String getXMIId() {
        return this.id;
    }

    public String getXMILabel() {
        return this.label;
    }

    public Collection getXMIValues() {
        if (this.isXMIProxy()) {
            this.demandLoad();
        }
        if (this.values == null) {
            return new ArrayList(0);
        }
        return Collections.unmodifiableCollection(this.values);
    }

    public Collection getXMISets() {
        if (this.isXMIProxy()) {
            this.demandLoad();
        }
        return super.getXMISets();
    }

    public String getXMITagValue(String string, String string2) {
        if (this.isXMIProxy()) {
            this.demandLoad();
        }
        return super.getXMITagValue(string, string2);
    }

    public Collection getXMITags(String string) {
        if (this.isXMIProxy()) {
            this.demandLoad();
        }
        return super.getXMITags(string);
    }

    public String getXMIUUID() {
        return this.uuid;
    }

    public Object getXMIValueOfValue(String string) {
        Value value = this.getXMIValue(string);
        if (value != null) {
            return value.getXMIValue();
        }
        return null;
    }

    public Value getXMIValue(String string) {
        if (this.values == null) {
            return null;
        }
        Iterator iterator = this.values.iterator();
        while (iterator.hasNext()) {
            Value value = (Value)iterator.next();
            if (value.getXMIName() == null || !value.getXMIName().equals(string) && !this.specialIgnoreNamespaceEquals(value.getXMIName(), string)) continue;
            return value;
        }
        return null;
    }

    private boolean ignoreNamespaceEquals(String string, String string2) {
        int n = string.indexOf(":");
        String string3 = string;
        if (n != -1) {
            string3 = string.substring(n + 1);
        }
        return string3.equals(string2);
    }

    private boolean specialIgnoreNamespaceEquals(String string, String string2) {
        int n = string.indexOf(":");
        String string3 = string;
        if (n != -1) {
            string3 = string.substring(n + 1);
        }
        if (string3.equals(string2)) {
            return true;
        }
        n = string2.lastIndexOf(".");
        String string4 = string2;
        if (n != -1) {
            string4 = string2.substring(n + 1);
        }
        return string3.equals(string4);
    }

    public boolean isXMIProxy() {
        return this.isProxy;
    }

    public void setXMIDefiner(Data data) throws XMIException {
        if (data != null && !(data instanceof XMIClass)) {
            throw new BadDefinerException(data);
        }
        super.setXMIDefiner(data);
    }

    public void setXMIHref(String string) {
        this.href = string;
    }

    public void setXMIId(String string) {
        this.id = string;
    }

    public void setXMILabel(String string) {
        this.label = string;
    }

    public void setXMIProxy(boolean bl) {
        this.isProxy = bl;
    }

    public void setXMITagValue(String string, String string2, String string3) {
        if (this.isXMIProxy()) {
            this.demandLoad();
        }
        super.setXMITagValue(string, string2, string3);
    }

    public void setXMIUUID(String string) {
        this.uuid = string;
    }

    public Value setXMIValue(String string, Object object) {
        Value value = this.getXMIValue(string);
        if (value != null) {
            value.setXMIValue(object);
        } else {
            value = this.addXMIValue(string, object);
        }
        return value;
    }

    public Value setXMIValue(String string, Object object, int n) {
        Value value = this.getXMIValue(string);
        if (value != null) {
            value.setXMIValue(object);
        } else {
            value = this.addXMIValue(string, object, n);
        }
        return value;
    }

    public String toString() {
        String string = "XMIObject " + this.getXMIName();
        if (this.getXMILabel() != null) {
            string = string + " " + this.getXMILabel();
        } else if (this.getXMIId() != null) {
            string = string + " " + this.getXMIId();
        } else if (this.getXMIUUID() != null) {
            string = string + " " + this.getXMIUUID();
        } else if (this.getXMIOwner() != null) {
            string = string + " owner: [" + this.getXMIOwner() + "]";
        }
        return string;
    }
}

