/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.swing.graphics;

import java.awt.geom.GeneralPath;

public class Scale {
    private static int[] p = new int[]{2, 2, 5, 5, 5, 10, 10, 10, 20, 20, 50, 50};
    private static int[] ps = new int[]{2, 10, 5, 10, 20, 10, 20, 50, 20, 100, 50, 100};
    public static final int LEFT_TICKS = 0;
    public static final int RIGHT_TICKS = 1;
    public static final int BOTH_TICKS = 2;
    protected static float primaryTickSize = 8.0f;
    protected static float secondaryTickSize = 5.0f;

    public static void setTickSizes(float primaryTickSize, float secondaryTickSize) {
        Scale.primaryTickSize = primaryTickSize;
        Scale.secondaryTickSize = secondaryTickSize;
    }

    public static float getPrimaryTickSize() {
        return primaryTickSize;
    }

    public static float getSecondaryTickSize() {
        return secondaryTickSize;
    }

    private static void addTickMark(GeneralPath gp, int location, float tickPosition, float tickLength) {
        switch (location) {
            case 1: {
                gp.moveTo(tickPosition, 0.0f);
                gp.lineTo(tickPosition, tickLength);
                break;
            }
            case 0: {
                gp.moveTo(tickPosition, 0.0f);
                gp.lineTo(tickPosition, -tickLength);
                break;
            }
            case 2: {
                gp.moveTo(tickPosition, -tickLength);
                gp.lineTo(tickPosition, tickLength);
            }
        }
    }

    public static void drawLinearScale(double value0, double value1, int scaleSize, int minPrimary, int minSeparation, int location, GeneralPath primaryTicks, GeneralPath secondaryTicks, String[] label, double[] position) {
        double range = Math.abs(value1 - value0);
        int sign = value1 - value0 > 0.0 ? 1 : -1;
        double m = Math.pow(10.0, Math.ceil(Math.log(range) / Math.log(10.0)));
        double w = scaleSize;
        double minNP = m * (double)minPrimary / range;
        double maxNPNS = w * m / (range * (double)minSeparation);
        int optimal = -1;
        int oldPS = -1;
        int oldP = Integer.MAX_VALUE;
        for (int i = 0; i < p.length; ++i) {
            if (!((double)p[i] > minNP) || !((double)ps[i] < maxNPNS) || p[i] > oldP || ps[i] <= oldPS) continue;
            optimal = i;
            oldP = p[i];
            oldPS = ps[i];
        }
        primaryTicks.reset();
        secondaryTicks.reset();
        primaryTicks.moveTo(0.0f, 0.0f);
        primaryTicks.lineTo((float)w, 0.0f);
        secondaryTicks.moveTo(0.0f, 0.0f);
        secondaryTicks.lineTo((float)w, 0.0f);
        if (optimal > 0) {
            int iv;
            float tickPosition;
            double val;
            int iv2;
            double size = m / (double)ps[optimal];
            int average = (int)(0.5 * (value0 + value1) / size);
            int limit0 = (int)(value0 / size - (double)average) + average;
            int limit1 = (int)(value1 / size - (double)average) + average;
            for (iv2 = Math.min(limit0, limit1); iv2 <= Math.max(limit0, limit1); ++iv2) {
                val = (double)iv2 * size;
                tickPosition = Scale.interpolate(val, w, value0, value1);
                Scale.addTickMark(secondaryTicks, location, tickPosition, secondaryTickSize);
            }
            size = m / (double)p[optimal];
            average = (int)(0.5 * (value0 + value1) / size);
            limit0 = (int)(value0 / size - (double)average) + average;
            limit1 = (int)(value1 / size - (double)average) + average;
            for (iv2 = Math.min(limit0, limit1); iv2 <= Math.max(limit0, limit1); ++iv2) {
                val = (double)iv2 * size;
                tickPosition = Scale.interpolate(val, w, value0, value1);
                Scale.addTickMark(primaryTicks, location, tickPosition, primaryTickSize);
            }
            int ndigits = (int)Math.floor(Math.log(size) / Math.log(10.0));
            ndigits = -Math.min(ndigits, 0);
            int zero = iv = Math.min(limit0, limit1);
            double val2 = (double)iv * size;
            float tickPosition2 = Scale.interpolate(val2, w, value0, value1);
            label[0] = Scale.fixedPrecision(val2, ndigits);
            position[0] = tickPosition2;
            iv = Math.max(limit0, limit1);
            val2 = (double)iv * size;
            tickPosition2 = Scale.interpolate(val2, w, value0, value1);
            label[1] = Scale.fixedPrecision(val2, ndigits);
            position[1] = tickPosition2;
            if ((zero *= iv) <= 0) {
                tickPosition2 = Scale.interpolate(0.0, w, value0, value1);
                label[2] = Scale.fixedPrecision(0.0, ndigits);
                position[2] = tickPosition2;
            } else {
                label[2] = null;
                position[2] = position[1];
            }
        }
    }

    private static float interpolate(double value, double size, double value0, double value1) {
        return (float)(size * (value - value0) / (value1 - value0));
    }

    public static String fixedPrecision(double d, int ndigits) {
        String dstring = Double.toString(d);
        StringBuffer buffer = new StringBuffer(dstring);
        int index = dstring.lastIndexOf(".");
        if (index < 0) {
            buffer.append(".");
            index = buffer.length() - 1;
        }
        buffer.setLength(index + ndigits + 1);
        for (int i = 0; i < buffer.length(); ++i) {
            if (buffer.charAt(i) != '\u0000') continue;
            buffer.setCharAt(i, '0');
        }
        return buffer.toString();
    }
}

