/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.ext.awt.image.renderable;

import java.awt.image.RenderedImage;
import java.awt.image.renderable.RenderContext;
import org.apache.batik.ext.awt.image.ComponentTransferFunction;
import org.apache.batik.ext.awt.image.DiscreteTransfer;
import org.apache.batik.ext.awt.image.GammaTransfer;
import org.apache.batik.ext.awt.image.IdentityTransfer;
import org.apache.batik.ext.awt.image.LinearTransfer;
import org.apache.batik.ext.awt.image.TableTransfer;
import org.apache.batik.ext.awt.image.TransferFunction;
import org.apache.batik.ext.awt.image.renderable.AbstractColorInterpolationRable;
import org.apache.batik.ext.awt.image.renderable.ComponentTransferRable;
import org.apache.batik.ext.awt.image.renderable.Filter;
import org.apache.batik.ext.awt.image.rendered.ComponentTransferRed;

public class ComponentTransferRable8Bit
extends AbstractColorInterpolationRable
implements ComponentTransferRable {
    public static final int ALPHA = 0;
    public static final int RED = 1;
    public static final int GREEN = 2;
    public static final int BLUE = 3;
    private ComponentTransferFunction[] functions = new ComponentTransferFunction[4];
    private TransferFunction[] txfFunc = new TransferFunction[4];

    public ComponentTransferRable8Bit(Filter filter, ComponentTransferFunction componentTransferFunction, ComponentTransferFunction componentTransferFunction2, ComponentTransferFunction componentTransferFunction3, ComponentTransferFunction componentTransferFunction4) {
        super(filter, null);
        this.setAlphaFunction(componentTransferFunction);
        this.setRedFunction(componentTransferFunction2);
        this.setGreenFunction(componentTransferFunction3);
        this.setBlueFunction(componentTransferFunction4);
    }

    @Override
    public void setSource(Filter filter) {
        this.init(filter, null);
    }

    @Override
    public Filter getSource() {
        return (Filter)this.getSources().get(0);
    }

    @Override
    public ComponentTransferFunction getAlphaFunction() {
        return this.functions[0];
    }

    @Override
    public void setAlphaFunction(ComponentTransferFunction componentTransferFunction) {
        this.touch();
        this.functions[0] = componentTransferFunction;
        this.txfFunc[0] = null;
    }

    @Override
    public ComponentTransferFunction getRedFunction() {
        return this.functions[1];
    }

    @Override
    public void setRedFunction(ComponentTransferFunction componentTransferFunction) {
        this.touch();
        this.functions[1] = componentTransferFunction;
        this.txfFunc[1] = null;
    }

    @Override
    public ComponentTransferFunction getGreenFunction() {
        return this.functions[2];
    }

    @Override
    public void setGreenFunction(ComponentTransferFunction componentTransferFunction) {
        this.touch();
        this.functions[2] = componentTransferFunction;
        this.txfFunc[2] = null;
    }

    @Override
    public ComponentTransferFunction getBlueFunction() {
        return this.functions[3];
    }

    @Override
    public void setBlueFunction(ComponentTransferFunction componentTransferFunction) {
        this.touch();
        this.functions[3] = componentTransferFunction;
        this.txfFunc[3] = null;
    }

    @Override
    public RenderedImage createRendering(RenderContext renderContext) {
        RenderedImage renderedImage = this.getSource().createRendering(renderContext);
        if (renderedImage == null) {
            return null;
        }
        return new ComponentTransferRed(this.convertSourceCS(renderedImage), this.getTransferFunctions(), renderContext.getRenderingHints());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    private TransferFunction[] getTransferFunctions() {
        TransferFunction[] transferFunctionArray = new TransferFunction[4];
        System.arraycopy(this.txfFunc, 0, transferFunctionArray, 0, 4);
        ComponentTransferFunction[] componentTransferFunctionArray = new ComponentTransferFunction[4];
        System.arraycopy(this.functions, 0, componentTransferFunctionArray, 0, 4);
        int n = 0;
        while (n < 4) {
            if (transferFunctionArray[n] == null) {
                transferFunctionArray[n] = ComponentTransferRable8Bit.getTransferFunction(componentTransferFunctionArray[n]);
                ComponentTransferFunction[] componentTransferFunctionArray2 = this.functions;
                // MONITORENTER : this.functions
                if (this.functions[n] == componentTransferFunctionArray[n]) {
                    this.txfFunc[n] = transferFunctionArray[n];
                }
                // MONITOREXIT : componentTransferFunctionArray2
            }
            ++n;
        }
        return transferFunctionArray;
    }

    private static TransferFunction getTransferFunction(ComponentTransferFunction componentTransferFunction) {
        TransferFunction transferFunction = null;
        if (componentTransferFunction == null) {
            transferFunction = new IdentityTransfer();
        } else {
            switch (componentTransferFunction.getType()) {
                case 0: {
                    transferFunction = new IdentityTransfer();
                    break;
                }
                case 1: {
                    transferFunction = new TableTransfer(ComponentTransferRable8Bit.tableFloatToInt(componentTransferFunction.getTableValues()));
                    break;
                }
                case 2: {
                    transferFunction = new DiscreteTransfer(ComponentTransferRable8Bit.tableFloatToInt(componentTransferFunction.getTableValues()));
                    break;
                }
                case 3: {
                    transferFunction = new LinearTransfer(componentTransferFunction.getSlope(), componentTransferFunction.getIntercept());
                    break;
                }
                case 4: {
                    transferFunction = new GammaTransfer(componentTransferFunction.getAmplitude(), componentTransferFunction.getExponent(), componentTransferFunction.getOffset());
                    break;
                }
                default: {
                    throw new Error();
                }
            }
        }
        return transferFunction;
    }

    private static int[] tableFloatToInt(float[] fArray) {
        int[] nArray = new int[fArray.length];
        for (int i = 0; i < fArray.length; ++i) {
            nArray[i] = (int)(fArray[i] * 255.0f);
        }
        return nArray;
    }
}

