/*
 * Decompiled with CFR 0.152.
 */
package com.baselet.control.basics.geom;

import com.baselet.control.basics.geom.Line;
import com.baselet.control.basics.geom.PointDouble;
import com.baselet.control.basics.geom.Rectangle;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class GeometricFunctions {
    public static double distanceBetweenTwoPoints(PointDouble p1, PointDouble p2) {
        return GeometricFunctions.distanceBetweenTwoPoints(p1.x, p1.y, p2.x, p2.y);
    }

    public static double getDistanceBetweenLineAndPoint(PointDouble start, PointDouble end, PointDouble pointToCheck) {
        return GeometricFunctions.getDistanceBetweenLineAndPoint(start.x, start.y, end.x, end.y, pointToCheck.x, pointToCheck.y);
    }

    private static double distanceBetweenTwoPoints(double x1, double y1, double x2, double y2) {
        double xDist = x1 - x2;
        double yDist = y1 - y2;
        return Math.sqrt(xDist * xDist + yDist * yDist);
    }

    private static double getDistanceBetweenLineAndPoint(double x1, double y1, double x2, double y2, double checkX, double checkY) {
        double px = x2 - x1;
        double py = y2 - y1;
        double mult = px * px + py * py;
        double u = ((checkX - x1) * px + (checkY - y1) * py) / mult;
        if (u > 1.0) {
            u = 1.0;
        } else if (u < 0.0) {
            u = 0.0;
        }
        double x = x1 + u * px;
        double y = y1 + u * py;
        return GeometricFunctions.distanceBetweenTwoPoints(x, y, checkX, checkY);
    }

    public static PointDouble getPointOnLineWithDistanceFromStart(PointDouble start, PointDouble end, double distance) {
        double xDiff = end.getX() - start.getX();
        double yDiff = end.getY() - start.getY();
        double length = GeometricFunctions.distanceBetweenTwoPoints(start, end);
        double distanceToGo = distance / length;
        return new PointDouble(start.getX() + xDiff * distanceToGo, start.getY() + yDiff * distanceToGo);
    }

    public static PointDouble getIntersectionPoint(Line lineA, Line lineB) {
        double yi;
        double xi;
        double x1 = lineA.getStart().getX();
        double y1 = lineA.getStart().getY();
        double x2 = lineA.getEnd().getX();
        double y2 = lineA.getEnd().getY();
        double x3 = lineB.getStart().getX();
        double y3 = lineB.getStart().getY();
        double x4 = lineB.getEnd().getX();
        double y4 = lineB.getEnd().getY();
        PointDouble p = null;
        double d = (x1 - x2) * (y3 - y4) - (y1 - y2) * (x3 - x4);
        if (d != 0.0 && (lineA.getDistanceToPoint(p = new PointDouble(xi = ((x3 - x4) * (x1 * y2 - y1 * x2) - (x1 - x2) * (x3 * y4 - y3 * x4)) / d, yi = ((y3 - y4) * (x1 * y2 - y1 * x2) - (y1 - y2) * (x3 * y4 - y3 * x4)) / d)) > 1.0 || lineB.getDistanceToPoint(p) > 1.0)) {
            p = null;
        }
        return p;
    }

    public static List<PointDouble> getIntersectionPoints(Line line, Rectangle rectangle) {
        List<PointDouble> list = Arrays.asList(GeometricFunctions.getIntersectionPoint(line, new Line(new PointDouble(rectangle.getX(), rectangle.getY()), new PointDouble(rectangle.getX() + rectangle.getWidth(), rectangle.getY()))), GeometricFunctions.getIntersectionPoint(line, new Line(new PointDouble(rectangle.getX(), rectangle.getY() + rectangle.getHeight()), new PointDouble(rectangle.getX() + rectangle.getWidth(), rectangle.getY() + rectangle.getHeight()))), GeometricFunctions.getIntersectionPoint(line, new Line(new PointDouble(rectangle.getX(), rectangle.getY()), new PointDouble(rectangle.getX(), rectangle.getY() + rectangle.getHeight()))), GeometricFunctions.getIntersectionPoint(line, new Line(new PointDouble(rectangle.getX() + rectangle.getWidth(), rectangle.getY()), new PointDouble(rectangle.getX() + rectangle.getWidth(), rectangle.getY() + rectangle.getHeight()))));
        ArrayList<PointDouble> returnList = new ArrayList<PointDouble>();
        for (PointDouble p : list) {
            if (p == null) continue;
            returnList.add(p);
        }
        return returnList;
    }
}

