# encoding: UTF-8

class Vulnerability
  module Output
    # output the vulnerability
    def output(verbose = false)
      puts
      puts critical("Title: #{title}")

      references.each do |key, urls|
        methodname = "url_#{key}"

        urls.each do |u|
          next unless respond_to?(methodname)
          url = send(methodname, u)
          puts "    Reference: #{url}" if url
        end
      end
      
      puts notice("Fixed in: #{fixed_in}") if fixed_in
    end
  end
end
