/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.compiler.lookup;

import org.eclipse.jdt.internal.compiler.lookup.MethodBinding;
import org.eclipse.jdt.internal.compiler.lookup.TypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.TypeVariableBinding;

public class InferenceContext {
    private TypeBinding[][][] collectedSubstitutes;
    MethodBinding genericMethod;
    int depth;
    int status;
    TypeBinding expectedType;
    boolean hasExplicitExpectedType;
    public boolean isUnchecked;
    TypeBinding[] substitutes;
    static final int FAILED = 1;

    public InferenceContext(MethodBinding methodBinding) {
        this.genericMethod = methodBinding;
        TypeVariableBinding[] typeVariableBindingArray = methodBinding.typeVariables;
        int n = typeVariableBindingArray.length;
        this.collectedSubstitutes = new TypeBinding[n][3][];
        this.substitutes = new TypeBinding[n];
    }

    public TypeBinding[] getSubstitutes(TypeVariableBinding typeVariableBinding, int n) {
        return this.collectedSubstitutes[typeVariableBinding.rank][n];
    }

    public boolean hasUnresolvedTypeArgument() {
        int n = this.substitutes.length;
        for (int i = 0; i < n; ++i) {
            if (this.substitutes[i] != null) continue;
            return true;
        }
        return false;
    }

    public void recordSubstitute(TypeVariableBinding typeVariableBinding, TypeBinding typeBinding, int n) {
        block4: {
            int n2;
            TypeBinding[][] typeBindingArray = this.collectedSubstitutes[typeVariableBinding.rank];
            TypeBinding[] typeBindingArray2 = typeBindingArray[n];
            if (typeBindingArray2 == null) {
                n2 = 0;
                typeBindingArray2 = new TypeBinding[1];
            } else {
                n2 = typeBindingArray2.length;
                for (int i = 0; i < n2; ++i) {
                    TypeBinding typeBinding2 = typeBindingArray2[i];
                    if (typeBinding2 == typeBinding) {
                        return;
                    }
                    if (typeBinding2 != null) continue;
                    typeBindingArray2[i] = typeBinding;
                    break block4;
                }
                TypeBinding[] typeBindingArray3 = typeBindingArray2;
                typeBindingArray2 = new TypeBinding[n2 + 1];
                System.arraycopy(typeBindingArray3, 0, typeBindingArray2, 0, n2);
            }
            typeBindingArray2[n2] = typeBinding;
            typeBindingArray[n] = typeBindingArray2;
        }
    }

    public String toString() {
        int n;
        int n2;
        StringBuffer stringBuffer = new StringBuffer(20);
        stringBuffer.append("InferenceContex for ");
        int n3 = this.genericMethod.typeVariables.length;
        for (n2 = 0; n2 < n3; ++n2) {
            stringBuffer.append(this.genericMethod.typeVariables[n2]);
        }
        stringBuffer.append(this.genericMethod);
        stringBuffer.append("\n\t[status=");
        switch (this.status) {
            case 0: {
                stringBuffer.append("ok]");
                break;
            }
            case 1: {
                stringBuffer.append("failed]");
            }
        }
        if (this.expectedType == null) {
            stringBuffer.append(" [expectedType=null]");
        } else {
            stringBuffer.append(" [expectedType=").append(this.expectedType.shortReadableName()).append(']');
        }
        stringBuffer.append(" [depth=").append(this.depth).append(']');
        stringBuffer.append("\n\t[collected={");
        int n4 = n3 = this.collectedSubstitutes == null ? 0 : this.collectedSubstitutes.length;
        for (n2 = 0; n2 < n3; ++n2) {
            TypeBinding[][] typeBindingArray = this.collectedSubstitutes[n2];
            for (int i = 0; i <= 2; ++i) {
                TypeBinding[] typeBindingArray2 = typeBindingArray[i];
                if (typeBindingArray2 == null) continue;
                int n5 = typeBindingArray2.length;
                for (int j = 0; j < n5; ++j) {
                    stringBuffer.append("\n\t\t").append(this.genericMethod.typeVariables[n2].sourceName);
                    switch (i) {
                        case 0: {
                            stringBuffer.append("=");
                            break;
                        }
                        case 1: {
                            stringBuffer.append("<:");
                            break;
                        }
                        case 2: {
                            stringBuffer.append(">:");
                        }
                    }
                    if (typeBindingArray2[j] == null) continue;
                    stringBuffer.append(typeBindingArray2[j].shortReadableName());
                }
            }
        }
        stringBuffer.append("}]");
        stringBuffer.append("\n\t[inferred=");
        n2 = 0;
        int n6 = n = this.substitutes == null ? 0 : this.substitutes.length;
        for (n3 = 0; n3 < n; ++n3) {
            if (this.substitutes[n3] == null) continue;
            ++n2;
            stringBuffer.append('{').append(this.genericMethod.typeVariables[n3].sourceName);
            stringBuffer.append("=").append(this.substitutes[n3].shortReadableName()).append('}');
        }
        if (n2 == 0) {
            stringBuffer.append("{}");
        }
        stringBuffer.append(']');
        return stringBuffer.toString();
    }
}

