#ifndef _EFL_FLIPABLE_EO_H_
#define _EFL_FLIPABLE_EO_H_

#ifndef _EFL_FLIPABLE_EO_CLASS_TYPE
#define _EFL_FLIPABLE_EO_CLASS_TYPE

typedef Eo Efl_Flipable;

#endif

#ifndef _EFL_FLIPABLE_EO_TYPES
#define _EFL_FLIPABLE_EO_TYPES

/**
 * @brief Flip
 *
 * See also @ref Efl_Flipable
 *
 * @ingroup Efl
 */
typedef enum
{
  EFL_FLIP_NONE = 0, /** no flip */
  EFL_FLIP_HORIZONTAL = 1, /** flip image horizontally */
  EFL_FLIP_VERTICAL = 2 /** flip image vertically */
} Efl_Flip;


#endif
#define EFL_FLIPABLE_INTERFACE efl_flipable_interface_get()

EWAPI const Eo_Class *efl_flipable_interface_get(void);

/**
 * @brief Control the flip of the given image
 *
 * Use this function to change how your image is to be flipped: vertically or
 * horizontally or transpose or traverse
 *
 * @return Flip
 *
 * @ingroup Efl_Flipable
 */
EOAPI Efl_Flip efl_flip_get(const Eo *obj);

/**
 * @brief Control the flip of the given image
 *
 * Use this function to change how your image is to be flipped: vertically or
 * horizontally or transpose or traverse
 *
 * @param[in] flip Flip
 *
 * @ingroup Efl_Flipable
 */
EOAPI void efl_flip_set(Eo *obj, Efl_Flip flip);


#endif
