#ifndef _EFL_GFX_FILTER_EO_H_
#define _EFL_GFX_FILTER_EO_H_

#ifndef _EFL_GFX_FILTER_EO_CLASS_TYPE
#define _EFL_GFX_FILTER_EO_CLASS_TYPE

typedef Eo Efl_Gfx_Filter;

#endif

#ifndef _EFL_GFX_FILTER_EO_TYPES
#define _EFL_GFX_FILTER_EO_TYPES


#endif
/**
 * @brief Graphical filters can be applied to any object implementing this
 * interface.
 *
 * Filters are programmable effects that run whenever the object is rendered on
 * its canvas. The program language is Lua and a complete reference can be
 * found under "EFL Graphics Filters".
 *
 * This was a beta feature since 1.15.
 *
 * @since 1.18
 *
 * @ingroup Efl_Gfx_Filter
 */
#define EFL_GFX_FILTER_INTERFACE efl_gfx_filter_interface_get()

EWAPI const Eo_Class *efl_gfx_filter_interface_get(void);

/**
 * @brief Gets the code of the filter program set on this object. May be
 * @c null.
 *
 * @param[out] code The Lua program source code.
 * @param[out] name An optional name for this filter.
 *
 * @since 1.18
 *
 * @ingroup Efl_Gfx_Filter
 */
EOAPI void efl_gfx_filter_program_get(const Eo *obj, const char **code, const char **name);

/**
 * @brief Set a graphical filter program on this object.
 *
 * Valid for Text and Image objects at the moment.
 *
 * The argument passed to this function is a string containing a valid Lua
 * program based on the filters API as described in the "EFL Graphics Filters"
 * reference page.
 *
 * Set to @c null to disable filtering.
 *
 * @param[in] code The Lua program source code.
 * @param[in] name An optional name for this filter.
 *
 * @since 1.18
 *
 * @ingroup Efl_Gfx_Filter
 */
EOAPI void efl_gfx_filter_program_set(Eo *obj, const char *code, const char *name);

/**
 * @brief Set the current state of the filter.
 *
 * This should be used by Edje (EFL's internal layout engine), but could also
 * be used when implementing animations programmatically.
 *
 * A full state is defined by two states (name + value): origin state and
 * target state of an ongoing animation, as well as the @c pos progress (from 0
 * to 1) of that animation timeline. The second state can be omitted if there
 * is no ongoing animation.
 *
 * @param[out] cur_state
 * @param[out] cur_val
 * @param[out] next_state
 * @param[out] next_val
 * @param[out] pos
 *
 * @since 1.18
 *
 * @ingroup Efl_Gfx_Filter
 */
EOAPI void efl_gfx_filter_state_get(const Eo *obj, const char **cur_state, double *cur_val, const char **next_state, double *next_val, double *pos);

/**
 * @brief Set the current state of the filter.
 *
 * This should be used by Edje (EFL's internal layout engine), but could also
 * be used when implementing animations programmatically.
 *
 * A full state is defined by two states (name + value): origin state and
 * target state of an ongoing animation, as well as the @c pos progress (from 0
 * to 1) of that animation timeline. The second state can be omitted if there
 * is no ongoing animation.
 *
 * @param[in] cur_state
 * @param[in] cur_val
 * @param[in] next_state
 * @param[in] next_val
 * @param[in] pos
 *
 * @since 1.18
 *
 * @ingroup Efl_Gfx_Filter
 */
EOAPI void efl_gfx_filter_state_set(Eo *obj, const char *cur_state, double cur_val, const char *next_state, double next_val, double pos);

/**
 * @brief Required padding to apply this filter without cropping.
 *
 * Read-only property that can be used to calculate the object's final
 * geometry. This can be overriden (set) from inside the filter program by
 * using the function 'padding_set' in the Lua program.
 *
 * Gets the padding required to apply this filter.
 *
 * @param[out] l
 * @param[out] r
 * @param[out] t
 * @param[out] b
 *
 * @since 1.18
 *
 * @ingroup Efl_Gfx_Filter
 */
EOAPI void efl_gfx_filter_padding_get(const Eo *obj, int *l, int *r, int *t, int *b);

/**
 * @brief Bind an object to use as a mask or texture in a filter program.
 *
 * This will create automatically a new RGBA buffer containing the source
 * object's pixels (as it is rendered).
 *
 * @param[in] name Buffer name as used in the program.
 *
 * @return Object to use as a source of pixels.
 *
 * @since 1.18
 *
 * @ingroup Efl_Gfx_Filter
 */
EOAPI Efl_Gfx *efl_gfx_filter_source_get(const Eo *obj, const char * name);

/**
 * @brief Bind an object to use as a mask or texture in a filter program.
 *
 * This will create automatically a new RGBA buffer containing the source
 * object's pixels (as it is rendered).
 *
 * @param[in] name Buffer name as used in the program.
 * @param[in] source Object to use as a source of pixels.
 *
 * @since 1.18
 *
 * @ingroup Efl_Gfx_Filter
 */
EOAPI void efl_gfx_filter_source_set(Eo *obj, const char * name, Efl_Gfx *source);

/**
 * @brief Extra data used by the filter program.
 *
 * Each data element is a string ($value) stored as a global variable @c name.
 * The program is then responsible for conversion to numbers, tables, etc...
 *
 * If the @c execute flag is set, then the @c value can be complex and run, as
 * if the original Lua program contained a line 'name = value'. This can be
 * used to pass in tables.
 *
 * @param[in] name Name of the global variable
 * @param[out] value String value to use as data
 * @param[out] execute If @c true, execute 'name = value'
 *
 * @since 1.18
 *
 * @ingroup Efl_Gfx_Filter
 */
EOAPI void efl_gfx_filter_data_get(const Eo *obj, const char * name, const char **value, Eina_Bool *execute);

/**
 * @brief Extra data used by the filter program.
 *
 * Each data element is a string ($value) stored as a global variable @c name.
 * The program is then responsible for conversion to numbers, tables, etc...
 *
 * If the @c execute flag is set, then the @c value can be complex and run, as
 * if the original Lua program contained a line 'name = value'. This can be
 * used to pass in tables.
 *
 * @param[in] name Name of the global variable
 * @param[in] value String value to use as data
 * @param[in] execute If @c true, execute 'name = value'
 *
 * @since 1.18
 *
 * @ingroup Efl_Gfx_Filter
 */
EOAPI void efl_gfx_filter_data_set(Eo *obj, const char * name, const char *value, Eina_Bool execute);


#endif
