#ifndef EFL_GFX_SHAPE_EO_HH
#define EFL_GFX_SHAPE_EO_HH
#include <Eo.h>

extern "C" {
#include "efl_gfx_shape.eo.h"
#include "eo_base.eo.h"
}
#include <Eina.hh>
#include <Eo.hh>
#include "eo_base.eo.hh"
namespace efl { namespace gfx { 
struct Shape;
} } 
namespace efl { namespace eo { template<> struct is_eolian_object< ::efl::gfx::Shape> : ::std::true_type {}; } }

namespace eo_cxx {
namespace efl { namespace gfx { 
struct Shape {
   ::efl::eolian::return_traits<double>::type stroke_scale_get() const;
   ::efl::eolian::return_traits<void>::type stroke_scale_set( ::efl::eolian::in_traits<double>::type s) const;
   ::efl::eolian::return_traits<void>::type stroke_color_get( ::efl::eolian::out_traits<int>::type r,  ::efl::eolian::out_traits<int>::type g,  ::efl::eolian::out_traits<int>::type b,  ::efl::eolian::out_traits<int>::type a) const;
   ::efl::eolian::return_traits<void>::type stroke_color_set( ::efl::eolian::in_traits<int>::type r,  ::efl::eolian::in_traits<int>::type g,  ::efl::eolian::in_traits<int>::type b,  ::efl::eolian::in_traits<int>::type a) const;
   ::efl::eolian::return_traits<double>::type stroke_width_get() const;
   ::efl::eolian::return_traits<void>::type stroke_width_set( ::efl::eolian::in_traits<double>::type w) const;
   ::efl::eolian::return_traits<double>::type stroke_location_get() const;
   ::efl::eolian::return_traits<void>::type stroke_location_set( ::efl::eolian::in_traits<double>::type centered) const;
   ::efl::eolian::return_traits<Efl_Gfx_Cap>::type stroke_cap_get() const;
   ::efl::eolian::return_traits<void>::type stroke_cap_set( ::efl::eolian::in_traits<Efl_Gfx_Cap>::type c) const;
   ::efl::eolian::return_traits<Efl_Gfx_Join>::type stroke_join_get() const;
   ::efl::eolian::return_traits<void>::type stroke_join_set( ::efl::eolian::in_traits<Efl_Gfx_Join>::type j) const;
   ::efl::eolian::return_traits<Efl_Gfx_Fill_Rule>::type fill_rule_get() const;
   ::efl::eolian::return_traits<void>::type fill_rule_set( ::efl::eolian::in_traits<Efl_Gfx_Fill_Rule>::type fill_rule) const;
   ::efl::eolian::return_traits<void>::type path_length_get( ::efl::eolian::out_traits< unsigned int>::type commands,  ::efl::eolian::out_traits< unsigned int>::type points) const;
   ::efl::eolian::return_traits<void>::type current_get( ::efl::eolian::out_traits<double>::type x,  ::efl::eolian::out_traits<double>::type y) const;
   ::efl::eolian::return_traits<void>::type current_ctrl_get( ::efl::eolian::out_traits<double>::type x,  ::efl::eolian::out_traits<double>::type y) const;
   ::efl::eolian::return_traits<void>::type dup( ::efl::eolian::in_traits< ::eo::Base>::type dup_from) const;
   ::efl::eolian::return_traits<void>::type bounds_get( ::efl::eolian::out_traits<Eina_Rectangle>::type r) const;
   ::efl::eolian::return_traits<void>::type reset() const;
   ::efl::eolian::return_traits<void>::type append_move_to( ::efl::eolian::in_traits<double>::type x,  ::efl::eolian::in_traits<double>::type y) const;
   ::efl::eolian::return_traits<void>::type append_line_to( ::efl::eolian::in_traits<double>::type x,  ::efl::eolian::in_traits<double>::type y) const;
   ::efl::eolian::return_traits<void>::type append_quadratic_to( ::efl::eolian::in_traits<double>::type x,  ::efl::eolian::in_traits<double>::type y,  ::efl::eolian::in_traits<double>::type ctrl_x,  ::efl::eolian::in_traits<double>::type ctrl_y) const;
   ::efl::eolian::return_traits<void>::type append_squadratic_to( ::efl::eolian::in_traits<double>::type x,  ::efl::eolian::in_traits<double>::type y) const;
   ::efl::eolian::return_traits<void>::type append_cubic_to( ::efl::eolian::in_traits<double>::type ctrl_x0,  ::efl::eolian::in_traits<double>::type ctrl_y0,  ::efl::eolian::in_traits<double>::type ctrl_x1,  ::efl::eolian::in_traits<double>::type ctrl_y1,  ::efl::eolian::in_traits<double>::type x,  ::efl::eolian::in_traits<double>::type y) const;
   ::efl::eolian::return_traits<void>::type append_scubic_to( ::efl::eolian::in_traits<double>::type x,  ::efl::eolian::in_traits<double>::type y,  ::efl::eolian::in_traits<double>::type ctrl_x,  ::efl::eolian::in_traits<double>::type ctrl_y) const;
   ::efl::eolian::return_traits<void>::type append_arc_to( ::efl::eolian::in_traits<double>::type x,  ::efl::eolian::in_traits<double>::type y,  ::efl::eolian::in_traits<double>::type rx,  ::efl::eolian::in_traits<double>::type ry,  ::efl::eolian::in_traits<double>::type angle,  ::efl::eolian::in_traits<bool>::type large_arc,  ::efl::eolian::in_traits<bool>::type sweep) const;
   ::efl::eolian::return_traits<void>::type append_arc( ::efl::eolian::in_traits<double>::type x,  ::efl::eolian::in_traits<double>::type y,  ::efl::eolian::in_traits<double>::type w,  ::efl::eolian::in_traits<double>::type h,  ::efl::eolian::in_traits<double>::type start_angle,  ::efl::eolian::in_traits<double>::type sweep_length) const;
   ::efl::eolian::return_traits<void>::type append_close() const;
   ::efl::eolian::return_traits<void>::type append_circle( ::efl::eolian::in_traits<double>::type x,  ::efl::eolian::in_traits<double>::type y,  ::efl::eolian::in_traits<double>::type radius) const;
   ::efl::eolian::return_traits<void>::type append_rect( ::efl::eolian::in_traits<double>::type x,  ::efl::eolian::in_traits<double>::type y,  ::efl::eolian::in_traits<double>::type w,  ::efl::eolian::in_traits<double>::type h,  ::efl::eolian::in_traits<double>::type rx,  ::efl::eolian::in_traits<double>::type ry) const;
   ::efl::eolian::return_traits<void>::type append_svg_path( ::efl::eolian::in_traits< ::efl::eina::string_view>::type svg_path_data) const;
   ::efl::eolian::return_traits<bool>::type interpolate( ::efl::eolian::in_traits< ::eo::Base>::type from,  ::efl::eolian::in_traits< ::eo::Base>::type to,  ::efl::eolian::in_traits<double>::type pos_map) const;
   ::efl::eolian::return_traits<bool>::type equal_commands( ::efl::eolian::in_traits< ::eo::Base>::type with) const;
   static Eo_Class const* _eo_class()
   {
      return EFL_GFX_SHAPE_MIXIN;
   }
   Eo* _eo_ptr() const { return *(Eo**)this; }
   operator ::efl::gfx::Shape() const;
   operator ::efl::gfx::Shape&();
   operator ::efl::gfx::Shape const&() const;
   /// @cond LOCAL
    ::efl::eolian::address_of_operator<Shape> operator&() { return {this}; }
    ::efl::eolian::address_of_operator<Shape const > operator&() const { return {this}; }
   /// @endcond
};
} } 
}
namespace efl { namespace gfx { 
struct Shape : ::efl::eo::concrete
{
   explicit Shape( ::Eo* eo)
      : ::efl::eo::concrete(eo) {}
   explicit Shape(std::nullptr_t)
      : ::efl::eo::concrete(nullptr) {}
   Shape(Shape const& other) = default;
   Shape(Shape&& other) = default;
   Shape& operator=(Shape const& other) = default;
   Shape& operator=(Shape&& other) = default;
   Shape()
   {
      ::efl::eolian::do_eo_add( ::efl::eo::concrete::_eo_raw, ::efl::eo::concrete{nullptr}, _eo_class());
   }
   Shape( ::efl::eo::concrete parent)
   {
      ::efl::eolian::do_eo_add( ::efl::eo::concrete::_eo_raw, parent, _eo_class());
   }
   template <typename F> Shape(F f, typename ::std::enable_if< ::efl::eolian::is_callable<F>::value>::type* = 0)
   {
      ::efl::eolian::do_eo_add( ::efl::eo::concrete::_eo_raw, ::efl::eo::concrete{nullptr}, _eo_class(), f);
   }
   ::efl::eolian::return_traits<double>::type stroke_scale_get() const;
   ::efl::eolian::return_traits<void>::type stroke_scale_set( ::efl::eolian::in_traits<double>::type s) const;
   ::efl::eolian::return_traits<void>::type stroke_color_get( ::efl::eolian::out_traits<int>::type r,  ::efl::eolian::out_traits<int>::type g,  ::efl::eolian::out_traits<int>::type b,  ::efl::eolian::out_traits<int>::type a) const;
   ::efl::eolian::return_traits<void>::type stroke_color_set( ::efl::eolian::in_traits<int>::type r,  ::efl::eolian::in_traits<int>::type g,  ::efl::eolian::in_traits<int>::type b,  ::efl::eolian::in_traits<int>::type a) const;
   ::efl::eolian::return_traits<double>::type stroke_width_get() const;
   ::efl::eolian::return_traits<void>::type stroke_width_set( ::efl::eolian::in_traits<double>::type w) const;
   ::efl::eolian::return_traits<double>::type stroke_location_get() const;
   ::efl::eolian::return_traits<void>::type stroke_location_set( ::efl::eolian::in_traits<double>::type centered) const;
   ::efl::eolian::return_traits<Efl_Gfx_Cap>::type stroke_cap_get() const;
   ::efl::eolian::return_traits<void>::type stroke_cap_set( ::efl::eolian::in_traits<Efl_Gfx_Cap>::type c) const;
   ::efl::eolian::return_traits<Efl_Gfx_Join>::type stroke_join_get() const;
   ::efl::eolian::return_traits<void>::type stroke_join_set( ::efl::eolian::in_traits<Efl_Gfx_Join>::type j) const;
   ::efl::eolian::return_traits<Efl_Gfx_Fill_Rule>::type fill_rule_get() const;
   ::efl::eolian::return_traits<void>::type fill_rule_set( ::efl::eolian::in_traits<Efl_Gfx_Fill_Rule>::type fill_rule) const;
   ::efl::eolian::return_traits<void>::type path_length_get( ::efl::eolian::out_traits< unsigned int>::type commands,  ::efl::eolian::out_traits< unsigned int>::type points) const;
   ::efl::eolian::return_traits<void>::type current_get( ::efl::eolian::out_traits<double>::type x,  ::efl::eolian::out_traits<double>::type y) const;
   ::efl::eolian::return_traits<void>::type current_ctrl_get( ::efl::eolian::out_traits<double>::type x,  ::efl::eolian::out_traits<double>::type y) const;
   ::efl::eolian::return_traits<void>::type dup( ::efl::eolian::in_traits< ::eo::Base>::type dup_from) const;
   ::efl::eolian::return_traits<void>::type bounds_get( ::efl::eolian::out_traits<Eina_Rectangle>::type r) const;
   ::efl::eolian::return_traits<void>::type reset() const;
   ::efl::eolian::return_traits<void>::type append_move_to( ::efl::eolian::in_traits<double>::type x,  ::efl::eolian::in_traits<double>::type y) const;
   ::efl::eolian::return_traits<void>::type append_line_to( ::efl::eolian::in_traits<double>::type x,  ::efl::eolian::in_traits<double>::type y) const;
   ::efl::eolian::return_traits<void>::type append_quadratic_to( ::efl::eolian::in_traits<double>::type x,  ::efl::eolian::in_traits<double>::type y,  ::efl::eolian::in_traits<double>::type ctrl_x,  ::efl::eolian::in_traits<double>::type ctrl_y) const;
   ::efl::eolian::return_traits<void>::type append_squadratic_to( ::efl::eolian::in_traits<double>::type x,  ::efl::eolian::in_traits<double>::type y) const;
   ::efl::eolian::return_traits<void>::type append_cubic_to( ::efl::eolian::in_traits<double>::type ctrl_x0,  ::efl::eolian::in_traits<double>::type ctrl_y0,  ::efl::eolian::in_traits<double>::type ctrl_x1,  ::efl::eolian::in_traits<double>::type ctrl_y1,  ::efl::eolian::in_traits<double>::type x,  ::efl::eolian::in_traits<double>::type y) const;
   ::efl::eolian::return_traits<void>::type append_scubic_to( ::efl::eolian::in_traits<double>::type x,  ::efl::eolian::in_traits<double>::type y,  ::efl::eolian::in_traits<double>::type ctrl_x,  ::efl::eolian::in_traits<double>::type ctrl_y) const;
   ::efl::eolian::return_traits<void>::type append_arc_to( ::efl::eolian::in_traits<double>::type x,  ::efl::eolian::in_traits<double>::type y,  ::efl::eolian::in_traits<double>::type rx,  ::efl::eolian::in_traits<double>::type ry,  ::efl::eolian::in_traits<double>::type angle,  ::efl::eolian::in_traits<bool>::type large_arc,  ::efl::eolian::in_traits<bool>::type sweep) const;
   ::efl::eolian::return_traits<void>::type append_arc( ::efl::eolian::in_traits<double>::type x,  ::efl::eolian::in_traits<double>::type y,  ::efl::eolian::in_traits<double>::type w,  ::efl::eolian::in_traits<double>::type h,  ::efl::eolian::in_traits<double>::type start_angle,  ::efl::eolian::in_traits<double>::type sweep_length) const;
   ::efl::eolian::return_traits<void>::type append_close() const;
   ::efl::eolian::return_traits<void>::type append_circle( ::efl::eolian::in_traits<double>::type x,  ::efl::eolian::in_traits<double>::type y,  ::efl::eolian::in_traits<double>::type radius) const;
   ::efl::eolian::return_traits<void>::type append_rect( ::efl::eolian::in_traits<double>::type x,  ::efl::eolian::in_traits<double>::type y,  ::efl::eolian::in_traits<double>::type w,  ::efl::eolian::in_traits<double>::type h,  ::efl::eolian::in_traits<double>::type rx,  ::efl::eolian::in_traits<double>::type ry) const;
   ::efl::eolian::return_traits<void>::type append_svg_path( ::efl::eolian::in_traits< ::efl::eina::string_view>::type svg_path_data) const;
   ::efl::eolian::return_traits<bool>::type interpolate( ::efl::eolian::in_traits< ::eo::Base>::type from,  ::efl::eolian::in_traits< ::eo::Base>::type to,  ::efl::eolian::in_traits<double>::type pos_map) const;
   ::efl::eolian::return_traits<bool>::type equal_commands( ::efl::eolian::in_traits< ::eo::Base>::type with) const;
   static Eo_Class const* _eo_class()
   {
      return EFL_GFX_SHAPE_MIXIN;
   }
   Eo* _eo_ptr() const { return *(Eo**)this; }
   /// @cond LOCAL
    ::efl::eolian::address_of_operator<Shape> operator&() { return {this}; }
    ::efl::eolian::address_of_operator<Shape const > operator&() const { return {this}; }
   /// @endcond
};
static_assert(sizeof(Shape) == sizeof(Eo*), "");
static_assert(std::is_standard_layout<Shape>::value, "");
} } 
#include "efl_gfx_shape.eo.impl.hh"
#endif
