#ifndef _EIO_SENTRY_EO_H_
#define _EIO_SENTRY_EO_H_

#ifndef _EIO_SENTRY_EO_CLASS_TYPE
#define _EIO_SENTRY_EO_CLASS_TYPE

typedef Eo Eio_Sentry;

#endif

#ifndef _EIO_SENTRY_EO_TYPES
#define _EIO_SENTRY_EO_TYPES

/** Wraps the data about a monitor event on a file.
 *
 * @ingroup Eio_Sentry
 */
typedef struct _Eio_Sentry_Event
{
  const char *trigger; /** The cause of the event. */
  const char *source; /** The original monitored path. */
} Eio_Sentry_Event;


#endif
/** Monitors files and directories for changes.
 *
 * @ingroup Eio_Sentry
 */
#define EIO_SENTRY_CLASS eio_sentry_class_get()

EWAPI const Eo_Class *eio_sentry_class_get(void);

/**
 * @brief Adds a new path to the list of monitored paths.
 *
 * @param[in] path
 *
 * @ingroup Eio_Sentry
 */
EOAPI Eina_Bool eio_sentry_add(Eo *obj, const char *path);

/**
 * @brief Removes the given path from the monitored list.
 *
 * @param[in] path
 *
 * @ingroup Eio_Sentry
 */
EOAPI void eio_sentry_del(Eo *obj, const char *path);

EOAPI extern const Eo_Event_Description _EIO_SENTRY_EVENT_FILE_CREATED;
EOAPI extern const Eo_Event_Description _EIO_SENTRY_EVENT_FILE_DELETED;
EOAPI extern const Eo_Event_Description _EIO_SENTRY_EVENT_FILE_MODIFIED;
EOAPI extern const Eo_Event_Description _EIO_SENTRY_EVENT_FILE_CLOSED;
EOAPI extern const Eo_Event_Description _EIO_SENTRY_EVENT_DIRECTORY_CREATED;
EOAPI extern const Eo_Event_Description _EIO_SENTRY_EVENT_DIRECTORY_DELETED;
EOAPI extern const Eo_Event_Description _EIO_SENTRY_EVENT_DIRECTORY_MODIFIED;
EOAPI extern const Eo_Event_Description _EIO_SENTRY_EVENT_DIRECTORY_CLOSED;
EOAPI extern const Eo_Event_Description _EIO_SENTRY_EVENT_SELF_RENAME;
EOAPI extern const Eo_Event_Description _EIO_SENTRY_EVENT_SELF_DELETED;
EOAPI extern const Eo_Event_Description _EIO_SENTRY_EVENT_ERROR;

/**
 * No description
 */
#define EIO_SENTRY_EVENT_FILE_CREATED (&(_EIO_SENTRY_EVENT_FILE_CREATED))

/**
 * No description
 */
#define EIO_SENTRY_EVENT_FILE_DELETED (&(_EIO_SENTRY_EVENT_FILE_DELETED))

/**
 * No description
 */
#define EIO_SENTRY_EVENT_FILE_MODIFIED (&(_EIO_SENTRY_EVENT_FILE_MODIFIED))

/**
 * No description
 */
#define EIO_SENTRY_EVENT_FILE_CLOSED (&(_EIO_SENTRY_EVENT_FILE_CLOSED))

/**
 * No description
 */
#define EIO_SENTRY_EVENT_DIRECTORY_CREATED (&(_EIO_SENTRY_EVENT_DIRECTORY_CREATED))

/**
 * No description
 */
#define EIO_SENTRY_EVENT_DIRECTORY_DELETED (&(_EIO_SENTRY_EVENT_DIRECTORY_DELETED))

/**
 * No description
 */
#define EIO_SENTRY_EVENT_DIRECTORY_MODIFIED (&(_EIO_SENTRY_EVENT_DIRECTORY_MODIFIED))

/**
 * No description
 */
#define EIO_SENTRY_EVENT_DIRECTORY_CLOSED (&(_EIO_SENTRY_EVENT_DIRECTORY_CLOSED))

/**
 * No description
 */
#define EIO_SENTRY_EVENT_SELF_RENAME (&(_EIO_SENTRY_EVENT_SELF_RENAME))

/**
 * No description
 */
#define EIO_SENTRY_EVENT_SELF_DELETED (&(_EIO_SENTRY_EVENT_SELF_DELETED))

/**
 * No description
 */
#define EIO_SENTRY_EVENT_ERROR (&(_EIO_SENTRY_EVENT_ERROR))

#endif
