/****************************************************************************
** Shared Class code from reading file 'KReportElement.shared.h'
**
** Created
**      by: The Shared Data Compiler version 0.2
**
** WARNING! All changes made in this file will be lost!
*****************************************************************************/

/* This file is part of the KDE project
 * Copyright (C) 2001-2007 by OpenMFG, LLC (info@openmfg.com)
 * Copyright (C) 2007-2008 by Adam Pigg (adam@piggz.co.uk)
 * Copyright (C) 2010-2015 Jarosław Staniek <staniek@kde.org>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library.  If not, see <http://www.gnu.org/licenses/>.
 */

#ifndef KREPORTELEMENT_H
#define KREPORTELEMENT_H

#include "kreport_export.h"

#include <QColor>
#include <QRectF>
#include <QSharedData>

class QDebug;

//! @brief The KReportElement class represents a functional visual element of a report design
/*! @note objects of this class are explicitly shared, what means they behave like regular
          C++ pointers, except that by doing reference counting and not deleting the shared
          data object until the reference count is 0, they avoid the dangling pointer problem.
          See <a href="http://doc.qt.io/qt-5/qexplicitlyshareddatapointer.html#details">Qt documentation</a>.
 */
//! @note This class has been generated using the following SDC class options: explicit, operator==, virtual_dtor
class KREPORT_EXPORT KReportElement
{
public:





    //! @internal data class used to implement explicitly shared class KReportElement.
    //! Provides thread-safe reference counting.
    class Data : public QSharedData
    {
    public:
        Data()
        : z(0)
        , backgroundOpacity(0.0)
        {
        }

        Data(const Data &other)
         : QSharedData(other)
         , name(other.name)
         , rect(other.rect)
         , z(other.z)
         , foregroundColor(other.foregroundColor)
         , backgroundColor(other.backgroundColor)
         , backgroundOpacity(other.backgroundOpacity)
        {
        }

        virtual ~Data() {}

        //! Clones the object with all attributes; the copy isn't shared with the original.
        virtual Data* clone() const { return new Data(*this); }

        QString name; //!< @see KReportElement::name(), KReportElement::setName()
        QRectF rect; //!< @see KReportElement::rect(), KReportElement::setRect()
        qreal z; //!< @see KReportElement::z(), KReportElement::setZ()
        QColor foregroundColor; //!< @see KReportElement::foregroundColor(), KReportElement::setForegroundColor()
        QColor backgroundColor; //!< @see KReportElement::backgroundColor(), KReportElement::setBackgroundColor()
        qreal backgroundOpacity; //!< @see KReportElement::backgroundOpacity(), KReportElement::setBackgroundOpacity()
    };

    KReportElement()
     : d(new Data)
    {
    }

    KReportElement(const KReportElement &other)
     : d(other.d)
    {
    }

    virtual ~KReportElement();

    /*!
    @return element's name.
    */
    QString name() const {
        return d->name;
    }

    /*!
    Sets the element's name to @a name.
    */
    void setName(const QString & name) {
        d->name = name;
    }

    /*!
    @return element's rectangle.
    */
    QRectF rect() const {
        return d->rect;
    }

    /*!
    Sets the element's rectangle to @a rect.
    */
    void setRect(const QRectF & rect) {
        d->rect = rect;
    }

    /*!
    @return element's Z-value.
    The Z value decides the stacking order of sibling (neighboring) elements.
    A sibling element of high Z value will always be drawn on top of another sibling
    element with a lower Z value.
    If you restore the Z value, the element's insertion order will decide its stacking order.
    The Z-value does not affect the element's size in any way.
    The default Z-value is 0.
    */
    qreal z() const {
        return d->z;
    }

    /*!
    Sets the element's Z-value to @a z.
    */
    void setZ(qreal z) {
        d->z = z;
    }

    /*!
    @return element's foreground color.
    The default foreground color is invalid what means 'unspecified'.
    */
    QColor foregroundColor() const {
        return d->foregroundColor;
    }

    /*!
    Sets the element's foreground color to @a foregroundColor.
    */
    void setForegroundColor(const QColor & foregroundColor) {
        d->foregroundColor = foregroundColor;
    }

    /*!
    @return element's background color.
    The default background color is invalid what means 'unspecified'.
    */
    QColor backgroundColor() const {
        return d->backgroundColor;
    }

    /*!
    Sets the element's background color to @a backgroundColor.
    */
    void setBackgroundColor(const QColor & backgroundColor) {
        d->backgroundColor = backgroundColor;
    }

    /*!
    @return element's background opacity, which is between 0.0 (transparent) and 1.0 (opaque).
    The default opacity is 0.0.
    */
    qreal backgroundOpacity() const {
        return d->backgroundOpacity;
    }

    /*!
    Sets the element's background opacity to @a backgroundOpacity.
    */
    void setBackgroundOpacity(qreal backgroundOpacity);

    //! @return true if this object is equal to @a other; otherwise returns false.
    bool operator==(const KReportElement &other) const {
        return d == other.d;
    }

    //! @return true if this object is not equal to @a other; otherwise returns false.
    bool operator!=(const KReportElement &other) const {
        return !operator==(other);
    }

    //! Clones the object with all attributes; the copy isn't shared with the original.
    virtual KReportElement clone() const {
        return KReportElement(d->clone());
    }


protected:
    KReportElement(Data *data)
     : d(data)
    {
    }

    KReportElement(QExplicitlySharedDataPointer<KReportElement::Data> &data)
     : d(data)
    {
    }

    QExplicitlySharedDataPointer<Data> d;
};

template<>
KREPORT_EXPORT KReportElement::Data *QSharedDataPointer<KReportElement::Data>::clone();

//! Sends information about the element @a element to debug output @a dbg.
KREPORT_EXPORT QDebug operator<<(QDebug dbg, const KReportElement& element);

KREPORT_EXPORT uint qHash(const KReportElement &element, uint seed = 0) Q_DECL_NOTHROW;

#endif // KREPORTELEMENT_H
