/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core.network.proxy.fallback;

import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.core.network.proxy.NetworkProxyResolver;
import org.netbeans.core.network.proxy.NetworkProxySettings;
import org.openide.util.NbBundle;

public class FallbackNetworkProxy
implements NetworkProxyResolver {
    private static final Logger LOGGER = Logger.getLogger(FallbackNetworkProxy.class.getName());
    private static final String AT = "@";
    private static final String COMMA = ",";
    private static final String SLASH = "/";
    private static final String PROTOCOL_PREXIF_SEPARATOR = "://";
    private static final String EMPTY_STRING = "";
    private static final String HTTP_PROXY_SYS_PROPERTY = "http_proxy";
    private static final String HTTPS_PROXY_SYS_PROPERTY = "https_proxy";
    private static final String SOCKS_PROXY_SYS_PROPERTY = "socks_proxy";
    private static final String NO_PROXY_SYS_PROPERTY = "no_proxy";
    private static final String DEFAULT_NO_PROXY_HOSTS = NbBundle.getMessage(FallbackNetworkProxy.class, (String)"DefaulNoProxyHosts");

    @Override
    public NetworkProxySettings getNetworkProxySettings() {
        LOGGER.log(Level.FINE, "Fallback system proxy resolver started.");
        String string = System.getenv(HTTP_PROXY_SYS_PROPERTY);
        if (string != null && !string.isEmpty()) {
            String[] stringArray;
            String string2 = System.getenv(HTTPS_PROXY_SYS_PROPERTY);
            String string3 = System.getenv(SOCKS_PROXY_SYS_PROPERTY);
            String string4 = System.getenv(NO_PROXY_SYS_PROPERTY);
            LOGGER.log(Level.INFO, "Fallback system proxy resolver: http_proxy={0}", string);
            LOGGER.log(Level.INFO, "Fallback system proxy resolver: https_proxy={0}", string2);
            LOGGER.log(Level.INFO, "Fallback system proxy resolver: socks_proxy={0}", string3);
            LOGGER.log(Level.INFO, "Fallback system proxy resolver: no_proxy={0}", string4);
            String string5 = this.prepareVariable(string);
            String string6 = this.prepareVariable(string2);
            String string7 = this.prepareVariable(string3);
            if (string4 == null) {
                stringArray = DEFAULT_NO_PROXY_HOSTS.split(COMMA);
                LOGGER.log(Level.INFO, "Fallback system proxy resolver: no proxy set to default");
            } else {
                stringArray = string4.split(COMMA);
            }
            return new NetworkProxySettings(string5, string6, string7, stringArray);
        }
        LOGGER.log(Level.INFO, "Fallback system proxy resolver: no http_proxy variable found");
        return new NetworkProxySettings();
    }

    private String prepareVariable(String string) {
        if (string == null) {
            return EMPTY_STRING;
        }
        if (string.endsWith(SLASH)) {
            string = string.substring(0, string.length() - 1);
        }
        if (string.contains(AT)) {
            string = string.substring(string.lastIndexOf(AT) + 1);
        }
        if (string.contains(PROTOCOL_PREXIF_SEPARATOR)) {
            string = string.substring(string.indexOf(PROTOCOL_PREXIF_SEPARATOR) + 3);
        }
        return string;
    }
}

