/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.spi.search.impl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import org.netbeans.api.search.SearchRoot;
import org.netbeans.api.search.SearchScopeOptions;
import org.netbeans.api.search.provider.SearchInfo;
import org.netbeans.api.search.provider.SearchInfoUtils;
import org.netbeans.api.search.provider.SearchListener;
import org.netbeans.api.search.provider.impl.AbstractCompoundIterator;
import org.netbeans.spi.search.SearchInfoDefinition;
import org.netbeans.spi.search.impl.SearchInfoDefinitionUtils;
import org.netbeans.spi.search.impl.SimpleSearchInfoDefinition;
import org.openide.filesystems.FileObject;
import org.openide.nodes.Children;
import org.openide.nodes.Node;

public final class SubnodesSearchInfoDefinition
extends SearchInfoDefinition {
    private final Children children;

    public SubnodesSearchInfoDefinition(Children children) {
        this.children = children;
    }

    @Override
    public boolean canSearch() {
        return true;
    }

    @Override
    public Iterator<FileObject> filesToSearch(SearchScopeOptions searchScopeOptions, SearchListener searchListener, AtomicBoolean atomicBoolean) {
        int n;
        Node[] nodeArray = this.children.getNodes(true);
        if (nodeArray.length == 0) {
            return SimpleSearchInfoDefinition.EMPTY_SEARCH_INFO.filesToSearch(searchScopeOptions, searchListener, atomicBoolean);
        }
        ArrayList<SearchInfo> arrayList = new ArrayList<SearchInfo>(nodeArray.length);
        for (n = 0; n < nodeArray.length; ++n) {
            Node node = nodeArray[n];
            SearchInfo searchInfo = SearchInfoUtils.getSearchInfoForNode(node);
            if (searchInfo == null || !searchInfo.canSearch()) continue;
            arrayList.add(searchInfo);
        }
        n = arrayList.size();
        switch (n) {
            case 0: {
                return Collections.emptyList().iterator();
            }
            case 1: {
                return ((SearchInfo)arrayList.get(0)).getFilesToSearch(searchScopeOptions, searchListener, atomicBoolean).iterator();
            }
        }
        return new AbstractCompoundIterator<SearchInfo, FileObject>(arrayList.toArray(new SearchInfo[n]), searchScopeOptions, searchListener, atomicBoolean){

            @Override
            protected Iterator<FileObject> getIteratorFor(SearchInfo searchInfo, SearchScopeOptions searchScopeOptions, SearchListener searchListener, AtomicBoolean atomicBoolean) {
                return searchInfo.getFilesToSearch(searchScopeOptions, searchListener, atomicBoolean).iterator();
            }
        };
    }

    @Override
    public List<SearchRoot> getSearchRoots() {
        Node[] nodeArray = this.children.getNodes(true);
        if (nodeArray.length == 0) {
            return Collections.emptyList();
        }
        LinkedList<SearchRoot> linkedList = new LinkedList<SearchRoot>();
        for (Node node : nodeArray) {
            SearchInfoDefinition searchInfoDefinition = SearchInfoDefinitionUtils.getSearchInfoDefinition(node);
            if (searchInfoDefinition == null || !searchInfoDefinition.canSearch()) continue;
            linkedList.addAll(searchInfoDefinition.getSearchRoots());
        }
        return linkedList;
    }
}

