/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.mapper;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.Weight;
import org.elasticsearch.ElasticsearchGenerationException;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.compress.CompressedXContent;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.text.Text;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentType;
import org.elasticsearch.index.IndexSettings;
import org.elasticsearch.index.analysis.IndexAnalyzers;
import org.elasticsearch.index.mapper.AllFieldMapper;
import org.elasticsearch.index.mapper.ContentPath;
import org.elasticsearch.index.mapper.DocumentFieldMappers;
import org.elasticsearch.index.mapper.DocumentParser;
import org.elasticsearch.index.mapper.FieldMapper;
import org.elasticsearch.index.mapper.IdFieldMapper;
import org.elasticsearch.index.mapper.IndexFieldMapper;
import org.elasticsearch.index.mapper.MappedFieldType;
import org.elasticsearch.index.mapper.Mapper;
import org.elasticsearch.index.mapper.MapperParsingException;
import org.elasticsearch.index.mapper.MapperService;
import org.elasticsearch.index.mapper.MapperUtils;
import org.elasticsearch.index.mapper.Mapping;
import org.elasticsearch.index.mapper.MetadataFieldMapper;
import org.elasticsearch.index.mapper.ObjectMapper;
import org.elasticsearch.index.mapper.ParentFieldMapper;
import org.elasticsearch.index.mapper.ParsedDocument;
import org.elasticsearch.index.mapper.RootObjectMapper;
import org.elasticsearch.index.mapper.RoutingFieldMapper;
import org.elasticsearch.index.mapper.SourceFieldMapper;
import org.elasticsearch.index.mapper.SourceToParse;
import org.elasticsearch.index.mapper.TTLFieldMapper;
import org.elasticsearch.index.mapper.TimestampFieldMapper;
import org.elasticsearch.index.mapper.TypeFieldMapper;
import org.elasticsearch.index.mapper.UidFieldMapper;
import org.elasticsearch.search.internal.SearchContext;

public class DocumentMapper
implements ToXContent {
    private final MapperService mapperService;
    private final String type;
    private final Text typeText;
    private final CompressedXContent mappingSource;
    private final Mapping mapping;
    private final DocumentParser documentParser;
    private final DocumentFieldMappers fieldMappers;
    private final Map<String, ObjectMapper> objectMappers;
    private final boolean hasNestedObjects;

    public DocumentMapper(MapperService mapperService, Mapping mapping) {
        this.mapperService = mapperService;
        this.type = mapping.root().name();
        this.typeText = new Text(this.type);
        IndexSettings indexSettings = mapperService.getIndexSettings();
        this.mapping = mapping;
        this.documentParser = new DocumentParser(indexSettings, mapperService.documentMapperParser(), this);
        if (this.metadataMapper(ParentFieldMapper.class).active()) {
            this.metadataMapper(RoutingFieldMapper.class).markAsRequired();
        }
        ArrayList<ObjectMapper> newObjectMappers = new ArrayList<ObjectMapper>();
        ArrayList<FieldMapper> newFieldMappers = new ArrayList<FieldMapper>();
        for (MetadataFieldMapper metadataFieldMapper : this.mapping.metadataMappers) {
            if (!(metadataFieldMapper instanceof FieldMapper)) continue;
            newFieldMappers.add(metadataFieldMapper);
        }
        MapperUtils.collect(this.mapping.root, newObjectMappers, newFieldMappers);
        IndexAnalyzers indexAnalyzers = mapperService.getIndexAnalyzers();
        this.fieldMappers = new DocumentFieldMappers(newFieldMappers, (Analyzer)indexAnalyzers.getDefaultIndexAnalyzer(), (Analyzer)indexAnalyzers.getDefaultSearchAnalyzer(), (Analyzer)indexAnalyzers.getDefaultSearchQuoteAnalyzer());
        HashMap<String, ObjectMapper> builder = new HashMap<String, ObjectMapper>();
        for (ObjectMapper objectMapper : newObjectMappers) {
            ObjectMapper previous = builder.put(objectMapper.fullPath(), objectMapper);
            if (previous == null) continue;
            throw new IllegalStateException("duplicate key " + objectMapper.fullPath() + " encountered");
        }
        boolean hasNestedObjects = false;
        this.objectMappers = Collections.unmodifiableMap(builder);
        for (ObjectMapper objectMapper : newObjectMappers) {
            if (!objectMapper.nested().isNested()) continue;
            hasNestedObjects = true;
        }
        this.hasNestedObjects = hasNestedObjects;
        try {
            this.mappingSource = new CompressedXContent(this, XContentType.JSON, ToXContent.EMPTY_PARAMS);
        }
        catch (Exception exception) {
            throw new ElasticsearchGenerationException("failed to serialize source for type [" + this.type + "]", exception);
        }
    }

    public Mapping mapping() {
        return this.mapping;
    }

    public String type() {
        return this.type;
    }

    public Text typeText() {
        return this.typeText;
    }

    public Map<String, Object> meta() {
        return this.mapping.meta;
    }

    public CompressedXContent mappingSource() {
        return this.mappingSource;
    }

    public RootObjectMapper root() {
        return this.mapping.root;
    }

    public UidFieldMapper uidMapper() {
        return this.metadataMapper(UidFieldMapper.class);
    }

    public <T extends MetadataFieldMapper> T metadataMapper(Class<T> type) {
        return this.mapping.metadataMapper(type);
    }

    public IndexFieldMapper indexMapper() {
        return this.metadataMapper(IndexFieldMapper.class);
    }

    public TypeFieldMapper typeMapper() {
        return this.metadataMapper(TypeFieldMapper.class);
    }

    public SourceFieldMapper sourceMapper() {
        return this.metadataMapper(SourceFieldMapper.class);
    }

    public AllFieldMapper allFieldMapper() {
        return this.metadataMapper(AllFieldMapper.class);
    }

    public IdFieldMapper idFieldMapper() {
        return this.metadataMapper(IdFieldMapper.class);
    }

    public RoutingFieldMapper routingFieldMapper() {
        return this.metadataMapper(RoutingFieldMapper.class);
    }

    public ParentFieldMapper parentFieldMapper() {
        return this.metadataMapper(ParentFieldMapper.class);
    }

    public TimestampFieldMapper timestampFieldMapper() {
        return this.metadataMapper(TimestampFieldMapper.class);
    }

    public TTLFieldMapper TTLFieldMapper() {
        return this.metadataMapper(TTLFieldMapper.class);
    }

    public IndexFieldMapper IndexFieldMapper() {
        return this.metadataMapper(IndexFieldMapper.class);
    }

    public Query typeFilter() {
        return this.typeMapper().fieldType().termQuery(this.type, null);
    }

    public boolean hasNestedObjects() {
        return this.hasNestedObjects;
    }

    public DocumentFieldMappers mappers() {
        return this.fieldMappers;
    }

    public Map<String, ObjectMapper> objectMappers() {
        return this.objectMappers;
    }

    public ParsedDocument parse(String index, String type, String id, BytesReference source) throws MapperParsingException {
        return this.parse(SourceToParse.source(index, type, id, source, XContentType.JSON));
    }

    public ParsedDocument parse(SourceToParse source) throws MapperParsingException {
        return this.documentParser.parseDocument(source);
    }

    public ObjectMapper findNestedObjectMapper(int nestedDocId, SearchContext sc, LeafReaderContext context) throws IOException {
        ObjectMapper nestedObjectMapper = null;
        for (ObjectMapper objectMapper : this.objectMappers().values()) {
            Weight nestedWeight;
            Scorer scorer;
            Query filter;
            if (!objectMapper.nested().isNested() || (filter = objectMapper.nestedTypeFilter()) == null || (scorer = (nestedWeight = filter.createWeight((IndexSearcher)sc.searcher(), false)).scorer(context)) == null || scorer.iterator().advance(nestedDocId) != nestedDocId) continue;
            if (nestedObjectMapper == null) {
                nestedObjectMapper = objectMapper;
                continue;
            }
            if (nestedObjectMapper.fullPath().length() >= objectMapper.fullPath().length()) continue;
            nestedObjectMapper = objectMapper;
        }
        return nestedObjectMapper;
    }

    public ObjectMapper findParentObjectMapper(ObjectMapper objectMapper) {
        int indexOfLastDot = objectMapper.fullPath().lastIndexOf(46);
        if (indexOfLastDot != -1) {
            String parentNestObjectPath = objectMapper.fullPath().substring(0, indexOfLastDot);
            return this.objectMappers().get(parentNestObjectPath);
        }
        return null;
    }

    public boolean isParent(String type) {
        return this.mapperService.getParentTypes().contains(type);
    }

    public DocumentMapper merge(Mapping mapping, boolean updateAllTypes) {
        Mapping merged = this.mapping.merge(mapping, updateAllTypes);
        return new DocumentMapper(this.mapperService, merged);
    }

    public DocumentMapper updateFieldType(Map<String, MappedFieldType> fullNameToFieldType) {
        Mapping updated = this.mapping.updateFieldType(fullNameToFieldType);
        if (updated == this.mapping) {
            return this;
        }
        assert (updated == updated.updateFieldType(fullNameToFieldType)) : "updateFieldType operation is not idempotent";
        return new DocumentMapper(this.mapperService, updated);
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        return this.mapping.toXContent(builder, params);
    }

    public static class Builder {
        private Map<Class<? extends MetadataFieldMapper>, MetadataFieldMapper> metadataMappers = new LinkedHashMap<Class<? extends MetadataFieldMapper>, MetadataFieldMapper>();
        private final RootObjectMapper rootObjectMapper;
        private Map<String, Object> meta = Collections.emptyMap();
        private final Mapper.BuilderContext builderContext;

        public Builder(RootObjectMapper.Builder builder, MapperService mapperService) {
            Settings indexSettings = mapperService.getIndexSettings().getSettings();
            this.builderContext = new Mapper.BuilderContext(indexSettings, new ContentPath(1));
            this.rootObjectMapper = (RootObjectMapper)builder.build(this.builderContext);
            String type = this.rootObjectMapper.name();
            DocumentMapper existingMapper = mapperService.documentMapper(type);
            for (Map.Entry<String, MetadataFieldMapper.TypeParser> entry : mapperService.mapperRegistry.getMetadataMapperParsers().entrySet()) {
                MetadataFieldMapper metadataMapper;
                MetadataFieldMapper existingMetadataMapper;
                String name = entry.getKey();
                MetadataFieldMapper metadataFieldMapper = existingMetadataMapper = existingMapper == null ? null : (MetadataFieldMapper)existingMapper.mappers().getMapper(name);
                if (existingMetadataMapper == null) {
                    MetadataFieldMapper.TypeParser parser = entry.getValue();
                    metadataMapper = parser.getDefault(mapperService.fullName(name), mapperService.documentMapperParser().parserContext(builder.name()));
                } else {
                    metadataMapper = existingMetadataMapper;
                }
                this.metadataMappers.put(metadataMapper.getClass(), metadataMapper);
            }
        }

        public Builder meta(Map<String, Object> meta) {
            this.meta = meta;
            return this;
        }

        public Builder put(MetadataFieldMapper.Builder<?, ?> mapper) {
            MetadataFieldMapper metadataMapper = (MetadataFieldMapper)mapper.build(this.builderContext);
            this.metadataMappers.put(metadataMapper.getClass(), metadataMapper);
            return this;
        }

        public DocumentMapper build(MapperService mapperService) {
            Objects.requireNonNull(this.rootObjectMapper, "Mapper builder must have the root object mapper set");
            Mapping mapping = new Mapping(mapperService.getIndexSettings().getIndexVersionCreated(), this.rootObjectMapper, this.metadataMappers.values().toArray(new MetadataFieldMapper[this.metadataMappers.values().size()]), this.meta);
            return new DocumentMapper(mapperService, mapping);
        }
    }
}

