/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Streamable;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.common.xcontent.XContentParserUtils;
import org.elasticsearch.search.SearchHit;
import org.elasticsearch.search.SearchShardTarget;

public class SearchHits
implements Streamable,
ToXContent,
Iterable<SearchHit> {
    public static final SearchHit[] EMPTY = new SearchHit[0];
    private SearchHit[] hits;
    public long totalHits;
    private float maxScore;

    public static SearchHits empty() {
        return new SearchHits(EMPTY, 0L, 0.0f);
    }

    SearchHits() {
    }

    public SearchHits(SearchHit[] hits, long totalHits, float maxScore) {
        this.hits = hits;
        this.totalHits = totalHits;
        this.maxScore = maxScore;
    }

    public void shardTarget(SearchShardTarget shardTarget) {
        for (SearchHit hit : this.hits) {
            hit.shard(shardTarget);
        }
    }

    @Deprecated
    public long totalHits() {
        return this.totalHits;
    }

    public long getTotalHits() {
        return this.totalHits();
    }

    @Deprecated
    public float maxScore() {
        return this.maxScore;
    }

    public float getMaxScore() {
        return this.maxScore();
    }

    @Deprecated
    public SearchHit[] hits() {
        return this.hits;
    }

    public SearchHit getAt(int position) {
        return this.hits[position];
    }

    public SearchHit[] getHits() {
        return this.hits();
    }

    @Override
    public Iterator<SearchHit> iterator() {
        return Arrays.stream(this.hits()).iterator();
    }

    public SearchHit[] internalHits() {
        return this.hits;
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject("hits");
        builder.field("total", this.totalHits);
        if (Float.isNaN(this.maxScore)) {
            builder.nullField("max_score");
        } else {
            builder.field("max_score", this.maxScore);
        }
        builder.field("hits");
        builder.startArray();
        for (SearchHit hit : this.hits) {
            hit.toXContent(builder, params);
        }
        builder.endArray();
        builder.endObject();
        return builder;
    }

    public static SearchHits fromXContent(XContentParser parser) throws IOException {
        if (parser.currentToken() != XContentParser.Token.START_OBJECT) {
            parser.nextToken();
            XContentParserUtils.ensureExpectedToken(XContentParser.Token.START_OBJECT, parser.currentToken(), parser::getTokenLocation);
        }
        XContentParser.Token token = parser.currentToken();
        String currentFieldName = null;
        ArrayList<SearchHit> hits = new ArrayList<SearchHit>();
        long totalHits = 0L;
        float maxScore = 0.0f;
        while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
            if (token == XContentParser.Token.FIELD_NAME) {
                currentFieldName = parser.currentName();
                continue;
            }
            if (token.isValue()) {
                if ("total".equals(currentFieldName)) {
                    totalHits = parser.longValue();
                    continue;
                }
                if ("max_score".equals(currentFieldName)) {
                    maxScore = parser.floatValue();
                    continue;
                }
                XContentParserUtils.throwUnknownField(currentFieldName, parser.getTokenLocation());
                continue;
            }
            if (token == XContentParser.Token.VALUE_NULL) {
                if ("max_score".equals(currentFieldName)) {
                    maxScore = Float.NaN;
                    continue;
                }
                XContentParserUtils.throwUnknownField(currentFieldName, parser.getTokenLocation());
                continue;
            }
            if (token != XContentParser.Token.START_ARRAY) continue;
            while ((token = parser.nextToken()) != XContentParser.Token.END_ARRAY) {
                hits.add(SearchHit.fromXContent(parser));
            }
        }
        SearchHits searchHits = new SearchHits(hits.toArray(new SearchHit[hits.size()]), totalHits, maxScore);
        return searchHits;
    }

    public static SearchHits readSearchHits(StreamInput in) throws IOException {
        SearchHits hits = new SearchHits();
        hits.readFrom(in);
        return hits;
    }

    @Override
    public void readFrom(StreamInput in) throws IOException {
        this.totalHits = in.readVLong();
        this.maxScore = in.readFloat();
        int size = in.readVInt();
        if (size == 0) {
            this.hits = EMPTY;
        } else {
            this.hits = new SearchHit[size];
            for (int i = 0; i < this.hits.length; ++i) {
                this.hits[i] = SearchHit.readSearchHit(in);
            }
        }
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeVLong(this.totalHits);
        out.writeFloat(this.maxScore);
        out.writeVInt(this.hits.length);
        if (this.hits.length > 0) {
            for (SearchHit hit : this.hits) {
                hit.writeTo(out);
            }
        }
    }

    static final class Fields {
        static final String HITS = "hits";
        static final String TOTAL = "total";
        static final String MAX_SCORE = "max_score";

        Fields() {
        }
    }
}

