/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.reindex.remote;

import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.apache.http.ContentTooLongException;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.entity.ContentType;
import org.apache.http.util.EntityUtils;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.message.ParameterizedMessage;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.ElasticsearchStatusException;
import org.elasticsearch.Version;
import org.elasticsearch.action.bulk.BackoffPolicy;
import org.elasticsearch.action.bulk.byscroll.ScrollableHitSource;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.client.Response;
import org.elasticsearch.client.ResponseException;
import org.elasticsearch.client.ResponseListener;
import org.elasticsearch.client.RestClient;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.ParsingException;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.common.util.concurrent.AbstractRunnable;
import org.elasticsearch.common.util.concurrent.ThreadContext;
import org.elasticsearch.common.xcontent.NamedXContentRegistry;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.common.xcontent.XContentType;
import org.elasticsearch.index.reindex.remote.RemoteRequestBuilders;
import org.elasticsearch.index.reindex.remote.RemoteResponseParsers;
import org.elasticsearch.rest.RestStatus;
import org.elasticsearch.threadpool.ThreadPool;

public class RemoteScrollableHitSource
extends ScrollableHitSource {
    private final RestClient client;
    private final BytesReference query;
    private final SearchRequest searchRequest;
    Version remoteVersion;

    public RemoteScrollableHitSource(Logger logger, BackoffPolicy backoffPolicy, ThreadPool threadPool, Runnable countSearchRetry, Consumer<Exception> fail, RestClient client, BytesReference query, SearchRequest searchRequest) {
        super(logger, backoffPolicy, threadPool, countSearchRetry, fail);
        this.query = query;
        this.searchRequest = searchRequest;
        this.client = client;
    }

    protected void doStart(Consumer<? super ScrollableHitSource.Response> onResponse) {
        this.lookupRemoteVersion(version -> {
            this.remoteVersion = version;
            this.execute("POST", RemoteRequestBuilders.initialSearchPath(this.searchRequest), RemoteRequestBuilders.initialSearchParams(this.searchRequest, version), RemoteRequestBuilders.initialSearchEntity(this.searchRequest, this.query, this.remoteVersion), (BiFunction)RemoteResponseParsers.RESPONSE_PARSER, (Consumer)r -> this.onStartResponse(onResponse, (ScrollableHitSource.Response)r));
        });
    }

    void lookupRemoteVersion(Consumer<Version> onVersion) {
        this.execute("GET", "", Collections.emptyMap(), null, (BiFunction)RemoteResponseParsers.MAIN_ACTION_PARSER, (Consumer)onVersion);
    }

    private void onStartResponse(Consumer<? super ScrollableHitSource.Response> onResponse, ScrollableHitSource.Response response) {
        if (Strings.hasLength((String)response.getScrollId()) && response.getHits().isEmpty()) {
            this.logger.debug("First response looks like a scan response. Jumping right to the second. scroll=[{}]", (Object)response.getScrollId());
            this.doStartNextScroll(response.getScrollId(), TimeValue.timeValueMillis((long)0L), onResponse);
        } else {
            onResponse.accept((ScrollableHitSource.Response)response);
        }
    }

    protected void doStartNextScroll(String scrollId, TimeValue extraKeepAlive, Consumer<? super ScrollableHitSource.Response> onResponse) {
        Map<String, String> scrollParams = RemoteRequestBuilders.scrollParams(TimeValue.timeValueNanos((long)(this.searchRequest.scroll().keepAlive().nanos() + extraKeepAlive.nanos())), this.remoteVersion);
        this.execute("POST", RemoteRequestBuilders.scrollPath(), scrollParams, RemoteRequestBuilders.scrollEntity(scrollId, this.remoteVersion), (BiFunction)RemoteResponseParsers.RESPONSE_PARSER, (Consumer)onResponse);
    }

    protected void clearScroll(final String scrollId, final Runnable onCompletion) {
        this.client.performRequestAsync("DELETE", RemoteRequestBuilders.scrollPath(), Collections.emptyMap(), RemoteRequestBuilders.clearScrollEntity(scrollId, this.remoteVersion), new ResponseListener(){

            public void onSuccess(Response response) {
                RemoteScrollableHitSource.this.logger.debug("Successfully cleared [{}]", (Object)scrollId);
                onCompletion.run();
            }

            public void onFailure(Exception e) {
                this.logFailure(e);
                onCompletion.run();
            }

            private void logFailure(Exception e) {
                if (e instanceof ResponseException) {
                    ResponseException re = (ResponseException)e;
                    if (RemoteScrollableHitSource.this.remoteVersion.before(Version.V_2_0_0) && re.getResponse().getStatusLine().getStatusCode() == 404) {
                        RemoteScrollableHitSource.this.logger.debug(() -> new ParameterizedMessage("Failed to clear scroll [{}] from pre-2.0 Elasticsearch. This is normal if the request terminated normally as the scroll has already been cleared automatically.", (Object)scrollId), (Throwable)e);
                        return;
                    }
                }
                RemoteScrollableHitSource.this.logger.warn(() -> new ParameterizedMessage("Failed to clear scroll [{}]", (Object)scrollId), (Throwable)e);
            }
        }, new Header[0]);
    }

    protected void cleanup(Runnable onCompletion) {
        this.threadPool.generic().submit(() -> {
            try {
                this.client.close();
                this.logger.debug("Shut down remote connection");
            }
            catch (IOException e) {
                this.logger.error("Failed to shutdown the remote connection", (Throwable)e);
            }
            finally {
                onCompletion.run();
            }
        });
    }

    private <T> void execute(final String method, final String uri, final Map<String, String> params, final HttpEntity entity, final BiFunction<XContentParser, XContentType, T> parser, final Consumer<? super T> listener) {
        final Supplier contextSupplier = this.threadPool.getThreadContext().newRestorableContext(true);
        class RetryHelper
        extends AbstractRunnable {
            private final Iterator<TimeValue> retries;

            RetryHelper() {
                this.retries = RemoteScrollableHitSource.this.backoffPolicy.iterator();
            }

            protected void doRun() throws Exception {
                RemoteScrollableHitSource.this.client.performRequestAsync(method, uri, params, entity, new ResponseListener(){

                    public void onSuccess(Response response) {
                        try (ThreadContext.StoredContext ctx = (ThreadContext.StoredContext)contextSupplier.get();){
                            Object parsedResponse;
                            assert (ctx != null);
                            try {
                                HttpEntity responseEntity = response.getEntity();
                                InputStream content = responseEntity.getContent();
                                XContentType xContentType = null;
                                if (responseEntity.getContentType() != null) {
                                    String mimeType = ContentType.parse((String)responseEntity.getContentType().getValue()).getMimeType();
                                    xContentType = XContentType.fromMediaType((String)mimeType);
                                }
                                if (xContentType == null) {
                                    try {
                                        throw new ElasticsearchException("Response didn't include Content-Type: " + RemoteScrollableHitSource.bodyMessage(response.getEntity()), new Object[0]);
                                    }
                                    catch (IOException e) {
                                        ElasticsearchException ee = new ElasticsearchException("Error extracting body from response", new Object[0]);
                                        ee.addSuppressed((Throwable)e);
                                        throw ee;
                                    }
                                }
                                try (XContentParser xContentParser = xContentType.xContent().createParser(NamedXContentRegistry.EMPTY, content);){
                                    parsedResponse = parser.apply(xContentParser, xContentType);
                                }
                                catch (ParsingException e) {
                                    throw new ElasticsearchException("Error parsing the response, remote is likely not an Elasticsearch instance", (Throwable)e, new Object[0]);
                                }
                            }
                            catch (IOException e) {
                                throw new ElasticsearchException("Error deserializing response, remote is likely not an Elasticsearch instance", (Throwable)e, new Object[0]);
                            }
                            listener.accept(parsedResponse);
                        }
                    }

                    public void onFailure(Exception e) {
                        try (ThreadContext.StoredContext ctx = (ThreadContext.StoredContext)contextSupplier.get();){
                            assert (ctx != null);
                            if (e instanceof ResponseException) {
                                ResponseException re = (ResponseException)e;
                                if (RestStatus.TOO_MANY_REQUESTS.getStatus() == re.getResponse().getStatusLine().getStatusCode() && retries.hasNext()) {
                                    TimeValue delay = (TimeValue)retries.next();
                                    RemoteScrollableHitSource.this.logger.trace(() -> new ParameterizedMessage("retrying rejected search after [{}]", (Object)delay), (Throwable)e);
                                    RemoteScrollableHitSource.this.countSearchRetry.run();
                                    RemoteScrollableHitSource.this.threadPool.schedule(delay, "same", (Runnable)((Object)this));
                                    return;
                                }
                                e = RemoteScrollableHitSource.wrapExceptionToPreserveStatus(re.getResponse().getStatusLine().getStatusCode(), re.getResponse().getEntity(), (Exception)re);
                            } else if (e instanceof ContentTooLongException) {
                                e = new IllegalArgumentException("Remote responded with a chunk that was too large. Use a smaller batch size.", e);
                            }
                            RemoteScrollableHitSource.this.fail.accept(e);
                        }
                    }
                }, new Header[0]);
            }

            public void onFailure(Exception t) {
                RemoteScrollableHitSource.this.fail.accept(t);
            }
        }
        new RetryHelper().run();
    }

    static ElasticsearchStatusException wrapExceptionToPreserveStatus(int statusCode, @Nullable HttpEntity entity, Exception cause) {
        RestStatus status = RestStatus.fromCode((int)statusCode);
        String messagePrefix = "";
        if (status == null) {
            messagePrefix = "Couldn't extract status [" + statusCode + "]. ";
            status = RestStatus.INTERNAL_SERVER_ERROR;
        }
        try {
            return new ElasticsearchStatusException(messagePrefix + RemoteScrollableHitSource.bodyMessage(entity), status, (Throwable)cause, new Object[0]);
        }
        catch (IOException ioe) {
            ElasticsearchStatusException e = new ElasticsearchStatusException(messagePrefix + "Failed to extract body.", status, (Throwable)cause, new Object[0]);
            e.addSuppressed((Throwable)ioe);
            return e;
        }
    }

    static String bodyMessage(@Nullable HttpEntity entity) throws IOException {
        if (entity == null) {
            return "No error body.";
        }
        return "body=" + EntityUtils.toString((HttpEntity)entity);
    }
}

