/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.markdown.parser.markerblocks.providers;

import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.intellij.markdown.parser.LookaheadText;
import org.intellij.markdown.parser.MarkerProcessor;
import org.intellij.markdown.parser.ProductionHolder;
import org.intellij.markdown.parser.constraints.MarkdownConstraints;
import org.intellij.markdown.parser.markerblocks.MarkerBlock;
import org.intellij.markdown.parser.markerblocks.MarkerBlockProvider;
import org.intellij.markdown.parser.markerblocks.impl.HtmlBlockMarkerBlock;
import org.intellij.markdown.parser.markerblocks.providers.HtmlBlockProvider;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 6}, bv={1, 0, 1}, k=1, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\u0018\u0000 \u00132\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u0013B\u0005\u00a2\u0006\u0002\u0010\u0003J*\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\n\u0010\u0007\u001a\u00060\bR\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u0002H\u0016J\u001c\u0010\r\u001a\u00020\u000e2\n\u0010\u0007\u001a\u00060\bR\u00020\t2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\u001c\u0010\u0011\u001a\u00020\u00122\n\u0010\u0007\u001a\u00060\bR\u00020\t2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002"}, d2={"Lorg/intellij/markdown/parser/markerblocks/providers/HtmlBlockProvider;", "Lorg/intellij/markdown/parser/markerblocks/MarkerBlockProvider;", "Lorg/intellij/markdown/parser/MarkerProcessor$StateInfo;", "()V", "createMarkerBlocks", "", "Lorg/intellij/markdown/parser/markerblocks/MarkerBlock;", "pos", "Lorg/intellij/markdown/parser/LookaheadText$Position;", "Lorg/intellij/markdown/parser/LookaheadText;", "productionHolder", "Lorg/intellij/markdown/parser/ProductionHolder;", "stateInfo", "interruptsParagraph", "", "constraints", "Lorg/intellij/markdown/parser/constraints/MarkdownConstraints;", "matches", "", "Companion"})
public final class HtmlBlockProvider
implements MarkerBlockProvider<MarkerProcessor.StateInfo> {
    @NotNull
    private static final String TAG_NAMES = "address, article, aside, base, basefont, blockquote, body, caption, center, col, colgroup, dd, details, dialog, dir, div, dl, dt, fieldset, figcaption, figure, footer, form, frame, frameset, h1, head, header, hr, html, legend, li, link, main, menu, menuitem, meta, nav, noframes, ol, optgroup, option, p, param, pre, section, source, title, summary, table, tbody, td, tfoot, th, thead, title, tr, track, ul";
    @NotNull
    private static final String TAG_NAME = "[a-zA-Z][a-zA-Z0-9-]*";
    @NotNull
    private static final String ATTR_NAME = "[A-Za-z:_][A-Za-z0-9_.:-]*";
    @NotNull
    private static final String ATTR_VALUE = "\\s*=\\s*(?:[^ \"'=<>`]+|'[^']*'|\"[^\"]*\")";
    @NotNull
    private static final String ATTRIBUTE = "\\s+[A-Za-z:_][A-Za-z0-9_.:-]*(?:\\s*=\\s*(?:[^ \"'=<>`]+|'[^']*'|\"[^\"]*\"))?";
    @NotNull
    private static final String OPEN_TAG = "<[a-zA-Z][a-zA-Z0-9-]*(?:\\s+[A-Za-z:_][A-Za-z0-9_.:-]*(?:\\s*=\\s*(?:[^ \"'=<>`]+|'[^']*'|\"[^\"]*\"))?)*\\s*/?>";
    @NotNull
    private static final String CLOSE_TAG = "</[a-zA-Z][a-zA-Z0-9-]*\\s*>";
    @NotNull
    private static final List<Pair<Regex, Regex>> OPEN_CLOSE_REGEXES;
    @NotNull
    private static final Regex FIND_START_REGEX;
    public static final Companion Companion;

    @Override
    @NotNull
    public List<MarkerBlock> createMarkerBlocks(@NotNull LookaheadText.Position pos, @NotNull ProductionHolder productionHolder, @NotNull MarkerProcessor.StateInfo stateInfo) {
        Intrinsics.checkParameterIsNotNull((Object)pos, (String)"pos");
        Intrinsics.checkParameterIsNotNull((Object)productionHolder, (String)"productionHolder");
        Intrinsics.checkParameterIsNotNull((Object)stateInfo, (String)"stateInfo");
        int matchingGroup = this.matches(pos, stateInfo.getCurrentConstraints());
        if (matchingGroup != -1) {
            return CollectionsKt.listOf((Object)new HtmlBlockMarkerBlock(stateInfo.getCurrentConstraints(), productionHolder, (Regex)Companion.getOPEN_CLOSE_REGEXES().get(matchingGroup).getSecond(), pos));
        }
        return CollectionsKt.emptyList();
    }

    @Override
    public boolean interruptsParagraph(@NotNull LookaheadText.Position pos, @NotNull MarkdownConstraints constraints) {
        Intrinsics.checkParameterIsNotNull((Object)pos, (String)"pos");
        Intrinsics.checkParameterIsNotNull((Object)constraints, (String)"constraints");
        int n = this.matches(pos, constraints);
        return 0 <= n && n <= 5;
    }

    /*
     * WARNING - void declaration
     */
    private final int matches(LookaheadText.Position pos, MarkdownConstraints constraints) {
        int n;
        if (!MarkerBlockProvider.Companion.isStartOfLineWithConstraints(pos, constraints)) {
            return -1;
        }
        MatchResult matchResult = Regex.find$default((Regex)Companion.getFIND_START_REGEX(), (CharSequence)pos.getCurrentLineFromPosition(), (int)0, (int)2, null);
        if (matchResult == null) {
            return -1;
        }
        MatchResult matchResult2 = matchResult;
        int n2 = n = matchResult2.getGroups().size() == Companion.getOPEN_CLOSE_REGEXES().size() + 1 ? 1 : 0;
        if (_Assertions.ENABLED && n == 0) {
            String string = "There are some excess capturing groups probably!";
            throw (Throwable)((Object)new AssertionError((Object)string));
        }
        n = 1;
        int $i$a$1$assert = Companion.getOPEN_CLOSE_REGEXES().size();
        if (n <= $i$a$1$assert) {
            while (true) {
                void i;
                if (matchResult2.getGroups().get((int)i) != null) {
                    return (int)(i - true);
                }
                if (i == $i$a$1$assert) break;
                ++i;
            }
        }
        n = 0;
        if (_Assertions.ENABLED && n == 0) {
            String string = "Match found but all groups are empty!";
            throw (Throwable)((Object)new AssertionError((Object)string));
        }
        return -1;
    }

    static {
        Companion = new Companion(null);
        TAG_NAMES = TAG_NAMES;
        TAG_NAME = TAG_NAME;
        ATTR_NAME = ATTR_NAME;
        ATTR_VALUE = ATTR_VALUE;
        ATTRIBUTE = "\\" + "s+" + Companion.getATTR_NAME() + "(?:" + Companion.getATTR_VALUE() + ")?";
        OPEN_TAG = "<" + Companion.getTAG_NAME() + "(?:" + Companion.getATTRIBUTE() + ")*" + "\\" + "s*/?>";
        CLOSE_TAG = "</" + Companion.getTAG_NAME() + "\\" + "s*>";
        OPEN_CLOSE_REGEXES = CollectionsKt.listOf((Object[])new Pair[]{new Pair((Object)new Regex("<(?i:script|pre|style)(?: |>|$)"), (Object)new Regex("</(?i:script|style|pre)>")), new Pair((Object)new Regex("<!--"), (Object)new Regex("-->")), new Pair((Object)new Regex("<\\?"), (Object)new Regex("\\?>")), new Pair((Object)new Regex("<![A-Z]"), (Object)new Regex(">")), new Pair((Object)new Regex("<!\\[CDATA\\["), (Object)new Regex("\\]\\]>")), new Pair((Object)new Regex("</?(?i:" + StringsKt.replace$default((String)Companion.getTAG_NAMES(), (String)", ", (String)"|", (boolean)false, (int)4, null) + ")(?: |/?>|" + "$" + ")"), null), new Pair((Object)new Regex("(?:" + Companion.getOPEN_TAG() + "|" + Companion.getCLOSE_TAG() + ")(?: |" + "$" + ")"), null)});
        FIND_START_REGEX = new Regex(CollectionsKt.joinToString$default((Iterable)Companion.getOPEN_CLOSE_REGEXES(), (CharSequence)"|", null, null, (int)0, null, (Function1)Companion.FIND_START_REGEX.1.INSTANCE, (int)30, null));
    }

    @Metadata(mv={1, 1, 6}, bv={1, 0, 1}, k=1, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\b\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0014\u0010\u0003\u001a\u00020\u0004X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0014\u0010\u0007\u001a\u00020\u0004X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0006R\u0014\u0010\t\u001a\u00020\u0004X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u0006R\u0014\u0010\u000b\u001a\u00020\u0004X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\u0006R\u0011\u0010\r\u001a\u00020\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R%\u0010\u0011\u001a\u0016\u0012\u0012\u0012\u0010\u0012\u0004\u0012\u00020\u000e\u0012\u0006\u0012\u0004\u0018\u00010\u000e0\u00130\u0012\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u0014\u0010\u0016\u001a\u00020\u0004X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0006R\u0014\u0010\u0018\u001a\u00020\u0004X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u0006R\u0014\u0010\u001a\u001a\u00020\u0004X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u0006"}, d2={"Lorg/intellij/markdown/parser/markerblocks/providers/HtmlBlockProvider$Companion;", "", "()V", "ATTRIBUTE", "", "getATTRIBUTE", "()Ljava/lang/String;", "ATTR_NAME", "getATTR_NAME", "ATTR_VALUE", "getATTR_VALUE", "CLOSE_TAG", "getCLOSE_TAG", "FIND_START_REGEX", "Lkotlin/text/Regex;", "getFIND_START_REGEX", "()Lkotlin/text/Regex;", "OPEN_CLOSE_REGEXES", "", "Lkotlin/Pair;", "getOPEN_CLOSE_REGEXES", "()Ljava/util/List;", "OPEN_TAG", "getOPEN_TAG", "TAG_NAME", "getTAG_NAME", "TAG_NAMES", "getTAG_NAMES"})
    public static final class Companion {
        @NotNull
        public final String getTAG_NAMES() {
            return TAG_NAMES;
        }

        @NotNull
        public final String getTAG_NAME() {
            return TAG_NAME;
        }

        @NotNull
        public final String getATTR_NAME() {
            return ATTR_NAME;
        }

        @NotNull
        public final String getATTR_VALUE() {
            return ATTR_VALUE;
        }

        @NotNull
        public final String getATTRIBUTE() {
            return ATTRIBUTE;
        }

        @NotNull
        public final String getOPEN_TAG() {
            return OPEN_TAG;
        }

        @NotNull
        public final String getCLOSE_TAG() {
            return CLOSE_TAG;
        }

        @NotNull
        public final List<Pair<Regex, Regex>> getOPEN_CLOSE_REGEXES() {
            return OPEN_CLOSE_REGEXES;
        }

        @NotNull
        public final Regex getFIND_START_REGEX() {
            return FIND_START_REGEX;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

