/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.annotator;

import com.intellij.codeInsight.daemon.impl.HighlightInfo;
import com.intellij.openapi.project.Project;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.codeInspection.bugs.GrAccessibilityChecker;
import org.jetbrains.plugins.groovy.lang.psi.GroovyFileBase;
import org.jetbrains.plugins.groovy.lang.psi.GroovyRecursiveElementVisitor;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrReferenceExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.types.GrCodeReferenceElement;

public class InaccessibleElementVisitor
extends GroovyRecursiveElementVisitor {
    private final GrAccessibilityChecker myReferenceChecker;
    private final List<HighlightInfo> myInfos;

    public InaccessibleElementVisitor(GroovyFileBase file, Project project, List<HighlightInfo> collector) {
        this.myReferenceChecker = new GrAccessibilityChecker(file, project);
        this.myInfos = collector;
    }

    @Override
    public void visitReferenceExpression(@NotNull GrReferenceExpression referenceExpression) {
        HighlightInfo info;
        if (referenceExpression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "referenceExpression", "org/jetbrains/plugins/groovy/annotator/InaccessibleElementVisitor", "visitReferenceExpression"));
        }
        int size = this.myInfos.size();
        super.visitReferenceExpression(referenceExpression);
        if (size == this.myInfos.size() && (info = this.myReferenceChecker.checkReferenceExpression(referenceExpression)) != null) {
            this.myInfos.add(info);
        }
    }

    @Override
    public void visitCodeReferenceElement(@NotNull GrCodeReferenceElement refElement) {
        HighlightInfo info;
        if (refElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "refElement", "org/jetbrains/plugins/groovy/annotator/InaccessibleElementVisitor", "visitCodeReferenceElement"));
        }
        int size = this.myInfos.size();
        super.visitCodeReferenceElement(refElement);
        if (size == this.myInfos.size() && (info = this.myReferenceChecker.checkCodeReferenceElement(refElement)) != null) {
            this.myInfos.add(info);
        }
    }
}

