/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.annotator.intentions;

import com.intellij.codeInsight.FileModificationService;
import com.intellij.codeInsight.hint.HintManager;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.lang.Language;
import com.intellij.openapi.application.AccessToken;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JVMElementFactories;
import com.intellij.psi.JVMElementFactory;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassOwner;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.PsiType;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.annotator.intentions.CreateClassActionBase;
import org.jetbrains.plugins.groovy.intentions.GroovyIntentionsBundle;
import org.jetbrains.plugins.groovy.intentions.base.IntentionUtils;
import org.jetbrains.plugins.groovy.lang.GrCreateClassKind;
import org.jetbrains.plugins.groovy.lang.psi.GrReferenceElement;
import org.jetbrains.plugins.groovy.lang.psi.GroovyFile;
import org.jetbrains.plugins.groovy.lang.psi.GroovyFileBase;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElementFactory;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrNewExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrReferenceExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.GrTypeDefinition;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrMethod;
import org.jetbrains.plugins.groovy.lang.psi.api.types.GrCodeReferenceElement;
import org.jetbrains.plugins.groovy.lang.psi.expectedTypes.SupertypeConstraint;
import org.jetbrains.plugins.groovy.lang.psi.expectedTypes.TypeConstraint;
import org.jetbrains.plugins.groovy.lang.psi.impl.statements.expressions.TypesUtil;
import org.jetbrains.plugins.groovy.lang.psi.util.PsiUtil;
import org.jetbrains.plugins.groovy.template.expressions.ChooseTypeExpression;

public abstract class CreateClassFix {
    public static IntentionAction createClassFromNewAction(GrNewExpression expression) {
        return new CreateClassActionBase(GrCreateClassKind.CLASS, expression.getReferenceElement()){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            protected void processIntention(@NotNull PsiElement element, @NotNull Project project, Editor editor) throws IncorrectOperationException {
                Module module;
                String name;
                String qualifier;
                if (element == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/plugins/groovy/annotator/intentions/CreateClassFix$1", "processIntention"));
                }
                if (project == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/plugins/groovy/annotator/intentions/CreateClassFix$1", "processIntention"));
                }
                PsiFile file = element.getContainingFile();
                if (!(file instanceof GroovyFileBase)) {
                    return;
                }
                GroovyFileBase groovyFile = (GroovyFileBase)file;
                PsiManager manager = this.myRefElement.getManager();
                AccessToken accessToken = ReadAction.start();
                try {
                    qualifier = groovyFile instanceof GroovyFile ? groovyFile.getPackageName() : "";
                    name = this.myRefElement.getReferenceName();
                    assert (name != null);
                    module = ModuleUtilCore.findModuleForPsiElement((PsiElement)file);
                }
                finally {
                    accessToken.finish();
                }
                PsiDirectory targetDirectory = this.getTargetDirectory(project, qualifier, name, module, this.getText());
                if (targetDirectory == null) {
                    return;
                }
                GrTypeDefinition targetClass = 1.createClassByType(targetDirectory, name, manager, this.myRefElement, "Groovy Class.groovy", true);
                if (targetClass == null) {
                    return;
                }
                PsiType[] argTypes = CreateClassFix.getArgTypes(this.myRefElement);
                if (argTypes != null && argTypes.length > 0) {
                    CreateClassFix.generateConstructor(this.myRefElement, name, argTypes, targetClass, project);
                    CreateClassFix.bindRef(targetClass, this.myRefElement);
                } else {
                    CreateClassFix.bindRef(targetClass, this.myRefElement);
                    IntentionUtils.positionCursor(project, targetClass.getContainingFile(), targetClass);
                }
            }
        };
    }

    @Nullable
    private static PsiType[] getArgTypes(GrReferenceElement refElement) {
        AccessToken accessToken = ReadAction.start();
        try {
            PsiType[] psiTypeArray = PsiUtil.getArgumentTypes(refElement, false);
            return psiTypeArray;
        }
        finally {
            accessToken.finish();
        }
    }

    private static void generateConstructor(@NotNull PsiElement refElement, @NotNull String name, @NotNull PsiType[] argTypes, @NotNull GrTypeDefinition targetClass, @NotNull Project project) {
        if (refElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "refElement", "org/jetbrains/plugins/groovy/annotator/intentions/CreateClassFix", "generateConstructor"));
        }
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "org/jetbrains/plugins/groovy/annotator/intentions/CreateClassFix", "generateConstructor"));
        }
        if (argTypes == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "argTypes", "org/jetbrains/plugins/groovy/annotator/intentions/CreateClassFix", "generateConstructor"));
        }
        if (targetClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "targetClass", "org/jetbrains/plugins/groovy/annotator/intentions/CreateClassFix", "generateConstructor"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/plugins/groovy/annotator/intentions/CreateClassFix", "generateConstructor"));
        }
        WriteAction.run(() -> {
            if (argTypes == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "argTypes", "org/jetbrains/plugins/groovy/annotator/intentions/CreateClassFix", "lambda$generateConstructor$0"));
            }
            if (refElement == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "refElement", "org/jetbrains/plugins/groovy/annotator/intentions/CreateClassFix", "lambda$generateConstructor$0"));
            }
            if (targetClass == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "targetClass", "org/jetbrains/plugins/groovy/annotator/intentions/CreateClassFix", "lambda$generateConstructor$0"));
            }
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/plugins/groovy/annotator/intentions/CreateClassFix", "lambda$generateConstructor$0"));
            }
            if (name == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "org/jetbrains/plugins/groovy/annotator/intentions/CreateClassFix", "lambda$generateConstructor$0"));
            }
            ChooseTypeExpression[] paramTypesExpressions = new ChooseTypeExpression[argTypes.length];
            String[] paramTypes = new String[argTypes.length];
            String[] paramNames = new String[argTypes.length];
            for (int i = 0; i < argTypes.length; ++i) {
                PsiType argType = argTypes[i];
                if (argType == null) {
                    argType = TypesUtil.getJavaLangObject(refElement);
                }
                paramTypes[i] = "Object";
                paramNames[i] = "o" + i;
                TypeConstraint[] constraints = new TypeConstraint[]{SupertypeConstraint.create(argType)};
                paramTypesExpressions[i] = new ChooseTypeExpression(constraints, refElement.getManager(), targetClass.getResolveScope());
            }
            GrMethod method = GroovyPsiElementFactory.getInstance(project).createConstructorFromText(name, paramTypes, paramNames, "{\n}");
            method = (GrMethod)targetClass.addBefore(method, null);
            PsiElement context = PsiTreeUtil.getParentOfType((PsiElement)refElement, (Class[])new Class[]{PsiMethod.class, PsiClass.class, PsiFile.class});
            IntentionUtils.createTemplateForMethod(argTypes, paramTypesExpressions, method, targetClass, TypeConstraint.EMPTY_ARRAY, true, context);
        });
    }

    public static IntentionAction createClassFixAction(GrReferenceElement refElement, GrCreateClassKind type) {
        return new CreateClassActionBase(type, refElement){

            @Override
            protected void processIntention(@NotNull PsiElement element, @NotNull Project project, Editor editor) throws IncorrectOperationException {
                if (element == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/plugins/groovy/annotator/intentions/CreateClassFix$2", "processIntention"));
                }
                if (project == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/plugins/groovy/annotator/intentions/CreateClassFix$2", "processIntention"));
                }
                PsiFile file = element.getContainingFile();
                if (!(file instanceof GroovyFileBase)) {
                    return;
                }
                GroovyFileBase groovyFile = (GroovyFileBase)file;
                PsiElement qualifier = this.myRefElement.getQualifier();
                if (qualifier == null || qualifier instanceof GrReferenceElement && ((GrReferenceElement)qualifier).resolve() instanceof PsiPackage) {
                    this.createTopLevelClass(project, groovyFile);
                } else {
                    this.createInnerClass(project, editor, qualifier);
                }
            }

            private void createInnerClass(Project project, Editor editor, PsiElement qualifier) {
                PsiElement resolved = this.resolveQualifier(qualifier);
                if (!(resolved instanceof PsiClass)) {
                    return;
                }
                JVMElementFactory factory = JVMElementFactories.getFactory((Language)resolved.getLanguage(), (Project)project);
                if (factory == null) {
                    return;
                }
                String name = this.myRefElement.getReferenceName();
                PsiClass template = this.createTemplate(factory, name);
                if (template == null) {
                    ApplicationManager.getApplication().invokeLater(() -> {
                        if (editor != null && editor.getComponent().isDisplayable()) {
                            HintManager.getInstance().showErrorHint(editor, GroovyIntentionsBundle.message("cannot.create.class", new Object[0]));
                        }
                    });
                    return;
                }
                if (!FileModificationService.getInstance().preparePsiElementForWrite(resolved)) {
                    return;
                }
                WriteAction.run(() -> {
                    PsiClass added = (PsiClass)resolved.add((PsiElement)template);
                    PsiModifierList modifierList = added.getModifierList();
                    if (modifierList != null) {
                        modifierList.setModifierProperty("static", true);
                    }
                    IntentionUtils.positionCursor(project, added.getContainingFile(), (PsiElement)added);
                });
            }

            @Nullable
            private PsiElement resolveQualifier(@NotNull PsiElement qualifier) {
                if (qualifier == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "qualifier", "org/jetbrains/plugins/groovy/annotator/intentions/CreateClassFix$2", "resolveQualifier"));
                }
                if (qualifier instanceof GrCodeReferenceElement) {
                    return ((GrCodeReferenceElement)qualifier).resolve();
                }
                if (qualifier instanceof GrExpression) {
                    PsiElement resolved;
                    PsiType type = ((GrExpression)qualifier).getType();
                    if (type instanceof PsiClassType) {
                        return ((PsiClassType)type).resolve();
                    }
                    if (qualifier instanceof GrReferenceExpression && ((resolved = ((GrReferenceExpression)qualifier).resolve()) instanceof PsiClass || resolved instanceof PsiPackage)) {
                        return resolved;
                    }
                }
                return null;
            }

            @Nullable
            private PsiClass createTemplate(JVMElementFactory factory, String name) {
                switch (this.getType()) {
                    case ENUM: {
                        return factory.createEnum(name);
                    }
                    case TRAIT: {
                        if (factory instanceof GroovyPsiElementFactory) {
                            return ((GroovyPsiElementFactory)factory).createTrait(name);
                        }
                        return null;
                    }
                    case CLASS: {
                        return factory.createClass(name);
                    }
                    case INTERFACE: {
                        return factory.createInterface(name);
                    }
                    case ANNOTATION: {
                        return factory.createAnnotationType(name);
                    }
                }
                return null;
            }

            private void createTopLevelClass(@NotNull Project project, @NotNull GroovyFileBase file) {
                if (project == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/plugins/groovy/annotator/intentions/CreateClassFix$2", "createTopLevelClass"));
                }
                if (file == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "org/jetbrains/plugins/groovy/annotator/intentions/CreateClassFix$2", "createTopLevelClass"));
                }
                String pack = this.getPackage(file);
                PsiManager manager = PsiManager.getInstance((Project)project);
                String name = this.myRefElement.getReferenceName();
                assert (name != null);
                Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)file);
                PsiDirectory targetDirectory = this.getTargetDirectory(project, pack, name, module, this.getText());
                if (targetDirectory == null) {
                    return;
                }
                String templateName = CreateClassFix.getTemplateName(this.getType());
                GrTypeDefinition targetClass = 2.createClassByType(targetDirectory, name, manager, this.myRefElement, templateName, true);
                if (targetClass == null) {
                    return;
                }
                CreateClassFix.bindRef(targetClass, this.myRefElement);
                IntentionUtils.positionCursor(project, targetClass.getContainingFile(), targetClass);
            }

            @NotNull
            private String getPackage(@NotNull PsiClassOwner file) {
                PsiElement resolved;
                if (file == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "org/jetbrains/plugins/groovy/annotator/intentions/CreateClassFix$2", "getPackage"));
                }
                PsiElement qualifier = this.myRefElement.getQualifier();
                if (qualifier instanceof GrReferenceElement && (resolved = ((GrReferenceElement)qualifier).resolve()) instanceof PsiPackage) {
                    String string = ((PsiPackage)resolved).getQualifiedName();
                    if (string == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/annotator/intentions/CreateClassFix$2", "getPackage"));
                    }
                    return string;
                }
                String string = file instanceof GroovyFile ? file.getPackageName() : "";
                if (string == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/annotator/intentions/CreateClassFix$2", "getPackage"));
                }
                return string;
            }

            @Override
            public boolean isAvailable(@NotNull Project project, Editor editor, PsiFile file) {
                if (project == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/plugins/groovy/annotator/intentions/CreateClassFix$2", "isAvailable"));
                }
                if (!super.isAvailable(project, editor, file)) {
                    return false;
                }
                PsiElement qualifier = this.myRefElement.getQualifier();
                return qualifier == null || this.resolveQualifier(qualifier) != null;
            }
        };
    }

    private static void bindRef(@NotNull PsiClass targetClass, @NotNull GrReferenceElement ref) {
        if (targetClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "targetClass", "org/jetbrains/plugins/groovy/annotator/intentions/CreateClassFix", "bindRef"));
        }
        if (ref == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ref", "org/jetbrains/plugins/groovy/annotator/intentions/CreateClassFix", "bindRef"));
        }
        ApplicationManager.getApplication().runWriteAction(() -> {
            if (ref == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ref", "org/jetbrains/plugins/groovy/annotator/intentions/CreateClassFix", "lambda$bindRef$1"));
            }
            if (targetClass == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "targetClass", "org/jetbrains/plugins/groovy/annotator/intentions/CreateClassFix", "lambda$bindRef$1"));
            }
            PsiElement newRef = ref.bindToElement((PsiElement)targetClass);
            JavaCodeStyleManager.getInstance((Project)targetClass.getProject()).shortenClassReferences(newRef);
        });
    }

    private static String getTemplateName(GrCreateClassKind createClassKind) {
        switch (createClassKind) {
            case TRAIT: {
                return "Groovy Trait.groovy";
            }
            case ENUM: {
                return "Groovy Enum.groovy";
            }
            case CLASS: {
                return "Groovy Class.groovy";
            }
            case INTERFACE: {
                return "Groovy Interface.groovy";
            }
            case ANNOTATION: {
                return "Groovy Annotation.groovy";
            }
        }
        return null;
    }
}

