/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.codeInsight.navigation.actions;

import com.intellij.codeInsight.CodeInsightBundle;
import com.intellij.codeInsight.navigation.GotoTargetHandler;
import com.intellij.lang.LanguageCodeInsightActionHandler;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.util.PsiSuperMethodUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.GroovyBundle;
import org.jetbrains.plugins.groovy.GroovyFileType;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrField;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrAccessorMethod;
import org.jetbrains.plugins.groovy.lang.psi.util.GroovyPropertyUtils;

public class GroovyGotoSuperHandler
extends GotoTargetHandler
implements LanguageCodeInsightActionHandler {
    private static final Logger LOG = Logger.getInstance(GroovyGotoSuperHandler.class);

    protected String getFeatureUsedKey() {
        return "navigation.goto.super";
    }

    protected GotoTargetHandler.GotoData getSourceAndTargetElements(Editor editor, PsiFile file) {
        PsiMember e = GroovyGotoSuperHandler.findSource(editor, file);
        if (e == null) {
            return null;
        }
        return new GotoTargetHandler.GotoData((PsiElement)e, GroovyGotoSuperHandler.findTargets(e), Collections.emptyList());
    }

    @NotNull
    protected String getChooserTitle(@NotNull PsiElement sourceElement, String name, int length, boolean finished) {
        if (sourceElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sourceElement", "org/jetbrains/plugins/groovy/codeInsight/navigation/actions/GroovyGotoSuperHandler", "getChooserTitle"));
        }
        String string = CodeInsightBundle.message((String)"goto.super.method.chooser.title", (Object[])new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/codeInsight/navigation/actions/GroovyGotoSuperHandler", "getChooserTitle"));
        }
        return string;
    }

    @NotNull
    protected String getFindUsagesTitle(@NotNull PsiElement sourceElement, String name, int length) {
        if (sourceElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sourceElement", "org/jetbrains/plugins/groovy/codeInsight/navigation/actions/GroovyGotoSuperHandler", "getFindUsagesTitle"));
        }
        String string = CodeInsightBundle.message((String)"goto.super.method.findUsages.title", (Object[])new Object[]{name});
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/codeInsight/navigation/actions/GroovyGotoSuperHandler", "getFindUsagesTitle"));
        }
        return string;
    }

    @NotNull
    protected String getNotFoundMessage(@NotNull Project project, @NotNull Editor editor, @NotNull PsiFile file) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/plugins/groovy/codeInsight/navigation/actions/GroovyGotoSuperHandler", "getNotFoundMessage"));
        }
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "org/jetbrains/plugins/groovy/codeInsight/navigation/actions/GroovyGotoSuperHandler", "getNotFoundMessage"));
        }
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "org/jetbrains/plugins/groovy/codeInsight/navigation/actions/GroovyGotoSuperHandler", "getNotFoundMessage"));
        }
        PsiMember source = GroovyGotoSuperHandler.findSource(editor, file);
        if (source instanceof PsiClass) {
            String string = GroovyBundle.message("no.super.classes.found", new Object[0]);
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/codeInsight/navigation/actions/GroovyGotoSuperHandler", "getNotFoundMessage"));
            }
            return string;
        }
        if (source instanceof PsiMethod || source instanceof GrField) {
            String string = GroovyBundle.message("no.super.method.found", new Object[0]);
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/codeInsight/navigation/actions/GroovyGotoSuperHandler", "getNotFoundMessage"));
            }
            return string;
        }
        throw new IncorrectOperationException("incorrect element is found: " + (source == null ? "null" : source.getClass().getCanonicalName()));
    }

    @Nullable
    private static PsiMember findSource(Editor editor, PsiFile file) {
        PsiElement element = file.findElementAt(editor.getCaretModel().getOffset());
        if (element == null) {
            return null;
        }
        return (PsiMember)PsiTreeUtil.getParentOfType((PsiElement)element, (Class[])new Class[]{PsiMethod.class, GrField.class, PsiClass.class});
    }

    @NotNull
    private static PsiElement[] findTargets(@NotNull PsiMember e) {
        if (e == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "org/jetbrains/plugins/groovy/codeInsight/navigation/actions/GroovyGotoSuperHandler", "findTargets"));
        }
        if (e instanceof PsiClass) {
            PsiClass aClass = (PsiClass)e;
            ArrayList<PsiClass> allSupers = new ArrayList<PsiClass>(Arrays.asList(aClass.getSupers()));
            Iterator iterator = allSupers.iterator();
            while (iterator.hasNext()) {
                PsiClass superClass = (PsiClass)iterator.next();
                if (!"java.lang.Object".equals(superClass.getQualifiedName())) continue;
                iterator.remove();
            }
            PsiElement[] psiElementArray = (PsiElement[])ContainerUtil.toArray(allSupers, (Object[])new PsiClass[allSupers.size()]);
            if (psiElementArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/codeInsight/navigation/actions/GroovyGotoSuperHandler", "findTargets"));
            }
            return psiElementArray;
        }
        if (e instanceof PsiMethod) {
            PsiMethod[] psiMethodArray = GroovyGotoSuperHandler.getSupers((PsiMethod)e);
            if (psiMethodArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/codeInsight/navigation/actions/GroovyGotoSuperHandler", "findTargets"));
            }
            return psiMethodArray;
        }
        LOG.assertTrue(e instanceof GrField);
        ArrayList<PsiMethod> supers = new ArrayList<PsiMethod>();
        for (GrAccessorMethod method : GroovyPropertyUtils.getFieldAccessors((GrField)e)) {
            supers.addAll(Arrays.asList(GroovyGotoSuperHandler.getSupers(method)));
        }
        PsiElement[] psiElementArray = (PsiElement[])ContainerUtil.toArray(supers, (Object[])new PsiMethod[supers.size()]);
        if (psiElementArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/codeInsight/navigation/actions/GroovyGotoSuperHandler", "findTargets"));
        }
        return psiElementArray;
    }

    @NotNull
    private static PsiMethod[] getSupers(PsiMethod method) {
        if (method.isConstructor()) {
            PsiMethod constructorInSuper = PsiSuperMethodUtil.findConstructorInSuper((PsiMethod)method);
            if (constructorInSuper != null) {
                PsiMethod[] psiMethodArray = new PsiMethod[]{constructorInSuper};
                if (psiMethodArray == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/codeInsight/navigation/actions/GroovyGotoSuperHandler", "getSupers"));
                }
                return psiMethodArray;
            }
        } else {
            PsiMethod[] psiMethodArray = method.findSuperMethods(false);
            if (psiMethodArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/codeInsight/navigation/actions/GroovyGotoSuperHandler", "getSupers"));
            }
            return psiMethodArray;
        }
        if (PsiMethod.EMPTY_ARRAY == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/codeInsight/navigation/actions/GroovyGotoSuperHandler", "getSupers"));
        }
        return PsiMethod.EMPTY_ARRAY;
    }

    public boolean isValidFor(Editor editor, PsiFile file) {
        return file != null && ((Object)((Object)GroovyFileType.GROOVY_FILE_TYPE)).equals(file.getFileType());
    }
}

