/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.codeInspection.changeToMethod.transformations;

import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.codeInspection.changeToMethod.transformations.Transformation;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrBinaryExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.impl.utils.ParenthesesUtils;

abstract class BinaryTransformation
extends Transformation<GrBinaryExpression> {
    BinaryTransformation() {
    }

    @NotNull
    protected GrExpression getLhs(@NotNull GrBinaryExpression expression) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/plugins/groovy/codeInspection/changeToMethod/transformations/BinaryTransformation", "getLhs"));
        }
        GrExpression grExpression = ParenthesesUtils.unparenthesize(Objects.requireNonNull(expression.getLeftOperand()));
        if (grExpression == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/codeInspection/changeToMethod/transformations/BinaryTransformation", "getLhs"));
        }
        return grExpression;
    }

    @NotNull
    protected GrExpression getRhs(@NotNull GrBinaryExpression expression) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/plugins/groovy/codeInspection/changeToMethod/transformations/BinaryTransformation", "getRhs"));
        }
        GrExpression grExpression = ParenthesesUtils.unparenthesize(Objects.requireNonNull(expression.getRightOperand()));
        if (grExpression == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/codeInspection/changeToMethod/transformations/BinaryTransformation", "getRhs"));
        }
        return grExpression;
    }

    @Override
    @Nullable
    protected GrBinaryExpression checkCast(@NotNull GrExpression expression) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/plugins/groovy/codeInspection/changeToMethod/transformations/BinaryTransformation", "checkCast"));
        }
        return expression instanceof GrBinaryExpression ? (GrBinaryExpression)expression : null;
    }

    @Override
    public boolean couldApply(@NotNull GrBinaryExpression expression) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/plugins/groovy/codeInspection/changeToMethod/transformations/BinaryTransformation", "couldApply"));
        }
        return expression.getRightOperand() != null;
    }
}

