/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.codeInspection.changeToMethod.transformations;

import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.codeInspection.GrInspectionUtil;
import org.jetbrains.plugins.groovy.codeInspection.changeToMethod.transformations.Transformation;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrUnaryExpression;

public class UnaryTransformation
extends Transformation<GrUnaryExpression> {
    @NotNull
    private final String myMethod;

    public UnaryTransformation(@NotNull String method) {
        if (method == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "method", "org/jetbrains/plugins/groovy/codeInspection/changeToMethod/transformations/UnaryTransformation", "<init>"));
        }
        this.myMethod = method;
    }

    @Override
    public void apply(@NotNull GrUnaryExpression expression) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/plugins/groovy/codeInspection/changeToMethod/transformations/UnaryTransformation", "apply"));
        }
        GrExpression operand = this.addParenthesesIfNeeded(Objects.requireNonNull(UnaryTransformation.getOperand(expression)));
        GrInspectionUtil.replaceExpression(expression, String.format("%s.%s()", operand.getText(), this.myMethod));
    }

    @Override
    @NotNull
    public String getMethod() {
        String string = this.myMethod;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/codeInspection/changeToMethod/transformations/UnaryTransformation", "getMethod"));
        }
        return string;
    }

    @Override
    @Nullable
    protected GrUnaryExpression checkCast(@NotNull GrExpression expression) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/plugins/groovy/codeInspection/changeToMethod/transformations/UnaryTransformation", "checkCast"));
        }
        return expression instanceof GrUnaryExpression ? (GrUnaryExpression)expression : null;
    }

    @Override
    public boolean couldApply(@NotNull GrUnaryExpression expression) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/plugins/groovy/codeInspection/changeToMethod/transformations/UnaryTransformation", "couldApply"));
        }
        GrExpression operand = UnaryTransformation.getOperand(expression);
        return operand != null;
    }

    @Nullable
    public static GrExpression getOperand(@NotNull GrUnaryExpression callExpression) {
        if (callExpression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "callExpression", "org/jetbrains/plugins/groovy/codeInspection/changeToMethod/transformations/UnaryTransformation", "getOperand"));
        }
        return callExpression.getOperand();
    }
}

