/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.codeInspection.changeToOperator.transformations;

import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.codeInspection.GrInspectionUtil;
import org.jetbrains.plugins.groovy.codeInspection.changeToOperator.ChangeToOperatorInspection;
import org.jetbrains.plugins.groovy.codeInspection.changeToOperator.transformations.BinaryTransformation;
import org.jetbrains.plugins.groovy.lang.lexer.GroovyTokenTypes;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrBinaryExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrMethodCall;
import org.jetbrains.plugins.groovy.lang.psi.impl.utils.ComparisonUtils;
import org.jetbrains.plugins.groovy.lang.psi.impl.utils.ParenthesesUtils;

class CompareToTransformation
extends BinaryTransformation {
    CompareToTransformation() {
    }

    @Override
    public void apply(@NotNull GrMethodCall methodCall, @NotNull ChangeToOperatorInspection.Options options) {
        if (methodCall == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "methodCall", "org/jetbrains/plugins/groovy/codeInspection/changeToOperator/transformations/CompareToTransformation", "apply"));
        }
        if (options == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "options", "org/jetbrains/plugins/groovy/codeInspection/changeToOperator/transformations/CompareToTransformation", "apply"));
        }
        GrExpression rhs = this.getRhs(methodCall);
        GrExpression rhsParenthesized = ParenthesesUtils.checkPrecedenceForNonBinaryOps(rhs, ParenthesesUtils.RELATIONAL_PRECEDENCE) ? ParenthesesUtils.parenthesize(rhs) : rhs;
        GrExpression replacedElement = methodCall;
        IElementType changeToOperator = CompareToTransformation.shouldChangeToOperator(methodCall, options);
        if (changeToOperator != GroovyTokenTypes.mCOMPARE_TO) {
            replacedElement = (GrExpression)methodCall.getParent();
        }
        GrInspectionUtil.replaceExpression(replacedElement, String.format("%s %s %s", this.getLhs(methodCall).getText(), changeToOperator, rhsParenthesized.getText()));
    }

    @Nullable
    private static IElementType shouldChangeToOperator(@NotNull GrMethodCall call, ChangeToOperatorInspection.Options options) {
        if (call == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "call", "org/jetbrains/plugins/groovy/codeInspection/changeToOperator/transformations/CompareToTransformation", "shouldChangeToOperator"));
        }
        PsiElement parent = call.getParent();
        if (ComparisonUtils.isComparison(parent)) {
            IElementType token = ((GrBinaryExpression)parent).getOperationTokenType();
            if (CompareToTransformation.isEquality(token) && !options.shouldChangeCompareToEqualityToEquals()) {
                return null;
            }
            return token;
        }
        return GroovyTokenTypes.mCOMPARE_TO;
    }

    private static boolean isEquality(IElementType comparison) {
        return comparison == GroovyTokenTypes.mNOT_EQUAL || comparison == GroovyTokenTypes.mEQUAL;
    }

    @Override
    public boolean couldApplyInternal(@NotNull GrMethodCall methodCall, @NotNull ChangeToOperatorInspection.Options options) {
        if (methodCall == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "methodCall", "org/jetbrains/plugins/groovy/codeInspection/changeToOperator/transformations/CompareToTransformation", "couldApplyInternal"));
        }
        if (options == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "options", "org/jetbrains/plugins/groovy/codeInspection/changeToOperator/transformations/CompareToTransformation", "couldApplyInternal"));
        }
        return super.couldApplyInternal(methodCall, options) && CompareToTransformation.shouldChangeToOperator(methodCall, options) != null;
    }

    @Override
    protected boolean needParentheses(@NotNull GrMethodCall methodCall, @NotNull ChangeToOperatorInspection.Options options) {
        if (methodCall == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "methodCall", "org/jetbrains/plugins/groovy/codeInspection/changeToOperator/transformations/CompareToTransformation", "needParentheses"));
        }
        if (options == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "options", "org/jetbrains/plugins/groovy/codeInspection/changeToOperator/transformations/CompareToTransformation", "needParentheses"));
        }
        GrExpression rhs = this.getRhs(methodCall);
        return ParenthesesUtils.checkPrecedenceForNonBinaryOps(rhs, ParenthesesUtils.RELATIONAL_PRECEDENCE) || ParenthesesUtils.checkPrecedence(ParenthesesUtils.RELATIONAL_PRECEDENCE, (GrExpression)methodCall);
    }
}

