/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.codeInspection.resources;

import com.intellij.codeInsight.daemon.DaemonCodeAnalyzer;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.compiler.CompilerConfiguration;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.util.containers.ContainerUtil;
import java.util.HashSet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.codeInspection.BaseInspection;
import org.jetbrains.plugins.groovy.codeInspection.BaseInspectionVisitor;
import org.jetbrains.plugins.groovy.codeInspection.GroovyInspectionBundle;
import org.jetbrains.plugins.groovy.lang.psi.GroovyFile;
import org.jetbrains.plugins.groovy.lang.psi.GroovyFileBase;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrMethodCall;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrReferenceExpression;

public class TypeCustomizerInspection
extends BaseInspection {
    private static final HashSet<String> CUSTOMIZER_EVENT_NAMES = ContainerUtil.newHashSet((Object[])new String[]{"setup", "finish", "unresolvedVariable", "unresolvedProperty", "unresolvedAttribute", "beforeMethodCall", "afterMethodCall", "onMethodSelection", "methodNotFound", "beforeVisitMethod", "afterVisitMethod", "beforeVisitClass", "afterVisitClass", "incompatibleAssignment"});

    @Override
    @NotNull
    protected BaseInspectionVisitor buildVisitor() {
        BaseInspectionVisitor baseInspectionVisitor = new BaseInspectionVisitor(){

            @Override
            public void visitFile(@NotNull GroovyFileBase file) {
                if (file == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "org/jetbrains/plugins/groovy/codeInspection/resources/TypeCustomizerInspection$1", "visitFile"));
                }
                CompilerConfiguration configuration = CompilerConfiguration.getInstance((Project)file.getProject());
                if (configuration != null && !configuration.isResourceFile(file.getVirtualFile()) && TypeCustomizerInspection.fileSeemsToBeTypeCustomizer(file)) {
                    LocalQuickFix[] fixes = new LocalQuickFix[]{new AddToResourceFix(file)};
                    String message = GroovyInspectionBundle.message("type.customizer.is.not.marked.as.a.resource.file", new Object[0]);
                    this.registerError((PsiElement)file, message, fixes, ProblemHighlightType.GENERIC_ERROR_OR_WARNING);
                }
            }
        };
        if (baseInspectionVisitor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/codeInspection/resources/TypeCustomizerInspection", "buildVisitor"));
        }
        return baseInspectionVisitor;
    }

    public static boolean fileSeemsToBeTypeCustomizer(@NotNull PsiFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "org/jetbrains/plugins/groovy/codeInspection/resources/TypeCustomizerInspection", "fileSeemsToBeTypeCustomizer"));
        }
        if (file instanceof GroovyFile && ((GroovyFile)file).isScript()) {
            for (GrStatement statement : ((GroovyFile)file).getStatements()) {
                GrExpression invoked;
                if (!(statement instanceof GrMethodCall) || !((invoked = ((GrMethodCall)statement).getInvokedExpression()) instanceof GrReferenceExpression) || ((GrReferenceExpression)invoked).isQualified() || !TypeCustomizerInspection.isCustomizerEvent(((GrReferenceExpression)invoked).getReferenceName())) continue;
                return true;
            }
        }
        return false;
    }

    private static boolean isCustomizerEvent(@Nullable String name) {
        return CUSTOMIZER_EVENT_NAMES.contains(name);
    }

    private static class AddToResourceFix
    implements LocalQuickFix {
        private final PsiFile myFile;

        public AddToResourceFix(PsiFile file) {
            this.myFile = file;
        }

        @NotNull
        public String getName() {
            String string = GroovyInspectionBundle.message("add.to.resources", new Object[0]);
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/codeInspection/resources/TypeCustomizerInspection$AddToResourceFix", "getName"));
            }
            return string;
        }

        public boolean startInWriteAction() {
            return false;
        }

        @NotNull
        public String getFamilyName() {
            String string = GroovyInspectionBundle.message("add.type.customizer.to.resources", new Object[0]);
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/codeInspection/resources/TypeCustomizerInspection$AddToResourceFix", "getFamilyName"));
            }
            return string;
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor2) {
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/plugins/groovy/codeInspection/resources/TypeCustomizerInspection$AddToResourceFix", "applyFix"));
            }
            if (descriptor2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/plugins/groovy/codeInspection/resources/TypeCustomizerInspection$AddToResourceFix", "applyFix"));
            }
            VirtualFile virtualFile = this.myFile.getVirtualFile();
            if (virtualFile == null) {
                return;
            }
            ProjectFileIndex fileIndex = ProjectRootManager.getInstance((Project)project).getFileIndex();
            VirtualFile contentRoot = fileIndex.getContentRootForFile(virtualFile);
            if (contentRoot == null) {
                return;
            }
            VirtualFile sourceRoot = fileIndex.getSourceRootForFile(virtualFile);
            if (sourceRoot == null) {
                String path = VfsUtilCore.getRelativePath((VirtualFile)virtualFile, (VirtualFile)contentRoot, (char)'/');
                CompilerConfiguration.getInstance((Project)project).addResourceFilePattern(path);
            } else {
                String path = VfsUtilCore.getRelativePath((VirtualFile)virtualFile, (VirtualFile)sourceRoot, (char)'/');
                String sourceRootPath = VfsUtilCore.getRelativePath((VirtualFile)sourceRoot, (VirtualFile)contentRoot, (char)'/');
                CompilerConfiguration.getInstance((Project)project).addResourceFilePattern(sourceRootPath + ':' + path);
            }
            DaemonCodeAnalyzer.getInstance((Project)project).restart(this.myFile);
        }
    }
}

