/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.codeInspection.threading;

import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.util.PsiTreeUtil;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.codeInspection.BaseInspection;
import org.jetbrains.plugins.groovy.codeInspection.BaseInspectionVisitor;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrSynchronizedStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.blocks.GrClosableBlock;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrReferenceExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.path.GrMethodCallExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrMethod;

public class GroovyWaitWhileNotSynchronizedInspection
extends BaseInspection {
    @Nls
    @NotNull
    public String getGroupDisplayName() {
        if ("Threading issues" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/codeInspection/threading/GroovyWaitWhileNotSynchronizedInspection", "getGroupDisplayName"));
        }
        return "Threading issues";
    }

    @Nls
    @NotNull
    public String getDisplayName() {
        if ("'wait()' while not synced" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/codeInspection/threading/GroovyWaitWhileNotSynchronizedInspection", "getDisplayName"));
        }
        return "'wait()' while not synced";
    }

    @Override
    @Nullable
    protected String buildErrorString(Object ... args) {
        return "Call to'#ref' outside of synchronized context #loc";
    }

    @Override
    @NotNull
    public BaseInspectionVisitor buildVisitor() {
        Visitor visitor2 = new Visitor();
        if (visitor2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/codeInspection/threading/GroovyWaitWhileNotSynchronizedInspection", "buildVisitor"));
        }
        return visitor2;
    }

    private static class Visitor
    extends BaseInspectionVisitor {
        private Visitor() {
        }

        @Override
        public void visitMethodCallExpression(@NotNull GrMethodCallExpression grMethodCallExpression) {
            if (grMethodCallExpression == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "grMethodCallExpression", "org/jetbrains/plugins/groovy/codeInspection/threading/GroovyWaitWhileNotSynchronizedInspection$Visitor", "visitMethodCallExpression"));
            }
            super.visitMethodCallExpression(grMethodCallExpression);
            GrExpression methodExpression = grMethodCallExpression.getInvokedExpression();
            if (!(methodExpression instanceof GrReferenceExpression)) {
                return;
            }
            GrReferenceExpression reference = (GrReferenceExpression)methodExpression;
            String name = reference.getReferenceName();
            if (!"wait".equals(name)) {
                return;
            }
            PsiMethod method = grMethodCallExpression.resolveMethod();
            if (method == null) {
                return;
            }
            PsiClass containingClass = method.getContainingClass();
            if (containingClass == null || !"java.lang.Object".equals(containingClass.getQualifiedName())) {
                return;
            }
            GrMethod containingMethod = (GrMethod)PsiTreeUtil.getParentOfType((PsiElement)grMethodCallExpression, GrMethod.class);
            if (containingMethod != null && containingMethod.hasModifierProperty("synchronized")) {
                return;
            }
            GrStatement parent = (GrStatement)PsiTreeUtil.getParentOfType((PsiElement)grMethodCallExpression, (Class[])new Class[]{GrSynchronizedStatement.class, GrClosableBlock.class});
            if (parent instanceof GrSynchronizedStatement) {
                return;
            }
            this.registerMethodCallError(grMethodCallExpression, new Object[0]);
        }
    }
}

