/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.config;

import com.intellij.openapi.fileChooser.FileChooser;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.roots.libraries.LibraryKind;
import com.intellij.openapi.roots.libraries.LibraryPresentationProvider;
import com.intellij.openapi.roots.libraries.NewLibraryConfiguration;
import com.intellij.openapi.roots.ui.configuration.libraries.CustomLibraryDescription;
import com.intellij.openapi.roots.ui.configuration.libraryEditor.LibraryEditor;
import com.intellij.openapi.roots.ui.configuration.projectRoot.LibrariesContainer;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.ContainerUtil;
import java.awt.Component;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.config.GroovyLibraryPresentationProviderBase;

public class GroovyLibraryDescription
extends CustomLibraryDescription {
    private static final String GROOVY_FRAMEWORK_NAME = "Groovy";
    private final String myEnvVariable;
    private final Set<? extends LibraryKind> myLibraryKinds;
    private final String myFrameworkName;

    public GroovyLibraryDescription() {
        this("GROOVY_HOME", GroovyLibraryDescription.getAllGroovyKinds(), GROOVY_FRAMEWORK_NAME);
    }

    public static Set<? extends LibraryKind> getAllGroovyKinds() {
        HashSet<LibraryKind> kinds = new HashSet<LibraryKind>();
        for (LibraryPresentationProvider provider2 : (LibraryPresentationProvider[])LibraryPresentationProvider.EP_NAME.getExtensions()) {
            if (!(provider2 instanceof GroovyLibraryPresentationProviderBase)) continue;
            kinds.add(provider2.getKind());
        }
        return kinds;
    }

    public GroovyLibraryDescription(@NotNull String envVariable, @NotNull LibraryKind libraryKind, String frameworkName) {
        if (envVariable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "envVariable", "org/jetbrains/plugins/groovy/config/GroovyLibraryDescription", "<init>"));
        }
        if (libraryKind == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "libraryKind", "org/jetbrains/plugins/groovy/config/GroovyLibraryDescription", "<init>"));
        }
        this(envVariable, Collections.singleton(libraryKind), frameworkName);
    }

    private GroovyLibraryDescription(@NotNull String envVariable, @NotNull Set<? extends LibraryKind> libraryKinds, String frameworkName) {
        if (envVariable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "envVariable", "org/jetbrains/plugins/groovy/config/GroovyLibraryDescription", "<init>"));
        }
        if (libraryKinds == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "libraryKinds", "org/jetbrains/plugins/groovy/config/GroovyLibraryDescription", "<init>"));
        }
        this.myEnvVariable = envVariable;
        this.myLibraryKinds = libraryKinds;
        this.myFrameworkName = frameworkName;
    }

    @Nullable
    public static GroovyLibraryPresentationProviderBase findManager(@NotNull VirtualFile dir) {
        if (dir == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dir", "org/jetbrains/plugins/groovy/config/GroovyLibraryDescription", "findManager"));
        }
        String name = dir.getName();
        List providers = ContainerUtil.findAll((Object[])LibraryPresentationProvider.EP_NAME.getExtensions(), GroovyLibraryPresentationProviderBase.class);
        for (GroovyLibraryPresentationProviderBase provider2 : providers) {
            if (!provider2.managesName(name) || !provider2.isSDKHome(dir)) continue;
            return provider2;
        }
        for (GroovyLibraryPresentationProviderBase manager : providers) {
            if (!manager.isSDKHome(dir)) continue;
            return manager;
        }
        return null;
    }

    @NotNull
    public Set<? extends LibraryKind> getSuitableLibraryKinds() {
        Set<? extends LibraryKind> set = this.myLibraryKinds;
        if (set == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/config/GroovyLibraryDescription", "getSuitableLibraryKinds"));
        }
        return set;
    }

    public NewLibraryConfiguration createNewLibrary(@NotNull JComponent parentComponent, VirtualFile contextDirectory) {
        if (parentComponent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parentComponent", "org/jetbrains/plugins/groovy/config/GroovyLibraryDescription", "createNewLibrary"));
        }
        VirtualFile initial = GroovyLibraryDescription.findFile(System.getenv(this.myEnvVariable));
        if (initial == null && GROOVY_FRAMEWORK_NAME.equals(this.myFrameworkName) && SystemInfo.isLinux) {
            initial = GroovyLibraryDescription.findFile("/usr/share/groovy");
        }
        FileChooserDescriptor descriptor2 = new FileChooserDescriptor(false, true, false, false, false, false){

            public boolean isFileSelectable(VirtualFile file) {
                if (!super.isFileSelectable(file)) {
                    return false;
                }
                return GroovyLibraryDescription.findManager(file) != null;
            }
        };
        descriptor2.setTitle(this.myFrameworkName + " SDK");
        descriptor2.setDescription("Choose a directory containing " + this.myFrameworkName + " distribution");
        VirtualFile dir = FileChooser.chooseFile((FileChooserDescriptor)descriptor2, (Component)parentComponent, null, (VirtualFile)initial);
        if (dir == null) {
            return null;
        }
        final GroovyLibraryPresentationProviderBase provider2 = GroovyLibraryDescription.findManager(dir);
        if (provider2 == null) {
            return null;
        }
        final String path = dir.getPath();
        String sdkVersion = provider2.getSDKVersion(path);
        if ("undefined".equals(sdkVersion)) {
            Messages.showErrorDialog((Component)parentComponent, (String)("Looks like " + this.myFrameworkName + " distribution in specified path is broken. Cannot determine version."), (String)"Failed to Create Library");
            return null;
        }
        return new NewLibraryConfiguration(provider2.getLibraryPrefix() + "-" + sdkVersion){

            public void addRoots(@NotNull LibraryEditor editor) {
                if (editor == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "org/jetbrains/plugins/groovy/config/GroovyLibraryDescription$2", "addRoots"));
                }
                provider2.fillLibrary(path, editor);
            }
        };
    }

    @Nullable
    private static VirtualFile findFile(String path) {
        if (path != null && !path.isEmpty()) {
            return LocalFileSystem.getInstance().findFileByPath(FileUtil.toSystemIndependentName((String)path));
        }
        return null;
    }

    @NotNull
    public LibrariesContainer.LibraryLevel getDefaultLevel() {
        LibrariesContainer.LibraryLevel libraryLevel = LibrariesContainer.LibraryLevel.GLOBAL;
        if (libraryLevel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/config/GroovyLibraryDescription", "getDefaultLevel"));
        }
        return libraryLevel;
    }
}

