/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.dsl;

import com.intellij.notification.Notification;
import com.intellij.notification.NotificationDisplayType;
import com.intellij.notification.NotificationGroup;
import com.intellij.notification.NotificationListener;
import com.intellij.notification.NotificationType;
import com.intellij.notification.impl.NotificationsConfigurationImpl;
import com.intellij.openapi.application.ex.ApplicationManagerEx;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ExceptionUtil;
import javax.swing.event.HyperlinkEvent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.dsl.DslActivationStatus;
import org.jetbrains.plugins.groovy.dsl.DslErrorReporter;
import org.jetbrains.plugins.groovy.dsl.GroovyDslFileIndex;
import org.jetbrains.plugins.groovy.dsl.InvestigateFix;

public class DslErrorReporterImpl
extends DslErrorReporter {
    private static final Logger LOG = Logger.getInstance((String)"#org.jetbrains.plugins.groovy.dsl.GroovyDslFileIndex");
    private final NotificationGroup NOTIFICATION_GROUP = new NotificationGroup("Groovy DSL errors", NotificationDisplayType.BALLOON, true);

    public DslErrorReporterImpl() {
        NotificationsConfigurationImpl.remove((String[])new String[]{"Groovy DSL parsing"});
    }

    @Override
    public void invokeDslErrorPopup(Throwable e, final Project project, @NotNull VirtualFile vfile) {
        if (vfile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "vfile", "org/jetbrains/plugins/groovy/dsl/DslErrorReporterImpl", "invokeDslErrorPopup"));
        }
        if (!GroovyDslFileIndex.isActivated(vfile)) {
            return;
        }
        final String exceptionText = ExceptionUtil.getThrowableText((Throwable)e);
        LOG.info(exceptionText);
        GroovyDslFileIndex.disableFile(vfile, DslActivationStatus.Status.ERROR, exceptionText);
        if (!ApplicationManagerEx.getApplicationEx().isInternal() && !ProjectRootManager.getInstance((Project)project).getFileIndex().isInContent(vfile)) {
            return;
        }
        String content = "<p>" + e.getMessage() + "</p><p><a href=\"\">Click here to investigate.</a></p>";
        this.NOTIFICATION_GROUP.createNotification("DSL script execution error", content, NotificationType.ERROR, new NotificationListener(){

            public void hyperlinkUpdate(@NotNull Notification notification, @NotNull HyperlinkEvent event) {
                if (notification == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "notification", "org/jetbrains/plugins/groovy/dsl/DslErrorReporterImpl$1", "hyperlinkUpdate"));
                }
                if (event == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "org/jetbrains/plugins/groovy/dsl/DslErrorReporterImpl$1", "hyperlinkUpdate"));
                }
                InvestigateFix.analyzeStackTrace(project, exceptionText);
                notification.expire();
            }
        }).notify(project);
    }
}

