/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.formatter.processors;

import com.intellij.formatting.Spacing;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiErrorElement;
import com.intellij.psi.codeStyle.CommonCodeStyleSettings;
import com.intellij.psi.tree.IElementType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.codeStyle.GroovyCodeStyleSettings;
import org.jetbrains.plugins.groovy.formatter.FormattingContext;
import org.jetbrains.plugins.groovy.formatter.blocks.ClosureBodyBlock;
import org.jetbrains.plugins.groovy.formatter.blocks.GrLabelBlock;
import org.jetbrains.plugins.groovy.formatter.blocks.GroovyBlock;
import org.jetbrains.plugins.groovy.formatter.blocks.MethodCallWithoutQualifierBlock;
import org.jetbrains.plugins.groovy.formatter.models.spacing.SpacingTokens;
import org.jetbrains.plugins.groovy.lang.groovydoc.lexer.GroovyDocTokenTypes;
import org.jetbrains.plugins.groovy.lang.groovydoc.parser.GroovyDocElementTypes;
import org.jetbrains.plugins.groovy.lang.lexer.GroovyTokenTypes;
import org.jetbrains.plugins.groovy.lang.lexer.TokenSets;
import org.jetbrains.plugins.groovy.lang.parser.GroovyElementTypes;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.blocks.GrClosableBlock;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrConditionalExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrNewExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrUnaryExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.literals.GrStringInjection;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.GrAnonymousClassDefinition;
import org.jetbrains.plugins.groovy.lang.psi.api.types.GrCodeReferenceElement;
import org.jetbrains.plugins.groovy.lang.psi.api.types.GrTypeArgumentList;
import org.jetbrains.plugins.groovy.lang.psi.api.util.GrStatementOwner;

public abstract class GroovySpacingProcessorBasic {
    private static final Spacing NO_SPACING_WITH_NEWLINE = Spacing.createSpacing((int)0, (int)0, (int)0, (boolean)true, (int)1);
    private static final Spacing NO_SPACING = Spacing.createSpacing((int)0, (int)0, (int)0, (boolean)false, (int)0);
    private static final Spacing COMMON_SPACING = Spacing.createSpacing((int)1, (int)1, (int)0, (boolean)true, (int)100);
    private static final Spacing COMMON_SPACING_WITH_NL = Spacing.createSpacing((int)1, (int)1, (int)1, (boolean)true, (int)100);
    private static final Spacing LAZY_SPACING = Spacing.createSpacing((int)0, (int)239, (int)0, (boolean)true, (int)100);

    public static Spacing getSpacing(GroovyBlock child1, GroovyBlock child2, FormattingContext context) {
        PsiElement p;
        ASTNode leftNode = child1.getNode();
        ASTNode rightNode = child2.getNode();
        PsiElement left = leftNode.getPsi();
        PsiElement right = rightNode.getPsi();
        IElementType leftType = leftNode.getElementType();
        IElementType rightType = rightNode.getElementType();
        CommonCodeStyleSettings settings = context.getSettings();
        GroovyCodeStyleSettings groovySettings = context.getGroovySettings();
        if (!GroovySpacingProcessorBasic.mirrorsAst(child1) || !GroovySpacingProcessorBasic.mirrorsAst(child2)) {
            return NO_SPACING;
        }
        if (child2 instanceof ClosureBodyBlock) {
            return settings.SPACE_WITHIN_BRACES ? COMMON_SPACING : NO_SPACING_WITH_NEWLINE;
        }
        if (child1 instanceof ClosureBodyBlock) {
            return GroovySpacingProcessorBasic.createDependentSpacingForClosure(settings, groovySettings, (GrClosableBlock)left.getParent(), false);
        }
        if (leftType == GroovyDocElementTypes.GROOVY_DOC_COMMENT) {
            return COMMON_SPACING_WITH_NL;
        }
        if (right instanceof GrTypeArgumentList) {
            return NO_SPACING_WITH_NEWLINE;
        }
        if (GroovyTokenTypes.mCOMMA == leftType) {
            return settings.SPACE_AFTER_COMMA ? COMMON_SPACING : NO_SPACING_WITH_NEWLINE;
        }
        if (GroovyTokenTypes.mCOMMA == rightType) {
            return settings.SPACE_BEFORE_COMMA ? COMMON_SPACING : NO_SPACING_WITH_NEWLINE;
        }
        if (GroovyTokenTypes.mSEMI == leftType) {
            return settings.SPACE_AFTER_SEMICOLON ? COMMON_SPACING : NO_SPACING_WITH_NEWLINE;
        }
        if (GroovyTokenTypes.mSEMI == rightType) {
            return settings.SPACE_BEFORE_SEMICOLON ? COMMON_SPACING : NO_SPACING_WITH_NEWLINE;
        }
        if (TokenSets.DOTS.contains(rightType) || GroovyTokenTypes.mCOLON.equals(rightType) && !(right.getParent() instanceof GrConditionalExpression)) {
            return NO_SPACING_WITH_NEWLINE;
        }
        if (TokenSets.DOTS.contains(leftType)) {
            return NO_SPACING_WITH_NEWLINE;
        }
        if ((((Object)((Object)GroovyElementTypes.VARIABLE_DEFINITION)).equals(leftType) || ((Object)((Object)GroovyElementTypes.VARIABLE_DEFINITION)).equals(rightType)) && !(leftNode.getTreeNext() instanceof PsiErrorElement)) {
            return Spacing.createSpacing((int)0, (int)0, (int)1, (boolean)false, (int)100);
        }
        if (leftNode.getTreeParent().getElementType() == GroovyTokenTypes.mREGEX_LITERAL || leftNode.getTreeParent().getElementType() == GroovyTokenTypes.mDOLLAR_SLASH_REGEX_LITERAL) {
            return NO_SPACING;
        }
        if (GroovyTokenTypes.mLT.equals(leftType) && GroovyTokenTypes.mLT.equals(rightType) || GroovyTokenTypes.mGT.equals(leftType) && GroovyTokenTypes.mGT.equals(rightType)) {
            return NO_SPACING_WITH_NEWLINE;
        }
        if (SpacingTokens.PREFIXES.contains(leftType) || SpacingTokens.POSTFIXES.contains(rightType) || SpacingTokens.PREFIXES_OPTIONAL.contains(leftType) && left.getParent() instanceof GrUnaryExpression) {
            return NO_SPACING_WITH_NEWLINE;
        }
        if (SpacingTokens.RANGES.contains(leftType) || SpacingTokens.RANGES.contains(rightType)) {
            return NO_SPACING_WITH_NEWLINE;
        }
        if (GroovyDocTokenTypes.mGDOC_ASTERISKS == leftType && GroovyDocTokenTypes.mGDOC_COMMENT_DATA == rightType) {
            String text = rightNode.getText();
            if (!text.isEmpty() && !StringUtil.startsWithChar((CharSequence)text, (char)' ')) {
                return COMMON_SPACING;
            }
            return NO_SPACING;
        }
        if (leftType == GroovyDocTokenTypes.mGDOC_TAG_VALUE_TOKEN && rightType == GroovyDocTokenTypes.mGDOC_COMMENT_DATA) {
            return LAZY_SPACING;
        }
        if (left instanceof GrStatement && right instanceof GrStatement && left.getParent() instanceof GrStatementOwner && right.getParent() instanceof GrStatementOwner) {
            return COMMON_SPACING_WITH_NL;
        }
        if (rightType == GroovyDocTokenTypes.mGDOC_INLINE_TAG_END || leftType == GroovyDocTokenTypes.mGDOC_INLINE_TAG_START || rightType == GroovyDocTokenTypes.mGDOC_INLINE_TAG_START || leftType == GroovyDocTokenTypes.mGDOC_INLINE_TAG_END) {
            return NO_SPACING;
        }
        if (leftType == GroovyDocElementTypes.GDOC_INLINED_TAG && rightType == GroovyDocTokenTypes.mGDOC_COMMENT_DATA || leftType == GroovyDocTokenTypes.mGDOC_COMMENT_DATA && rightType == GroovyDocElementTypes.GDOC_INLINED_TAG) {
            return NO_SPACING;
        }
        if (leftType == GroovyElementTypes.CLASS_TYPE_ELEMENT && rightType == GroovyTokenTypes.mTRIPLE_DOT) {
            return NO_SPACING;
        }
        if ((rightType == GroovyTokenTypes.mLT || rightType == GroovyTokenTypes.mGT) && right.getParent() instanceof GrCodeReferenceElement && ((p = right.getParent().getParent()) instanceof GrNewExpression || p instanceof GrAnonymousClassDefinition)) {
            return NO_SPACING;
        }
        return COMMON_SPACING;
    }

    @NotNull
    static Spacing createDependentSpacingForClosure(@NotNull CommonCodeStyleSettings settings, @NotNull GroovyCodeStyleSettings groovySettings, @NotNull GrClosableBlock closure, boolean forArrow) {
        if (settings == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "settings", "org/jetbrains/plugins/groovy/formatter/processors/GroovySpacingProcessorBasic", "createDependentSpacingForClosure"));
        }
        if (groovySettings == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "groovySettings", "org/jetbrains/plugins/groovy/formatter/processors/GroovySpacingProcessorBasic", "createDependentSpacingForClosure"));
        }
        if (closure == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "closure", "org/jetbrains/plugins/groovy/formatter/processors/GroovySpacingProcessorBasic", "createDependentSpacingForClosure"));
        }
        boolean spaceWithinBraces = closure.getParent() instanceof GrStringInjection ? groovySettings.SPACE_WITHIN_GSTRING_INJECTION_BRACES : settings.SPACE_WITHIN_BRACES;
        GrStatement[] statements = closure.getStatements();
        if (statements.length > 0) {
            GrClosableBlock startElem = forArrow ? statements[0] : closure;
            int start = startElem.getTextRange().getStartOffset();
            int end = statements[statements.length - 1].getTextRange().getEndOffset();
            TextRange range = new TextRange(start, end);
            int minSpaces = spaceWithinBraces || forArrow ? 1 : 0;
            int maxSpaces = spaceWithinBraces || forArrow ? 1 : 0;
            Spacing spacing = Spacing.createDependentLFSpacing((int)minSpaces, (int)maxSpaces, (TextRange)range, (boolean)settings.KEEP_LINE_BREAKS, (int)settings.KEEP_BLANK_LINES_IN_CODE);
            if (spacing == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/formatter/processors/GroovySpacingProcessorBasic", "createDependentSpacingForClosure"));
            }
            return spacing;
        }
        Spacing spacing = spaceWithinBraces || forArrow ? COMMON_SPACING : NO_SPACING_WITH_NEWLINE;
        if (spacing == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/formatter/processors/GroovySpacingProcessorBasic", "createDependentSpacingForClosure"));
        }
        return spacing;
    }

    private static boolean mirrorsAst(GroovyBlock block) {
        return block.getNode().getTextRange().equals((Object)block.getTextRange()) || block instanceof MethodCallWithoutQualifierBlock || block instanceof ClosureBodyBlock || block instanceof GrLabelBlock;
    }
}

