/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.gant;

import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.project.IndexNotReadyException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiFile;
import com.intellij.psi.search.FilenameIndex;
import com.intellij.psi.search.GlobalSearchScope;
import com.sun.jdi.ReferenceType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.extensions.debugger.ScriptPositionManagerHelper;
import org.jetbrains.plugins.groovy.gant.GantScriptType;
import org.jetbrains.plugins.groovy.lang.psi.GroovyFile;
import org.jetbrains.plugins.groovy.runner.GroovyScriptUtil;

public class GantPositionManagerHelper
extends ScriptPositionManagerHelper {
    @Override
    public boolean isAppropriateRuntimeName(@NotNull String runtimeName) {
        if (runtimeName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "runtimeName", "org/jetbrains/plugins/groovy/gant/GantPositionManagerHelper", "isAppropriateRuntimeName"));
        }
        return true;
    }

    @Override
    public boolean isAppropriateScriptFile(@NotNull GroovyFile scriptFile) {
        if (scriptFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scriptFile", "org/jetbrains/plugins/groovy/gant/GantPositionManagerHelper", "isAppropriateScriptFile"));
        }
        return GroovyScriptUtil.isSpecificScriptFile(scriptFile, GantScriptType.INSTANCE);
    }

    @Override
    public PsiFile getExtraScriptIfNotFound(@NotNull ReferenceType refType, @NotNull String runtimeName, @NotNull Project project, @NotNull GlobalSearchScope scope) {
        if (refType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "refType", "org/jetbrains/plugins/groovy/gant/GantPositionManagerHelper", "getExtraScriptIfNotFound"));
        }
        if (runtimeName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "runtimeName", "org/jetbrains/plugins/groovy/gant/GantPositionManagerHelper", "getExtraScriptIfNotFound"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/plugins/groovy/gant/GantPositionManagerHelper", "getExtraScriptIfNotFound"));
        }
        if (scope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "org/jetbrains/plugins/groovy/gant/GantPositionManagerHelper", "getExtraScriptIfNotFound"));
        }
        try {
            String fileName = StringUtil.getShortName((String)runtimeName);
            PsiFile[] files = FilenameIndex.getFilesByName((Project)project, (String)(fileName + "." + "gant"), (GlobalSearchScope)scope);
            if (files.length == 0) {
                files = FilenameIndex.getFilesByName((Project)project, (String)(fileName + "." + "gant"), (GlobalSearchScope)GlobalSearchScope.allScope((Project)project));
            }
            if (files.length == 1) {
                return files[0];
            }
            if (files.length == 0) {
                files = FilenameIndex.getFilesByName((Project)project, (String)(fileName + ".groovy"), (GlobalSearchScope)scope);
                if (files.length == 0) {
                    files = FilenameIndex.getFilesByName((Project)project, (String)(fileName + "." + "gant"), (GlobalSearchScope)GlobalSearchScope.allScope((Project)project));
                }
                PsiFile candidate = null;
                for (PsiFile file : files) {
                    if (!GroovyScriptUtil.isSpecificScriptFile(file, GantScriptType.INSTANCE)) continue;
                    if (candidate != null) {
                        return null;
                    }
                    candidate = file;
                }
                return candidate;
            }
        }
        catch (ProcessCanceledException | IndexNotReadyException throwable) {
            // empty catch block
        }
        return null;
    }
}

