/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.psi.controlFlow.impl;

import com.intellij.psi.PsiElement;
import java.util.Collections;
import java.util.Deque;
import java.util.LinkedHashSet;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.lang.psi.controlFlow.CallEnvironment;
import org.jetbrains.plugins.groovy.lang.psi.controlFlow.CallInstruction;
import org.jetbrains.plugins.groovy.lang.psi.controlFlow.Instruction;
import org.jetbrains.plugins.groovy.lang.psi.controlFlow.NegatingGotoInstruction;

public class InstructionImpl
implements Instruction {
    private final LinkedHashSet<Instruction> myPredecessors = new LinkedHashSet(1);
    private final LinkedHashSet<Instruction> mySuccessors = new LinkedHashSet(1);
    private LinkedHashSet<NegatingGotoInstruction> myNegations;
    protected final PsiElement myPsiElement;
    private int myNumber = -1;

    @Override
    @Nullable
    public PsiElement getElement() {
        return this.myPsiElement;
    }

    public InstructionImpl(@Nullable PsiElement element) {
        this.myPsiElement = element;
    }

    @Override
    @NotNull
    public Iterable<Instruction> successors(@NotNull CallEnvironment environment) {
        if (environment == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "environment", "org/jetbrains/plugins/groovy/lang/psi/controlFlow/impl/InstructionImpl", "successors"));
        }
        Deque<CallInstruction> stack = environment.callStack(this);
        for (Instruction instruction : this.mySuccessors) {
            environment.update(stack, instruction);
        }
        LinkedHashSet<Instruction> linkedHashSet = this.mySuccessors;
        if (linkedHashSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/psi/controlFlow/impl/InstructionImpl", "successors"));
        }
        return linkedHashSet;
    }

    @Override
    @NotNull
    public Iterable<Instruction> predecessors(@NotNull CallEnvironment environment) {
        if (environment == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "environment", "org/jetbrains/plugins/groovy/lang/psi/controlFlow/impl/InstructionImpl", "predecessors"));
        }
        Deque<CallInstruction> stack = environment.callStack(this);
        for (Instruction instruction : this.myPredecessors) {
            environment.update(stack, instruction);
        }
        LinkedHashSet<Instruction> linkedHashSet = this.myPredecessors;
        if (linkedHashSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/psi/controlFlow/impl/InstructionImpl", "predecessors"));
        }
        return linkedHashSet;
    }

    @Override
    @NotNull
    public Iterable<Instruction> allSuccessors() {
        LinkedHashSet<Instruction> linkedHashSet = this.mySuccessors;
        if (linkedHashSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/psi/controlFlow/impl/InstructionImpl", "allSuccessors"));
        }
        return linkedHashSet;
    }

    @Override
    @NotNull
    public Iterable<Instruction> allPredecessors() {
        LinkedHashSet<Instruction> linkedHashSet = this.myPredecessors;
        if (linkedHashSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/psi/controlFlow/impl/InstructionImpl", "allPredecessors"));
        }
        return linkedHashSet;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append(this.myNumber);
        builder.append("(");
        for (Instruction successor : this.mySuccessors) {
            builder.append(successor.num());
            builder.append(',');
        }
        if (!this.mySuccessors.isEmpty()) {
            builder.delete(builder.length() - 1, builder.length());
        }
        builder.append(") ").append(this.getElementPresentation());
        return builder.toString();
    }

    @NotNull
    protected String getElementPresentation() {
        String string = "element: " + this.myPsiElement;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/psi/controlFlow/impl/InstructionImpl", "getElementPresentation"));
        }
        return string;
    }

    @Override
    public int num() {
        assert (this.myNumber != -1);
        return this.myNumber;
    }

    @Override
    @NotNull
    public Iterable<? extends NegatingGotoInstruction> getNegatingGotoInstruction() {
        if (this.myNegations == null) {
            List list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/psi/controlFlow/impl/InstructionImpl", "getNegatingGotoInstruction"));
            }
            return list;
        }
        LinkedHashSet<NegatingGotoInstruction> linkedHashSet = this.myNegations;
        if (linkedHashSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/psi/controlFlow/impl/InstructionImpl", "getNegatingGotoInstruction"));
        }
        return linkedHashSet;
    }

    public void addSuccessor(InstructionImpl instruction) {
        this.mySuccessors.add(instruction);
    }

    public void addPredecessor(InstructionImpl instruction) {
        this.myPredecessors.add(instruction);
    }

    void addNegationsFrom(Instruction instruction) {
        if (this.myNegations == null) {
            this.myNegations = new LinkedHashSet(1);
        }
        for (NegatingGotoInstruction negatingGotoInstruction : instruction.getNegatingGotoInstruction()) {
            this.myNegations.add(negatingGotoInstruction);
        }
        if (instruction instanceof NegatingGotoInstruction) {
            this.myNegations.add((NegatingGotoInstruction)instruction);
        }
    }

    final void setNumber(int num) {
        assert (this.myNumber == -1);
        this.myNumber = num;
    }
}

