/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.psi.impl;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiIntersectionType;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeVisitor;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.PsiTypesUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrSafeCastExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.types.GrTypeElement;
import org.jetbrains.plugins.groovy.lang.psi.util.GrTraitUtil;

public class GrTraitType
extends PsiType {
    @NotNull
    private final PsiIntersectionType myDelegate;
    @NotNull
    private final PsiType myExprType;
    @NotNull
    private final List<PsiType> myTraitTypes;

    private GrTraitType(@NotNull PsiIntersectionType delegate) {
        if (delegate == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "delegate", "org/jetbrains/plugins/groovy/lang/psi/impl/GrTraitType", "<init>"));
        }
        super(PsiAnnotation.EMPTY_ARRAY);
        this.myDelegate = delegate;
        this.myExprType = delegate.getConjuncts()[0];
        this.myTraitTypes = ContainerUtil.newArrayList((Object[])delegate.getConjuncts(), (int)1, (int)delegate.getConjuncts().length);
    }

    @NotNull
    public PsiType getExprType() {
        PsiType psiType = this.myExprType;
        if (psiType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/psi/impl/GrTraitType", "getExprType"));
        }
        return psiType;
    }

    @NotNull
    public List<PsiType> getTraitTypes() {
        List<PsiType> list = this.myTraitTypes;
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/psi/impl/GrTraitType", "getTraitTypes"));
        }
        return list;
    }

    @NotNull
    public PsiType[] getConjuncts() {
        PsiType[] psiTypeArray = this.myDelegate.getConjuncts();
        if (psiTypeArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/psi/impl/GrTraitType", "getConjuncts"));
        }
        return psiTypeArray;
    }

    @NotNull
    public String getPresentableText() {
        String string = this.myExprType.getPresentableText() + " as " + StringUtil.join((Collection)ContainerUtil.map(this.myTraitTypes, type -> type.getPresentableText()), (String)", ");
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/psi/impl/GrTraitType", "getPresentableText"));
        }
        return string;
    }

    @NotNull
    public String getCanonicalText() {
        String string = this.myDelegate.getCanonicalText();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/psi/impl/GrTraitType", "getCanonicalText"));
        }
        return string;
    }

    @NotNull
    public String getInternalCanonicalText() {
        String string = this.myExprType.getCanonicalText() + " as " + StringUtil.join((Collection)ContainerUtil.map(this.myTraitTypes, type -> type.getInternalCanonicalText()), (String)", ");
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/psi/impl/GrTraitType", "getInternalCanonicalText"));
        }
        return string;
    }

    public boolean isValid() {
        return this.myDelegate.isValid();
    }

    public boolean equalsToText(@NotNull @NonNls String text) {
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "org/jetbrains/plugins/groovy/lang/psi/impl/GrTraitType", "equalsToText"));
        }
        return this.myDelegate.equalsToText(text);
    }

    public <A> A accept(@NotNull PsiTypeVisitor<A> visitor2) {
        if (visitor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "visitor", "org/jetbrains/plugins/groovy/lang/psi/impl/GrTraitType", "accept"));
        }
        return (A)this.myDelegate.accept(visitor2);
    }

    @Nullable
    public GlobalSearchScope getResolveScope() {
        return this.myDelegate.getResolveScope();
    }

    @NotNull
    public PsiType[] getSuperTypes() {
        PsiType[] psiTypeArray = this.myDelegate.getSuperTypes();
        if (psiTypeArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/psi/impl/GrTraitType", "getSuperTypes"));
        }
        return psiTypeArray;
    }

    @Nullable
    public static PsiType createTraitType(@NotNull GrSafeCastExpression safeCastExpression) {
        if (safeCastExpression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "safeCastExpression", "org/jetbrains/plugins/groovy/lang/psi/impl/GrTraitType", "createTraitType"));
        }
        GrExpression operand = safeCastExpression.getOperand();
        PsiType exprType = operand.getType();
        if (!(exprType instanceof PsiClassType) && !(exprType instanceof GrTraitType)) {
            return null;
        }
        GrTypeElement typeElement = safeCastExpression.getCastTypeElement();
        if (typeElement == null) {
            return null;
        }
        PsiType type = typeElement.getType();
        if (!GrTraitUtil.isTrait(PsiTypesUtil.getPsiClass((PsiType)type))) {
            return null;
        }
        return GrTraitType.createTraitType(exprType, ContainerUtil.newSmartList((Object)type));
    }

    @NotNull
    public static PsiType createTraitType(@NotNull PsiType type, @NotNull List<PsiType> traits) {
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "org/jetbrains/plugins/groovy/lang/psi/impl/GrTraitType", "createTraitType"));
        }
        if (traits == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "traits", "org/jetbrains/plugins/groovy/lang/psi/impl/GrTraitType", "createTraitType"));
        }
        PsiType psiType = GrTraitType.createTraitType(ContainerUtil.prepend(traits, (Object[])new PsiType[]{type instanceof GrTraitType ? ((GrTraitType)type).myDelegate : type}));
        if (psiType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/psi/impl/GrTraitType", "createTraitType"));
        }
        return psiType;
    }

    @NotNull
    public static PsiType createTraitType(@NotNull List<PsiType> types) {
        if (types == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "types", "org/jetbrains/plugins/groovy/lang/psi/impl/GrTraitType", "createTraitType"));
        }
        PsiType psiType = GrTraitType.createTraitType(types.toArray(PsiType.createArray((int)types.size())));
        if (psiType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/psi/impl/GrTraitType", "createTraitType"));
        }
        return psiType;
    }

    @NotNull
    public static PsiType createTraitType(@NotNull PsiType[] types) {
        if (types == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "types", "org/jetbrains/plugins/groovy/lang/psi/impl/GrTraitType", "createTraitType"));
        }
        Set flattened = PsiIntersectionType.flatten((PsiType[])types, (Set)new LinkedHashSet<PsiType>(){

            @Override
            public boolean add(PsiType type) {
                this.remove(type);
                return super.add(type);
            }
        });
        PsiType[] conjuncts = flattened.toArray(PsiType.createArray((int)flattened.size()));
        if (conjuncts.length == 1) {
            PsiType psiType = conjuncts[0];
            if (psiType == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/psi/impl/GrTraitType", "createTraitType"));
            }
            return psiType;
        }
        GrTraitType grTraitType = new GrTraitType((PsiIntersectionType)PsiIntersectionType.createIntersection((boolean)false, (PsiType[])conjuncts));
        if (grTraitType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/psi/impl/GrTraitType", "createTraitType"));
        }
        return grTraitType;
    }
}

