/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.psi.impl;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.RecursionManager;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiPolyVariantReference;
import com.intellij.psi.PsiType;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.impl.source.resolve.ResolveCache;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.util.Function;
import com.intellij.util.containers.ContainerUtil;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElement;
import org.jetbrains.plugins.groovy.lang.psi.api.GroovyResolveResult;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrReferenceExpression;
import org.jetbrains.plugins.groovy.lang.psi.dataFlow.types.TypeInferenceHelper;
import org.jetbrains.plugins.groovy.lang.psi.impl.GroovyPsiManager;

public interface InferenceContext {
    public static final InferenceContext TOP_CONTEXT = new InferenceContext(){

        @Override
        @Nullable
        public PsiType getVariableType(@NotNull GrReferenceExpression ref) {
            if (ref == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ref", "org/jetbrains/plugins/groovy/lang/psi/impl/InferenceContext$1", "getVariableType"));
            }
            return TypeInferenceHelper.getInferredType(ref);
        }

        @Override
        public <T> T getCachedValue(@NotNull GroovyPsiElement element, @NotNull Computable<T> computable) {
            if (element == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/plugins/groovy/lang/psi/impl/InferenceContext$1", "getCachedValue"));
            }
            if (computable == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "computable", "org/jetbrains/plugins/groovy/lang/psi/impl/InferenceContext$1", "getCachedValue"));
            }
            CachedValuesManager manager = CachedValuesManager.getManager((Project)element.getProject());
            Key key = manager.getKeyForClass(computable.getClass());
            return (T)manager.getCachedValue((UserDataHolder)element, key, () -> {
                if (computable == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "computable", "org/jetbrains/plugins/groovy/lang/psi/impl/InferenceContext$1", "lambda$getCachedValue$0"));
                }
                return CachedValueProvider.Result.create((Object)computable.compute(), (Object[])new Object[]{PsiModificationTracker.MODIFICATION_COUNT});
            }, false);
        }

        @Override
        public <T extends PsiPolyVariantReference> GroovyResolveResult[] multiResolve(@NotNull T ref, boolean incomplete, @NotNull ResolveCache.PolyVariantResolver<T> resolver) {
            if (ref == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ref", "org/jetbrains/plugins/groovy/lang/psi/impl/InferenceContext$1", "multiResolve"));
            }
            if (resolver == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "resolver", "org/jetbrains/plugins/groovy/lang/psi/impl/InferenceContext$1", "multiResolve"));
            }
            ResolveResult[] results2 = ResolveCache.getInstance((Project)ref.getElement().getProject()).resolveWithCaching(ref, resolver, true, incomplete);
            return results2.length == 0 ? GroovyResolveResult.EMPTY_ARRAY : (GroovyResolveResult[])results2;
        }

        @Override
        @Nullable
        public <T extends GroovyPsiElement> PsiType getExpressionType(@NotNull T element, @NotNull Function<T, PsiType> calculator) {
            if (element == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/plugins/groovy/lang/psi/impl/InferenceContext$1", "getExpressionType"));
            }
            if (calculator == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "calculator", "org/jetbrains/plugins/groovy/lang/psi/impl/InferenceContext$1", "getExpressionType"));
            }
            return GroovyPsiManager.getInstance(element.getProject()).getType(element, calculator);
        }
    };

    @Nullable
    public PsiType getVariableType(@NotNull GrReferenceExpression var1);

    public <T> T getCachedValue(@NotNull GroovyPsiElement var1, @NotNull Computable<T> var2);

    public <T extends PsiPolyVariantReference> GroovyResolveResult[] multiResolve(@NotNull T var1, boolean var2, @NotNull ResolveCache.PolyVariantResolver<T> var3);

    @Nullable
    public <T extends GroovyPsiElement> PsiType getExpressionType(@NotNull T var1, @NotNull Function<T, PsiType> var2);

    public static class PartialContext
    implements InferenceContext {
        private final Map<String, PsiType> myTypes;
        private final Map<PsiElement, Map<Object, Object>> myCache;

        public PartialContext(@NotNull Map<String, PsiType> types) {
            if (types == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "types", "org/jetbrains/plugins/groovy/lang/psi/impl/InferenceContext$PartialContext", "<init>"));
            }
            this.myCache = ContainerUtil.newHashMap();
            this.myTypes = types;
        }

        @Override
        @Nullable
        public PsiType getVariableType(@NotNull GrReferenceExpression ref) {
            if (ref == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ref", "org/jetbrains/plugins/groovy/lang/psi/impl/InferenceContext$PartialContext", "getVariableType"));
            }
            return this.myTypes.get(ref.getReferenceName());
        }

        @Override
        public <T> T getCachedValue(@NotNull GroovyPsiElement element, @NotNull Computable<T> computable) {
            if (element == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/plugins/groovy/lang/psi/impl/InferenceContext$PartialContext", "getCachedValue"));
            }
            if (computable == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "computable", "org/jetbrains/plugins/groovy/lang/psi/impl/InferenceContext$PartialContext", "getCachedValue"));
            }
            return this._getCachedValue(element, computable, computable.getClass());
        }

        private <T> T _getCachedValue(@Nullable PsiElement element, @NotNull Computable<T> computable, @NotNull Object key) {
            if (computable == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "computable", "org/jetbrains/plugins/groovy/lang/psi/impl/InferenceContext$PartialContext", "_getCachedValue"));
            }
            if (key == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "org/jetbrains/plugins/groovy/lang/psi/impl/InferenceContext$PartialContext", "_getCachedValue"));
            }
            HashMap map = this.myCache.get(element);
            if (map == null) {
                map = ContainerUtil.newHashMap();
                this.myCache.put(element, map);
            }
            if (map.containsKey(key)) {
                return (T)map.get(key);
            }
            Object result = computable.compute();
            map.put(key, result);
            return (T)result;
        }

        @Override
        @NotNull
        public <T extends PsiPolyVariantReference> GroovyResolveResult[] multiResolve(@NotNull T ref, boolean incomplete, @NotNull ResolveCache.PolyVariantResolver<T> resolver) {
            if (ref == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ref", "org/jetbrains/plugins/groovy/lang/psi/impl/InferenceContext$PartialContext", "multiResolve"));
            }
            if (resolver == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "resolver", "org/jetbrains/plugins/groovy/lang/psi/impl/InferenceContext$PartialContext", "multiResolve"));
            }
            GroovyResolveResult[] groovyResolveResultArray = (GroovyResolveResult[])this._getCachedValue(ref.getElement(), () -> {
                if (ref == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ref", "org/jetbrains/plugins/groovy/lang/psi/impl/InferenceContext$PartialContext", "lambda$multiResolve$1"));
                }
                if (resolver == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "resolver", "org/jetbrains/plugins/groovy/lang/psi/impl/InferenceContext$PartialContext", "lambda$multiResolve$1"));
                }
                Pair key = Pair.create((Object)ref, (Object)incomplete);
                GroovyResolveResult[] results2 = (GroovyResolveResult[])RecursionManager.doPreventingRecursion((Object)key, (boolean)true, () -> {
                    if (resolver == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "resolver", "org/jetbrains/plugins/groovy/lang/psi/impl/InferenceContext$PartialContext", "lambda$null$0"));
                    }
                    if (ref == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ref", "org/jetbrains/plugins/groovy/lang/psi/impl/InferenceContext$PartialContext", "lambda$null$0"));
                    }
                    return (GroovyResolveResult[])resolver.resolve(ref, incomplete);
                });
                return results2 == null ? GroovyResolveResult.EMPTY_ARRAY : results2;
            }, Pair.create((Object)incomplete, resolver.getClass()));
            if (groovyResolveResultArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/psi/impl/InferenceContext$PartialContext", "multiResolve"));
            }
            return groovyResolveResultArray;
        }

        @Override
        @Nullable
        public <T extends GroovyPsiElement> PsiType getExpressionType(@NotNull T element, @NotNull Function<T, PsiType> calculator) {
            if (element == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/plugins/groovy/lang/psi/impl/InferenceContext$PartialContext", "getExpressionType"));
            }
            if (calculator == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "calculator", "org/jetbrains/plugins/groovy/lang/psi/impl/InferenceContext$PartialContext", "getExpressionType"));
            }
            return (PsiType)this._getCachedValue(element, () -> {
                if (calculator == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "calculator", "org/jetbrains/plugins/groovy/lang/psi/impl/InferenceContext$PartialContext", "lambda$getExpressionType$2"));
                }
                if (element == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/plugins/groovy/lang/psi/impl/InferenceContext$PartialContext", "lambda$getExpressionType$2"));
                }
                return (PsiType)calculator.fun((Object)element);
            }, "type");
        }
    }
}

