/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.psi.impl.statements.expressions;

import com.intellij.lang.ASTNode;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiPolyVariantReference;
import com.intellij.psi.PsiRecursiveElementWalkingVisitor;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiType;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.ResolveState;
import com.intellij.psi.impl.source.resolve.ResolveCache;
import com.intellij.psi.scope.ElementClassHint;
import com.intellij.psi.scope.PsiScopeProcessor;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.ConcurrencyUtil;
import com.intellij.util.SmartList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.ConcurrentMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.lang.lexer.GroovyTokenTypes;
import org.jetbrains.plugins.groovy.lang.lexer.TokenSets;
import org.jetbrains.plugins.groovy.lang.psi.GroovyElementVisitor;
import org.jetbrains.plugins.groovy.lang.psi.api.GroovyResolveResult;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrAssignmentExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrParenthesizedExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrReferenceExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrTupleExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.path.GrIndexProperty;
import org.jetbrains.plugins.groovy.lang.psi.dataFlow.types.TypeInferenceHelper;
import org.jetbrains.plugins.groovy.lang.psi.impl.GroovyFileImpl;
import org.jetbrains.plugins.groovy.lang.psi.impl.statements.GrOperatorExpressionImpl;
import org.jetbrains.plugins.groovy.lang.psi.impl.statements.expressions.TypesUtil;
import org.jetbrains.plugins.groovy.lang.psi.impl.synthetic.GrBindingVariable;
import org.jetbrains.plugins.groovy.lang.resolve.DependentResolver;
import org.jetbrains.plugins.groovy.lang.resolve.ResolveUtil;
import org.jetbrains.plugins.groovy.lang.resolve.processors.DynamicMembersHint;

public class GrAssignmentExpressionImpl
extends GrOperatorExpressionImpl
implements GrAssignmentExpression {
    private static final ResolveCache.PolyVariantResolver<GrAssignmentExpression> RESOLVER = new DependentResolver<GrAssignmentExpression>(){

        @Override
        public Collection<PsiPolyVariantReference> collectDependencies(@NotNull GrAssignmentExpression ref) {
            if (ref == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ref", "org/jetbrains/plugins/groovy/lang/psi/impl/statements/expressions/GrAssignmentExpressionImpl$1", "collectDependencies"));
            }
            SmartList result = new SmartList();
            ref.accept((PsiElementVisitor)new PsiRecursiveElementWalkingVisitor((List)result){
                final /* synthetic */ List val$result;
                {
                    this.val$result = list;
                }

                public void visitElement(PsiElement element) {
                    GrExpression operand;
                    if (element instanceof GrAssignmentExpression) {
                        super.visitElement(element);
                    } else if (element instanceof GrParenthesizedExpression && (operand = ((GrParenthesizedExpression)element).getOperand()) != null) {
                        super.visitElement((PsiElement)operand);
                    }
                }

                protected void elementFinished(PsiElement element) {
                    if (element instanceof GrAssignmentExpression) {
                        this.val$result.add((GrAssignmentExpression)element);
                    }
                }
            });
            return result;
        }

        @Override
        @NotNull
        public ResolveResult[] doResolve(@NotNull GrAssignmentExpression assignmentExpression, boolean incomplete) {
            if (assignmentExpression == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "assignmentExpression", "org/jetbrains/plugins/groovy/lang/psi/impl/statements/expressions/GrAssignmentExpressionImpl$1", "doResolve"));
            }
            IElementType opType = assignmentExpression.getOperationTokenType();
            if (opType == GroovyTokenTypes.mASSIGN) {
                if (GroovyResolveResult.EMPTY_ARRAY == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/psi/impl/statements/expressions/GrAssignmentExpressionImpl$1", "doResolve"));
                }
                return GroovyResolveResult.EMPTY_ARRAY;
            }
            PsiType lType = assignmentExpression.getLeftType();
            if (lType == null) {
                if (GroovyResolveResult.EMPTY_ARRAY == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/psi/impl/statements/expressions/GrAssignmentExpressionImpl$1", "doResolve"));
                }
                return GroovyResolveResult.EMPTY_ARRAY;
            }
            PsiType rType = assignmentExpression.getRightType();
            IElementType operatorToken = TokenSets.ASSIGNMENTS_TO_OPERATORS.get(opType);
            ResolveResult[] resolveResultArray = TypesUtil.getOverloadedOperatorCandidates(lType, operatorToken, assignmentExpression, new PsiType[]{rType});
            if (resolveResultArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/psi/impl/statements/expressions/GrAssignmentExpressionImpl$1", "doResolve"));
            }
            return resolveResultArray;
        }
    };

    public GrAssignmentExpressionImpl(@NotNull ASTNode node) {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "org/jetbrains/plugins/groovy/lang/psi/impl/statements/expressions/GrAssignmentExpressionImpl", "<init>"));
        }
        super(node);
    }

    public String toString() {
        return "Assignment expression";
    }

    @Override
    @NotNull
    public GrExpression getLValue() {
        GrExpression grExpression = Objects.requireNonNull(GrAssignmentExpressionImpl.findExpressionChild(this));
        if (grExpression == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/psi/impl/statements/expressions/GrAssignmentExpressionImpl", "getLValue"));
        }
        return grExpression;
    }

    @Override
    @Nullable
    public GrExpression getRValue() {
        GrExpression[] exprs = (GrExpression[])this.findChildrenByClass(GrExpression.class);
        if (exprs.length > 1) {
            return exprs[1];
        }
        return null;
    }

    @Override
    @NotNull
    public PsiElement getOperationToken() {
        PsiElement psiElement = this.findNotNullChildByType(TokenSets.ASSIGNMENTS);
        if (psiElement == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/psi/impl/statements/expressions/GrAssignmentExpressionImpl", "getOperationToken"));
        }
        return psiElement;
    }

    @Override
    public void accept(GroovyElementVisitor visitor2) {
        visitor2.visitAssignmentExpression(this);
    }

    @Override
    @NotNull
    public GroovyResolveResult[] multiResolve(boolean incompleteCode) {
        GroovyResolveResult[] groovyResolveResultArray = TypeInferenceHelper.getCurrentContext().multiResolve(this, incompleteCode, RESOLVER);
        if (groovyResolveResultArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/psi/impl/statements/expressions/GrAssignmentExpressionImpl", "multiResolve"));
        }
        return groovyResolveResultArray;
    }

    public PsiReference getReference() {
        IElementType operationToken = this.getOperationTokenType();
        if (operationToken == GroovyTokenTypes.mASSIGN) {
            return null;
        }
        return this;
    }

    public boolean processDeclarations(@NotNull PsiScopeProcessor processor, @NotNull ResolveState state, PsiElement lastParent, @NotNull PsiElement place) {
        if (processor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "org/jetbrains/plugins/groovy/lang/psi/impl/statements/expressions/GrAssignmentExpressionImpl", "processDeclarations"));
        }
        if (state == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "org/jetbrains/plugins/groovy/lang/psi/impl/statements/expressions/GrAssignmentExpressionImpl", "processDeclarations"));
        }
        if (place == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "place", "org/jetbrains/plugins/groovy/lang/psi/impl/statements/expressions/GrAssignmentExpressionImpl", "processDeclarations"));
        }
        ElementClassHint classHint = (ElementClassHint)processor.getHint(ElementClassHint.KEY);
        if (!ResolveUtil.shouldProcessProperties(classHint)) {
            return true;
        }
        DynamicMembersHint dynamicMembersHint = (DynamicMembersHint)processor.getHint(DynamicMembersHint.KEY);
        if (dynamicMembersHint != null && !dynamicMembersHint.shouldProcessProperties()) {
            return true;
        }
        if (!(this.getParent() instanceof GroovyFileImpl)) {
            return true;
        }
        GroovyFileImpl file = (GroovyFileImpl)this.getParent();
        if (!file.isInScriptBody(lastParent, place)) {
            return true;
        }
        GrExpression lValue = this.getLValue();
        if (!GrAssignmentExpressionImpl.processLValue(processor, state, place, file, lValue)) {
            return false;
        }
        if (lValue instanceof GrTupleExpression) {
            for (GrExpression expression : ((GrTupleExpression)lValue).getExpressions()) {
                if (GrAssignmentExpressionImpl.processLValue(processor, state, place, file, expression)) continue;
                return false;
            }
        }
        return true;
    }

    private static boolean processLValue(@NotNull PsiScopeProcessor processor, @NotNull ResolveState state, @NotNull PsiElement place, @NotNull GroovyFileImpl file, @NotNull GrExpression lValue) {
        if (processor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "org/jetbrains/plugins/groovy/lang/psi/impl/statements/expressions/GrAssignmentExpressionImpl", "processLValue"));
        }
        if (state == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "org/jetbrains/plugins/groovy/lang/psi/impl/statements/expressions/GrAssignmentExpressionImpl", "processLValue"));
        }
        if (place == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "place", "org/jetbrains/plugins/groovy/lang/psi/impl/statements/expressions/GrAssignmentExpressionImpl", "processLValue"));
        }
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "org/jetbrains/plugins/groovy/lang/psi/impl/statements/expressions/GrAssignmentExpressionImpl", "processLValue"));
        }
        if (lValue == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "lValue", "org/jetbrains/plugins/groovy/lang/psi/impl/statements/expressions/GrAssignmentExpressionImpl", "processLValue"));
        }
        if (!(lValue instanceof GrReferenceExpression)) {
            return true;
        }
        GrReferenceExpression lReference = (GrReferenceExpression)lValue;
        if (lReference.isQualified()) {
            return true;
        }
        String name = lReference.getReferenceName();
        if (name == null) {
            return true;
        }
        String hintName = ResolveUtil.getNameHint(processor);
        if (hintName != null && !name.equals(hintName)) {
            return true;
        }
        if (lReference != place && lReference.resolve() != null && !(lReference.resolve() instanceof GrBindingVariable)) {
            return true;
        }
        ConcurrentMap<String, GrBindingVariable> bindings = file.getBindings();
        GrBindingVariable variable = (GrBindingVariable)bindings.get(name);
        if (variable == null) {
            variable = (GrBindingVariable)ConcurrencyUtil.cacheOrGet(bindings, (Object)name, (Object)new GrBindingVariable(file, name, true));
        }
        if (!variable.hasWriteAccess()) {
            return true;
        }
        return processor.execute((PsiElement)variable, state);
    }

    @Override
    @Nullable
    public PsiType getLeftType() {
        GrExpression lValue = this.getLValue();
        if (lValue instanceof GrIndexProperty) {
            return ((GrIndexProperty)lValue).getGetterType();
        }
        if (lValue instanceof GrReferenceExpression) {
            return ((GrReferenceExpression)lValue).getRValueType();
        }
        return lValue.getType();
    }

    @Override
    @Nullable
    public PsiType getRightType() {
        GrExpression rValue = this.getRValue();
        return rValue == null ? null : rValue.getType();
    }

    @Override
    @Nullable
    public PsiType getType() {
        if (TokenSets.ASSIGNMENTS_TO_OPERATORS.containsKey(this.getOperationTokenType())) {
            return super.getType();
        }
        return this.getRightType();
    }
}

