/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.psi.impl.statements.expressions;

import com.intellij.lang.ASTNode;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiPolyVariantReference;
import com.intellij.psi.PsiRecursiveElementWalkingVisitor;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiType;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.impl.source.resolve.ResolveCache;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.SmartList;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.lang.lexer.TokenSets;
import org.jetbrains.plugins.groovy.lang.psi.GroovyElementVisitor;
import org.jetbrains.plugins.groovy.lang.psi.api.GroovyResolveResult;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrBinaryExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrParenthesizedExpression;
import org.jetbrains.plugins.groovy.lang.psi.dataFlow.types.TypeInferenceHelper;
import org.jetbrains.plugins.groovy.lang.psi.impl.statements.GrOperatorExpressionImpl;
import org.jetbrains.plugins.groovy.lang.psi.impl.statements.expressions.TypesUtil;
import org.jetbrains.plugins.groovy.lang.resolve.DependentResolver;

public abstract class GrBinaryExpressionImpl
extends GrOperatorExpressionImpl
implements GrBinaryExpression {
    private static final ResolveCache.PolyVariantResolver<GrBinaryExpressionImpl> RESOLVER = new DependentResolver<GrBinaryExpressionImpl>(){

        @Override
        public Collection<PsiPolyVariantReference> collectDependencies(@NotNull GrBinaryExpressionImpl expression) {
            if (expression == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/plugins/groovy/lang/psi/impl/statements/expressions/GrBinaryExpressionImpl$1", "collectDependencies"));
            }
            SmartList subExpressions = new SmartList();
            expression.getLeftOperand().accept((PsiElementVisitor)new PsiRecursiveElementWalkingVisitor((List)subExpressions){
                final /* synthetic */ List val$subExpressions;
                {
                    this.val$subExpressions = list;
                }

                public void visitElement(PsiElement element) {
                    GrExpression operand;
                    if (element instanceof GrBinaryExpression) {
                        super.visitElement(element);
                    } else if (element instanceof GrParenthesizedExpression && (operand = ((GrParenthesizedExpression)element).getOperand()) != null) {
                        super.visitElement((PsiElement)operand);
                    }
                }

                protected void elementFinished(PsiElement element) {
                    if (element instanceof GrBinaryExpressionImpl) {
                        this.val$subExpressions.add((GrBinaryExpressionImpl)element);
                    }
                }
            });
            return subExpressions;
        }

        @Override
        @NotNull
        public ResolveResult[] doResolve(@NotNull GrBinaryExpressionImpl binary, boolean incompleteCode) {
            if (binary == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "binary", "org/jetbrains/plugins/groovy/lang/psi/impl/statements/expressions/GrBinaryExpressionImpl$1", "doResolve"));
            }
            IElementType opType = binary.getOperationTokenType();
            PsiType lType = binary.getLeftType();
            if (lType == null) {
                if (GroovyResolveResult.EMPTY_ARRAY == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/psi/impl/statements/expressions/GrBinaryExpressionImpl$1", "doResolve"));
                }
                return GroovyResolveResult.EMPTY_ARRAY;
            }
            PsiType rType = binary.getRightType();
            ResolveResult[] resolveResultArray = TypesUtil.getOverloadedOperatorCandidates(lType, opType, binary, new PsiType[]{rType}, incompleteCode);
            if (resolveResultArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/psi/impl/statements/expressions/GrBinaryExpressionImpl$1", "doResolve"));
            }
            return resolveResultArray;
        }
    };

    @Override
    @Nullable
    public PsiType getRightType() {
        GrExpression rightOperand = this.getRightOperand();
        return rightOperand == null ? null : rightOperand.getType();
    }

    @Override
    @Nullable
    public PsiType getLeftType() {
        return this.getLeftOperand().getType();
    }

    public GrBinaryExpressionImpl(@NotNull ASTNode node) {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "org/jetbrains/plugins/groovy/lang/psi/impl/statements/expressions/GrBinaryExpressionImpl", "<init>"));
        }
        super(node);
    }

    @Override
    @NotNull
    public GrExpression getLeftOperand() {
        GrExpression grExpression = (GrExpression)this.findNotNullChildByClass(GrExpression.class);
        if (grExpression == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/psi/impl/statements/expressions/GrBinaryExpressionImpl", "getLeftOperand"));
        }
        return grExpression;
    }

    @Override
    @Nullable
    public GrExpression getRightOperand() {
        PsiElement last = this.getLastChild();
        return last instanceof GrExpression ? (GrExpression)last : null;
    }

    @Override
    @NotNull
    public PsiElement getOperationToken() {
        PsiElement psiElement = this.findNotNullChildByType(TokenSets.BINARY_OP_SET);
        if (psiElement == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/psi/impl/statements/expressions/GrBinaryExpressionImpl", "getOperationToken"));
        }
        return psiElement;
    }

    @Override
    public void accept(GroovyElementVisitor visitor2) {
        visitor2.visitBinaryExpression(this);
    }

    @Override
    @NotNull
    public GroovyResolveResult[] multiResolve(boolean incompleteCode) {
        GroovyResolveResult[] groovyResolveResultArray = TypeInferenceHelper.getCurrentContext().multiResolve(this, incompleteCode, RESOLVER);
        if (groovyResolveResultArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/psi/impl/statements/expressions/GrBinaryExpressionImpl", "multiResolve"));
        }
        return groovyResolveResultArray;
    }

    public PsiReference getReference() {
        return this;
    }
}

