/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.psi.stubs.elements;

import com.intellij.psi.stubs.StubElement;
import com.intellij.psi.stubs.StubInputStream;
import com.intellij.psi.stubs.StubOutputStream;
import com.intellij.util.io.StringRef;
import java.io.IOException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.lang.psi.api.auxiliary.modifiers.annotation.GrAnnotationMemberValue;
import org.jetbrains.plugins.groovy.lang.psi.api.auxiliary.modifiers.annotation.GrAnnotationNameValuePair;
import org.jetbrains.plugins.groovy.lang.psi.impl.auxiliary.annotation.GrAnnotationNameValuePairImpl;
import org.jetbrains.plugins.groovy.lang.psi.stubs.GrNameValuePairStub;
import org.jetbrains.plugins.groovy.lang.psi.stubs.elements.GrStubElementType;

public class GrNameValuePairElementType
extends GrStubElementType<GrNameValuePairStub, GrAnnotationNameValuePair> {
    public GrNameValuePairElementType() {
        super("Annotation name value pair");
    }

    public void serialize(@NotNull GrNameValuePairStub stub, @NotNull StubOutputStream dataStream) throws IOException {
        if (stub == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "stub", "org/jetbrains/plugins/groovy/lang/psi/stubs/elements/GrNameValuePairElementType", "serialize"));
        }
        if (dataStream == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataStream", "org/jetbrains/plugins/groovy/lang/psi/stubs/elements/GrNameValuePairElementType", "serialize"));
        }
        dataStream.writeName(stub.getName());
        String value = stub.getValue();
        boolean hasValue = value != null;
        dataStream.writeBoolean(hasValue);
        if (hasValue) {
            dataStream.writeUTFFast(value);
        }
    }

    @NotNull
    public GrNameValuePairStub deserialize(@NotNull StubInputStream dataStream, StubElement parentStub) throws IOException {
        if (dataStream == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataStream", "org/jetbrains/plugins/groovy/lang/psi/stubs/elements/GrNameValuePairElementType", "deserialize"));
        }
        GrNameValuePairStub grNameValuePairStub = new GrNameValuePairStub(parentStub, StringRef.toString((StringRef)dataStream.readName()), dataStream.readBoolean() ? dataStream.readUTFFast() : null);
        if (grNameValuePairStub == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/psi/stubs/elements/GrNameValuePairElementType", "deserialize"));
        }
        return grNameValuePairStub;
    }

    public GrAnnotationNameValuePair createPsi(@NotNull GrNameValuePairStub stub) {
        if (stub == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "stub", "org/jetbrains/plugins/groovy/lang/psi/stubs/elements/GrNameValuePairElementType", "createPsi"));
        }
        return new GrAnnotationNameValuePairImpl(stub);
    }

    @NotNull
    public GrNameValuePairStub createStub(@NotNull GrAnnotationNameValuePair psi, StubElement parentStub) {
        if (psi == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psi", "org/jetbrains/plugins/groovy/lang/psi/stubs/elements/GrNameValuePairElementType", "createStub"));
        }
        String name = psi.getName();
        GrAnnotationMemberValue value = psi.getValue();
        GrNameValuePairStub grNameValuePairStub = new GrNameValuePairStub(parentStub, name, value == null ? null : value.getText());
        if (grNameValuePairStub == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/psi/stubs/elements/GrNameValuePairElementType", "createStub"));
        }
        return grNameValuePairStub;
    }
}

