/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.psi.util;

import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiMethodUtil;
import com.intellij.psi.util.PsiTreeUtil;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.lang.psi.GroovyFile;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.GrTypeDefinition;
import org.jetbrains.plugins.groovy.lang.psi.impl.synthetic.GroovyScriptClass;

public class GroovyRunnerPsiUtil {
    @Nullable
    public static PsiClass getRunningClass(@Nullable PsiElement element) {
        if (element == null) {
            return null;
        }
        if (DumbService.isDumb((Project)element.getProject())) {
            return null;
        }
        PsiFile file = element.getContainingFile();
        if (!(file instanceof GroovyFile)) {
            return null;
        }
        PsiClass clazz = (PsiClass)PsiTreeUtil.getParentOfType((PsiElement)element, PsiClass.class);
        while (clazz != null) {
            if (GroovyRunnerPsiUtil.canBeRunByGroovy(clazz)) {
                return clazz;
            }
            clazz = (PsiClass)PsiTreeUtil.getParentOfType((PsiElement)clazz, PsiClass.class);
        }
        if (((GroovyFile)file).isScript()) {
            return ((GroovyFile)file).getScriptClass();
        }
        PsiClass[] classes = ((GroovyFile)file).getClasses();
        if (classes.length > 0) {
            return classes[0];
        }
        return null;
    }

    public static boolean isRunnable(@Nullable PsiClass psiClass) {
        if (psiClass == null) {
            return false;
        }
        PsiClass runnable = JavaPsiFacade.getInstance((Project)psiClass.getProject()).findClass("java.lang.Runnable", psiClass.getResolveScope());
        if (runnable == null) {
            return false;
        }
        return psiClass instanceof GrTypeDefinition && !(psiClass instanceof PsiAnonymousClass) && !psiClass.isInterface() && psiClass.isInheritor(runnable, true);
    }

    public static boolean canBeRunByGroovy(PsiClass psiClass) {
        return psiClass instanceof GroovyScriptClass || GroovyRunnerPsiUtil.isRunnable(psiClass) || psiClass instanceof GrTypeDefinition && PsiMethodUtil.hasMainMethod((PsiClass)psiClass);
    }
}

