/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.resolve.ast.builder;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiClass;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.lang.psi.impl.GrAnnotationUtil;
import org.jetbrains.plugins.groovy.transformations.AstTransformationSupport;

public abstract class BuilderAnnotationContributor
implements AstTransformationSupport {
    public static final String BUILDER_PACKAGE = "groovy.transform.builder";
    public static final String BUILDER_FQN = "groovy.transform.builder.Builder";
    public static final String ORIGIN_INFO = "via @Builder";
    public static final String STRATEGY_ATTRIBUTE = "builderStrategy";

    @Contract(value="null, _ -> false")
    public static boolean isApplicable(@Nullable PsiAnnotation annotation, @NotNull String strategy) {
        if (strategy == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "strategy", "org/jetbrains/plugins/groovy/lang/resolve/ast/builder/BuilderAnnotationContributor", "isApplicable"));
        }
        if (annotation == null) {
            return false;
        }
        PsiClass aClass = GrAnnotationUtil.inferClassAttribute(annotation, STRATEGY_ATTRIBUTE);
        if (aClass == null) {
            return false;
        }
        return StringUtil.getQualifiedName((String)BUILDER_PACKAGE, (String)strategy).equals(aClass.getQualifiedName());
    }
}

